/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.AbstractSubpanel;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemHistoryPanel
extends AbstractSubpanel<ItemsGrid<ItemsGrid.ItemsGridSlot, ItemsGrid.MouseContext>> {
    public ItemHistoryPanel() {
        this.grid = new ItemsGrid<ItemsGrid.ItemsGridSlot, ItemsGrid.MouseContext>(){
            protected List<ItemsGrid.ItemsGridSlot> gridMask;

            @Override
            protected void onGridChanged() {
                this.gridMask = null;
                super.onGridChanged();
            }

            @Override
            public List<ItemsGrid.ItemsGridSlot> getMask() {
                if (this.gridMask == null) {
                    this.gridMask = new ArrayList<ItemsGrid.ItemsGridSlot>();
                    for (int slotIndex = 0; slotIndex < Math.min(this.size(), this.rows * this.columns); ++slotIndex) {
                        this.gridMask.add(new ItemsGrid.ItemsGridSlot(slotIndex, slotIndex, this.getItem(slotIndex)));
                    }
                }
                return this.gridMask;
            }

            @Override
            protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
                Object hovered = this.getSlotMouseOver(mousex, mousey);
                if (hovered != null) {
                    return new ItemsGrid.MouseContext(((ItemsGrid.ItemsGridSlot)hovered).slotIndex, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex / this.columns, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex % this.columns);
                }
                return null;
            }
        };
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, 0L);
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.grid.size() > 0) {
            super.draw(mousex, mousey);
        }
    }

    @Override
    public int setPanelWidth(int width) {
        int columns = width / ItemsGrid.SLOT_SIZE;
        int useRows = NEIClientConfig.getIntSetting("inventory.history.useRows");
        int rows = (int)Math.min(Math.ceil((float)this.grid.size() * 1.0f / (float)columns), (double)useRows);
        this.w = width;
        this.h = 8 + ItemsGrid.SLOT_SIZE * Math.max(rows, 1);
        return rows;
    }

    @Override
    public void update() {
        this.splittingLineColor = NEIClientConfig.getSetting("inventory.history.color").getHexValue();
        super.update();
    }

    public void addItem(ItemStack stack) {
        if (stack != null) {
            ItemStack is = StackInfo.withAmount(stack, 0L);
            this.grid.realItems.removeIf(historyStack -> StackInfo.equalItemAndNBT(historyStack, stack, true));
            this.grid.realItems.add(0, is);
            if (this.grid.realItems.size() > Math.max(50, this.grid.rows * this.grid.columns)) {
                this.grid.realItems.remove(this.grid.realItems.size() - 1);
            }
            this.grid.onItemsChanged();
        }
    }
}

