/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.projectblue.BaseIntegration;
import gcewing.projectblue.BaseMod;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    static Map<String, BRBinding> blockRenderers = new HashMap<String, BRBinding>();
    MOD base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();

    public BaseModClient(MOD mod) {
        this.base = mod;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent e) {
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerScreens();
        this.registerRenderers();
        this.registerOther();
        for (BaseIntegration i : ((BaseMod)this.base).integrations) {
            i.registerScreens();
            i.registerRenderers();
            i.registerOtherClient();
        }
        this.registerImplicitBlockRenderers();
        this.registerSavedVillagerSkins();
    }

    void registerImplicitBlockRenderers() {
        for (BaseMod.IBlock block : ((BaseMod)this.base).registeredBlocks) {
            BRBinding b;
            String name = block.getQualifiedRendererClassName();
            if (name == null || (b = this.getBlockRendererForName(name)) == null) continue;
            block.setRenderType(b.id);
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry reg = VillagerRegistry.instance();
        for (BaseMod.VSBinding b : ((BaseMod)this.base).registeredVillagers) {
            reg.registerVillagerSkin(b.id, (ResourceLocation)b.object);
        }
    }

    BRBinding getBlockRendererForName(String name) {
        BRBinding b = blockRenderers.get(name);
        if (b == null) {
            ISimpleBlockRenderingHandler h;
            String initPkgName;
            Class<?> cls = null;
            int i = name.lastIndexOf(".");
            String pkgName = initPkgName = name.substring(0, i);
            String clsName = name.substring(i + 1);
            while (cls == null) {
                try {
                    cls = Class.forName(pkgName + "." + clsName);
                }
                catch (ClassNotFoundException e) {
                    i = pkgName.lastIndexOf(".");
                    if (i < 0) {
                        throw new RuntimeException(String.format("Block renderer class %s not found in %s or containing packages", clsName, initPkgName));
                    }
                    pkgName = pkgName.substring(0, i);
                }
            }
            try {
                h = (ISimpleBlockRenderingHandler)cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            b = new BRBinding();
            b.id = RenderingRegistry.getNextAvailableRenderId();
            b.object = h;
            RenderingRegistry.registerBlockHandler((int)b.id, (ISimpleBlockRenderingHandler)h);
            blockRenderers.put(name, b);
        }
        return b;
    }

    String qualifyName(String name) {
        return this.getClass().getPackage().getName() + "." + name;
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum id, Class<? extends GuiScreen> cls) {
        this.addScreen(id.ordinal(), cls);
    }

    public void addScreen(int id, Class<? extends GuiScreen> cls) {
        this.screenClasses.put(id, cls);
    }

    void registerRenderers() {
    }

    void addBlockRenderer(BaseMod.IBlock block, ISimpleBlockRenderingHandler renderer) {
        this.addBlockRenderer(renderer, block);
    }

    void addBlockRenderer(ISimpleBlockRenderingHandler renderer, BaseMod.IBlock ... blocks) {
        int renderID = RenderingRegistry.getNextAvailableRenderId();
        for (BaseMod.IBlock block : blocks) {
            System.out.printf("BaseModClient: Registering %s with id %s for %s\n", renderer, renderID, block);
            block.setRenderType(renderID);
            RenderingRegistry.registerBlockHandler((int)renderID, (ISimpleBlockRenderingHandler)renderer);
        }
    }

    void addItemRenderer(Item item, IItemRenderer renderer) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)renderer);
    }

    void addItemRenderer(Block block, IItemRenderer renderer) {
        MinecraftForgeClient.registerItemRenderer((Item)block.func_149650_a(0, null, 0), (IItemRenderer)renderer);
    }

    void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    void addEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)renderer);
    }

    public static void openClientGui(GuiScreen gui) {
        FMLClientHandler.instance().getClient().func_147108_a(gui);
    }

    public ResourceLocation textureLocation(String path) {
        return ((BaseMod)this.base).resourceLocation("textures/" + path);
    }

    public void bindTexture(String path) {
        BaseModClient.bindTexture(this.textureLocation(path));
    }

    public static void bindTexture(ResourceLocation rsrc) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(rsrc);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre e) {
        int type = e.map.func_130086_a();
        System.out.printf("BaseModClient.onTextureStitchPre: for texture type %s\n", type);
        switch (type) {
            case 0: {
                this.registerBlockIcons((IIconRegister)e.map);
                break;
            }
            case 1: {
                this.registerItemIcons((IIconRegister)e.map);
            }
        }
    }

    void registerBlockIcons(IIconRegister reg) {
    }

    void registerItemIcons(IIconRegister reg) {
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return ((BaseMod)this.base).getServerGuiElement(id, player, world, x, y, z);
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends GuiScreen> scrnCls;
        int param = id >> 16;
        id &= 0xFFFF;
        Object result = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", id);
        }
        if ((scrnCls = this.screenClasses.get(id)) != null) {
            block14: {
                Class<? extends Container> contCls;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", scrnCls);
                }
                if ((contCls = ((BaseMod)this.base).containerClasses.get(id)) != null) {
                    try {
                        Object cont;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", contCls);
                        }
                        Constructor<? extends GuiScreen> ctor = scrnCls.getConstructor(contCls);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((cont = ((BaseMod)this.base).createGuiElement(contCls, player, world, x, y, z, param)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            result = ctor.newInstance(cont);
                        }
                        catch (Exception e) {
                            BaseMod.reportExceptionCause(e);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                result = ((BaseMod)this.base).createGuiElement(scrnCls, player, world, x, y, z, param);
            }
        } else {
            result = this.getGuiScreen(id, player, world, x, y, z, param);
        }
        ((BaseMod)this.base).setModOf(result);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", result);
        }
        return result;
    }

    GuiScreen getGuiScreen(int id, EntityPlayer player, World world, int x, int y, int z, int param) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, id);
        return null;
    }

    static class BRBinding
    extends IDBinding<ISimpleBlockRenderingHandler> {
        BRBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }
}

