/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import ru.timeconqueror.timecore.api.reflection.ReflectionHelper;

public class UnlockedConstructor<T> {
    private final Constructor<T> c;

    public UnlockedConstructor(Constructor<T> c) {
        this.c = c;
        ReflectionHelper.setAccessible(c);
    }

    public T newInstance(Object ... initParams) {
        try {
            return this.c.newInstance(initParams);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Constructor<T> getConstructor() {
        return this.c;
    }

    public String toString() {
        return this.c.toString();
    }
}

