/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.drawable.BufferBuilder;
import com.cleanroommc.modularui.utils.GlStateManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Platform {
    public static final ItemStack EMPTY_STACK = null;

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static EntityPlayerSP getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getKeyDisplay(KeyBinding keyBinding) {
        return GameSettings.func_74298_c((int)keyBinding.func_151463_i());
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || stack.field_77994_a <= 0;
    }

    public static ItemStack copyStack(ItemStack stack) {
        return Platform.isStackEmpty(stack) ? EMPTY_STACK : stack.func_77946_l();
    }

    public static void startDrawing(DrawMode drawMode, VertexFormat format, Consumer<BufferBuilder> bufferBuilder) {
        Tessellator tessellator = Tessellator.field_78398_a;
        BufferBuilder buffer = BufferBuilder.bufferbuilder;
        tessellator.func_78371_b(drawMode.mode);
        bufferBuilder.accept(buffer);
        tessellator.func_78381_a();
    }

    public static void setupDrawColor() {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
    }

    public static void setupDrawTex(ResourceLocation texture) {
        Platform.setupDrawTex();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void setupDrawTex(int textureId) {
        Platform.setupDrawTex();
        GlStateManager.bindTexture(textureId);
    }

    public static void setupDrawTex() {
        GlStateManager.enableTexture2D();
        GlStateManager.enableAlpha();
        GlStateManager.disableBlend();
    }

    public static void setupDrawGradient() {
        Platform.setupDrawGradient(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    public static void setupDrawGradient(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor destFactorAlpha) {
        GlStateManager.tryBlendFuncSeparate(srcFactor, destFactor, srcFactorAlpha, destFactorAlpha);
        GlStateManager.shadeModel(7425);
    }

    public static void endDrawGradient() {
        GlStateManager.shadeModel(7424);
    }

    public static void setupDrawItem() {
        Platform.setupDrawTex();
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74520_c();
        GlStateManager.enableDepth();
    }

    public static void endDrawItem() {
        RenderHelper.func_74518_a();
        GlStateManager.disableDepth();
    }

    public static void setupDrawFont() {
        Platform.setupDrawTex();
    }

    public static enum DrawMode {
        QUADS(7),
        POINTS(0),
        LINES(1),
        LINE_STRIP(3),
        LINE_LOOP(2),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6);

        public final int mode;

        private DrawMode(int mode) {
            this.mode = mode;
        }
    }

    public static enum VertexFormat {
        POS,
        POS_TEX,
        POS_COLOR,
        POS_TEX_COLOR,
        POS_NORMAL,
        POS_TEX_NORMAL,
        POS_TEX_COLOR_NORMAL,
        POS_TEX_LMAP_COLOR;

    }
}

