/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ParamProfiler {
    private static final boolean isActive = Boolean.getBoolean("logisticspipes.enableParamProfiler");
    private static volatile long minMethodId = 0L;
    private static final Map<Thread, Stack<Entry>> stack = new HashMap<Thread, Stack<Entry>>();
    private static final WeakHashMap<Throwable, ArrayList<Entry>> infoLink = new WeakHashMap();

    public static byte[] handleClass(byte[] bytes) {
        if (!isActive) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        final String className = node.name;
        for (final MethodNode m : node.methods) {
            long methodId;
            boolean isConst;
            final String methodName = m.name;
            final String methodDesc = m.desc;
            boolean bl = isConst = methodName.contains("<") || methodName.contains(">");
            if (isConst) continue;
            ++minMethodId;
            final ArrayList<String> varList = new ArrayList<String>();
            if (!methodDesc.startsWith("(")) {
                throw new UnsupportedOperationException(methodDesc);
            }
            block6: for (int i = 1; i < methodDesc.length(); ++i) {
                switch (methodDesc.charAt(i)) {
                    case ')': {
                        break block6;
                    }
                    case 'L': {
                        int startA = i;
                        while (methodDesc.charAt(i) != ';') {
                            ++i;
                        }
                        varList.add(methodDesc.substring(startA, i + 1));
                        continue block6;
                    }
                    case '[': {
                        int startB = i;
                        while (methodDesc.charAt(i) == '[') {
                            ++i;
                        }
                        if (methodDesc.charAt(i) == 'L') {
                            while (methodDesc.charAt(i) != ';') {
                                ++i;
                            }
                        }
                        varList.add(methodDesc.substring(startB, i + 1));
                        continue block6;
                    }
                    default: {
                        varList.add(String.valueOf(methodDesc.charAt(i)));
                    }
                }
            }
            final ArrayList catchStatement = new ArrayList();
            MethodNode mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){
                boolean watchForHandling;
                {
                    super(api, access, name, desc, signature, exceptions);
                    this.watchForHandling = false;
                }

                public void visitCode() {
                    super.visitCode();
                    Label l0 = new Label();
                    this.visitLabel(l0);
                    this.visitLdcInsn(methodId);
                    this.visitLdcInsn(className + "+" + methodName + "+" + methodDesc);
                    if ((m.access & 8) != 0) {
                        this.visitInsn(1);
                    } else {
                        this.visitVarInsn(25, 0);
                    }
                    this.visitIntInsn(16, varList.size());
                    this.visitTypeInsn(189, "java/lang/Object");
                    int count = 0;
                    int pos = 0;
                    if ((m.access & 8) == 0) {
                        pos = 1;
                    }
                    for (String varNode : varList) {
                        block15: {
                            block14: {
                                this.visitInsn(89);
                                this.visitIntInsn(16, count++);
                                if (varNode.startsWith("L") || varNode.startsWith("[")) break block14;
                                switch (varNode.charAt(0)) {
                                    case 'I': {
                                        this.visitVarInsn(21, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                                        break block15;
                                    }
                                    case 'J': {
                                        this.visitVarInsn(22, pos);
                                        pos += 2;
                                        this.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                                        break block15;
                                    }
                                    case 'Z': {
                                        this.visitVarInsn(21, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                                        break block15;
                                    }
                                    case 'B': {
                                        this.visitVarInsn(21, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                                        break block15;
                                    }
                                    case 'C': {
                                        this.visitVarInsn(21, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                                        break block15;
                                    }
                                    case 'S': {
                                        this.visitVarInsn(21, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                                        break block15;
                                    }
                                    case 'F': {
                                        this.visitVarInsn(23, pos);
                                        ++pos;
                                        this.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                                        break block15;
                                    }
                                    case 'D': {
                                        this.visitVarInsn(24, pos);
                                        pos += 2;
                                        this.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                                        break block15;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException("'" + varNode + "'");
                                    }
                                }
                            }
                            this.visitVarInsn(25, pos);
                            ++pos;
                        }
                        this.visitInsn(83);
                    }
                    this.visitMethodInsn(184, "logisticspipes/asm/ParamProfiler", "methodStart", "(JLjava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V", false);
                }

                public void visitInsn(int opcode) {
                    if (opcode == 177 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176) {
                        this.visitLdcInsn(methodId);
                        this.visitMethodInsn(184, "logisticspipes/asm/ParamProfiler", "methodEnd", "(J)V", false);
                    }
                    super.visitInsn(opcode);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    catchStatement.add(handler);
                    super.visitTryCatchBlock(start, end, handler, type);
                }

                public void visitLabel(Label label) {
                    this.watchForHandling = false;
                    super.visitLabel(label);
                    if (catchStatement.contains(label)) {
                        this.watchForHandling = true;
                    }
                }

                public void visitVarInsn(int opcode, int var) {
                    super.visitVarInsn(opcode, var);
                    if (this.watchForHandling) {
                        this.watchForHandling = false;
                        Label l = new Label();
                        this.visitLabel(l);
                        this.visitVarInsn(25, var);
                        this.visitMethodInsn(184, "logisticspipes/asm/ParamProfiler", "handleException", "(Ljava/lang/Throwable;)V", false);
                    }
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void methodStart(long id, String name, Object root, Object ... params) {
        if (!isActive) {
            return;
        }
        Stack access = stack.computeIfAbsent(Thread.currentThread(), k -> new Stack());
        access.push(new Entry(id, name, root, params));
    }

    public static void methodEnd(long id) {
        if (!isActive) {
            return;
        }
        Stack<Entry> access = stack.get(Thread.currentThread());
        if (access == null || access.isEmpty()) {
            return;
        }
        Entry exit = access.pop();
        if (exit.id != id) {
            while (!access.isEmpty() && access.peek().id != id) {
                access.pop();
            }
            if (!access.isEmpty()) {
                access.pop();
            }
        }
    }

    public static void handleException(Throwable t) {
        Stack<Entry> access = stack.get(Thread.currentThread());
        infoLink.put(t, new ArrayList<Entry>(access));
    }

    public static WeakHashMap<Throwable, ArrayList<Entry>> getInfoLink() {
        return infoLink;
    }

    public static class Entry {
        private final long id;
        private final String name;
        private final Object root;
        private final Object[] params;

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Object getRoot() {
            return this.root;
        }

        public Object[] getParams() {
            return this.params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$root = this.getRoot();
            Object other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            return Arrays.deepEquals(this.getParams(), other.getParams());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParams());
            return result;
        }

        public String toString() {
            return "ParamProfiler.Entry(id=" + this.getId() + ", name=" + this.getName() + ", root=" + this.getRoot() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
        }

        public Entry(long id, String name, Object root, Object[] params) {
            this.id = id;
            this.name = name;
            this.root = root;
            this.params = params;
        }
    }
}

