/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.common.OreDictHelper;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.bogosorter.common.sort.color.ItemColorHelper;
import com.cleanroommc.bogosorter.compat.Mods;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.items.MetaGeneratedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCompareHelper {
    private static final Pattern SLAB_PATTERN = Pattern.compile(".*Slab([A-Z].*)?");
    private static final Pattern STAIR_PATTERN = Pattern.compile(".*Stairs?([A-Z].*)?");
    private static final Pattern PIPE_PATTERN = Pattern.compile(".*Pipe([A-Z].*)?");
    private static final Pattern CABLE_PATTERN = Pattern.compile(".*Cable([A-Z].*)?");
    private static final Pattern WIRE_PATTERN = Pattern.compile(".*Wire([A-Z].*)?");
    private static final Pattern FORMATTING_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-OR]");

    public static String getMod(ItemStack item) {
        String loc = item.func_77973_b().delegate.name();
        if (loc == null) {
            return "";
        }
        return loc.split(":")[0].toLowerCase();
    }

    public static String getId(ItemStack item) {
        String loc = item.func_77973_b().delegate.name();
        if (loc == null) {
            return "";
        }
        return loc.split(":")[1].toLowerCase();
    }

    public static int getMeta(ItemStack item) {
        return item.func_77960_j();
    }

    public static NBTTagCompound getNbt(ItemStack item) {
        return item.func_77978_p();
    }

    public static float getSaturation(ItemStack item) {
        if (item.func_77973_b() instanceof ItemFood) {
            return ((ItemFood)item.func_77973_b()).func_150906_h(item);
        }
        if (Mods.GT5u.isLoaded() && item.func_77973_b() instanceof MetaGeneratedItem) {
            MetaGeneratedItem valueItem = (MetaGeneratedItem)item.func_77973_b();
            IFoodStat stats = (IFoodStat)valueItem.getFoodValues(item);
            return stats.getSaturation(null, item, null);
        }
        return Float.MIN_VALUE;
    }

    public static int getHunger(ItemStack item) {
        if (item.func_77973_b() instanceof ItemFood) {
            return ((ItemFood)item.func_77973_b()).func_150905_g(item);
        }
        if (Mods.GT5u.isLoaded() && item.func_77973_b() instanceof MetaGeneratedItem) {
            MetaGeneratedItem valueItem = (MetaGeneratedItem)item.func_77973_b();
            IFoodStat stats = (IFoodStat)valueItem.getFoodValues(item);
            return stats.getFoodLevel(null, item, null);
        }
        return Integer.MIN_VALUE;
    }

    public static long getEmcValue(ItemStack item) {
        return EMCHelper.getEmcValue((ItemStack)item);
    }

    public static int compareMod(ItemStack stack1, ItemStack stack2) {
        return ItemCompareHelper.getMod(stack1).compareTo(ItemCompareHelper.getMod(stack2));
    }

    public static int compareId(ItemStack stack1, ItemStack stack2) {
        return ItemCompareHelper.getId(stack1).compareTo(ItemCompareHelper.getId(stack2));
    }

    public static int compareDisplayName(ItemSortContainer stack1, ItemSortContainer stack2) {
        return ItemCompareHelper.compareFormattedString(stack1.getName(), stack2.getName());
    }

    public static int compareDisplayName(ItemStack stack1, ItemStack stack2) {
        return ItemCompareHelper.compareFormattedString(stack1.func_82833_r(), stack2.func_82833_r());
    }

    public static int compareFormattedString(String s1, String s2) {
        return ItemCompareHelper.getTextWithoutFormattingCodes(s1).compareTo(ItemCompareHelper.getTextWithoutFormattingCodes(s2));
    }

    private static String getTextWithoutFormattingCodes(String str) {
        return str == null ? null : FORMATTING_PATTERN.matcher(str).replaceAll("");
    }

    public static int compareMeta(ItemStack stack1, ItemStack stack2) {
        return Integer.compare(ItemCompareHelper.getMeta(stack1), ItemCompareHelper.getMeta(stack2));
    }

    public static int compareCount(ItemStack stack1, ItemStack stack2) {
        return Integer.compare(stack2.field_77994_a, stack1.field_77994_a);
    }

    public static int compareRegistryOrder(ItemStack stack1, ItemStack stack2) {
        Item item1 = stack1.func_77973_b();
        Item item2 = stack2.func_77973_b();
        int id1 = Item.field_150901_e.func_148757_b((Object)item1);
        int id2 = Item.field_150901_e.func_148757_b((Object)item2);
        return Integer.compare(id1, id2);
    }

    public static int compareOreDict(ItemStack stack1, ItemStack stack2) {
        ArrayList<String> ores1 = new ArrayList<String>(OreDictHelper.getOreDicts(stack1));
        ArrayList<String> ores2 = new ArrayList<String>(OreDictHelper.getOreDicts(stack2));
        if (ores1.isEmpty() && ores2.isEmpty()) {
            return 0;
        }
        if (ores1.size() != ores2.size()) {
            return Integer.compare(ores1.size(), ores2.size());
        }
        if (ores1.size() > 1) {
            ores1.sort(String::compareTo);
            ores2.sort(String::compareTo);
        }
        int val = 0;
        int n = ores1.size();
        for (int i = 0; i < n; ++i) {
            val += ((String)ores1.get(i)).compareTo((String)ores2.get(i));
        }
        return MathHelper.func_76125_a((int)val, (int)-1, (int)1);
    }

    public static int compareHasNbt(ItemStack stack1, ItemStack stack2) {
        NBTTagCompound nbt2;
        NBTTagCompound nbt1 = stack1.func_77978_p();
        if (nbt1 == null == ((nbt2 = stack2.func_77978_p()) == null)) {
            return 0;
        }
        if (nbt1 == null) {
            return -1;
        }
        return 1;
    }

    public static int compareNotNullNbt(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int result = ItemCompareHelper.compareNbtSize(nbt1, nbt2);
        if (result != 0) {
            return result;
        }
        return ItemCompareHelper.compareNbtValues(nbt1, nbt2);
    }

    public static int compareNbtValues(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtValues(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtValues(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int result = 0;
        for (NbtSortRule nbtSortRule : SortHandler.currentNbtSortRules.get()) {
            result = nbtSortRule.compare(nbt1, nbt2);
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    public static int compareNbtAllValues(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtAllValues(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtAllValues(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int total = 0;
        for (String key : nbt1.func_150296_c()) {
            if (!nbt2.func_74764_b(key)) continue;
            int result = ItemCompareHelper.compareNbtBase(nbt1.func_74781_a(key), nbt2.func_74781_a(key));
            total += result;
        }
        return MathHelper.func_76125_a((int)total, (int)-1, (int)1);
    }

    public static int compareNbtBase(NBTBase nbt1, NBTBase nbt2) {
        if (nbt1.func_74732_a() != nbt2.func_74732_a()) {
            return 0;
        }
        if (nbt1.func_74732_a() == 10) {
            return ItemCompareHelper.compareNbtAllValues((NBTTagCompound)nbt1, (NBTTagCompound)nbt2);
        }
        if (nbt1 instanceof NBTBase.NBTPrimitive) {
            return Double.compare(((NBTBase.NBTPrimitive)nbt1).func_150286_g(), ((NBTBase.NBTPrimitive)nbt2).func_150286_g());
        }
        if (nbt1.func_74732_a() == 7) {
            byte[] array2;
            byte[] array1 = ((NBTTagByteArray)nbt1).func_150292_c();
            if (array1.length != (array2 = ((NBTTagByteArray)nbt2).func_150292_c()).length) {
                return array1.length < array2.length ? -1 : 1;
            }
            int total = 0;
            for (int i = 0; i < array1.length; ++i) {
                total += Byte.compare(array1[i], array2[i]);
            }
            return total;
        }
        if (nbt1.func_74732_a() == 11) {
            int[] array2;
            int[] array1 = ((NBTTagIntArray)nbt1).func_150302_c();
            if (array1.length != (array2 = ((NBTTagIntArray)nbt2).func_150302_c()).length) {
                return array1.length < array2.length ? -1 : 1;
            }
            int total = 0;
            for (int i = 0; i < array1.length; ++i) {
                total += Integer.compare(array1[i], array2[i]);
            }
            return total;
        }
        return 0;
    }

    public static int compareNbtSize(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtSize(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtSize(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int size2;
        int size1;
        if (nbt1.field_74784_a.size() < nbt2.field_74784_a.size()) {
            return -1;
        }
        if (nbt1.field_74784_a.size() > nbt2.field_74784_a.size()) {
            return 1;
        }
        List<NBTTagCompound> subTags1 = new ArrayList<NBTTagCompound>();
        List<NBTTagCompound> subTags2 = new ArrayList<NBTTagCompound>();
        subTags1.add(nbt1);
        subTags2.add(nbt2);
        do {
            subTags1 = ItemCompareHelper.getAllSubTags(subTags1);
            subTags2 = ItemCompareHelper.getAllSubTags(subTags2);
            size1 = ItemCompareHelper.getTotalSubTags(subTags1);
            size2 = ItemCompareHelper.getTotalSubTags(subTags2);
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            if (size1 >= size2) continue;
            return -1;
        } while (size1 <= size2);
        return 1;
    }

    @Nullable
    public static NBTBase findSubTag(String path, NBTBase tag) {
        String[] parts;
        if (tag == null || path == null || path.isEmpty()) {
            return null;
        }
        for (String part : parts = path.split("/")) {
            if (tag == null || tag.func_74732_a() != 10) {
                return null;
            }
            tag = ((NBTTagCompound)tag).func_74781_a(part);
        }
        return tag;
    }

    private static List<NBTTagCompound> getAllSubTags(List<NBTTagCompound> tags) {
        ArrayList<NBTTagCompound> subTags = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound nbt : tags) {
            for (String key : nbt.func_150296_c()) {
                NBTBase nbtBase = nbt.func_74781_a(key);
                if (!(nbt.func_74781_a(key) instanceof NBTTagCompound)) continue;
                subTags.add((NBTTagCompound)nbtBase);
            }
        }
        return subTags;
    }

    private static int getTotalSubTags(List<NBTTagCompound> tags) {
        int sum = 0;
        for (NBTTagCompound nbt : tags) {
            sum += nbt.field_74784_a.size();
        }
        return sum;
    }

    public static int comparePotionId(String potion1, String potion2) {
        String id2;
        String id1 = potion1.startsWith("strong") || potion1.startsWith("long") ? potion1.substring(potion1.indexOf(95) + 1) : potion1;
        int result = id1.compareTo(id2 = potion2.startsWith("strong") || potion2.startsWith("long") ? potion2.substring(potion2.indexOf(95) + 1) : potion2);
        if (result != 0) {
            return result;
        }
        boolean strong1 = potion1.startsWith("strong");
        boolean strong2 = potion2.startsWith("strong");
        if (strong1 && !strong2) {
            return 1;
        }
        if (!strong1 && strong2) {
            return -1;
        }
        return Boolean.compare(potion1.startsWith("long"), potion2.startsWith("long"));
    }

    public static int compareEnchantments(NBTTagList enchantments1, NBTTagList enchantments2) {
        NBTTagCompound nbt;
        int i;
        int total1 = 0;
        for (int i2 = 0; i2 < enchantments1.func_74745_c(); ++i2) {
            NBTTagCompound nbt2 = enchantments1.func_150305_b(i2);
            total1 += nbt2.func_74765_d("id");
        }
        int total2 = 0;
        for (int i3 = 0; i3 < enchantments2.func_74745_c(); ++i3) {
            NBTTagCompound nbt3 = enchantments2.func_150305_b(i3);
            total2 += nbt3.func_74765_d("id");
        }
        int result = Integer.compare(total1, total2);
        if (result != 0) {
            return result;
        }
        total1 = 0;
        for (i = 0; i < enchantments1.func_74745_c(); ++i) {
            nbt = enchantments1.func_150305_b(i);
            total1 += nbt.func_74765_d("lvl");
        }
        total2 = 0;
        for (i = 0; i < enchantments2.func_74745_c(); ++i) {
            nbt = enchantments2.func_150305_b(i);
            total2 += nbt.func_74765_d("lvl");
        }
        return Integer.compare(total1, total2);
    }

    public static int compareEnchantment(NBTTagCompound enchantment1, NBTTagCompound enchantment2) {
        int result = Integer.compare(enchantment1.func_74765_d("id"), enchantment2.func_74765_d("id"));
        if (result != 0) {
            return result;
        }
        return Integer.compare(enchantment1.func_74765_d("lvl"), enchantment2.func_74765_d("lvl"));
    }

    public static int compareMaterial(ItemStack item1, ItemStack item2) {
        String mat1 = OreDictHelper.getMaterial(item1);
        String mat2 = OreDictHelper.getMaterial(item2);
        if (mat1 == null && mat2 == null) {
            return 0;
        }
        if (mat1 == null) {
            return 1;
        }
        return mat2 == null ? -1 : mat1.compareTo(mat2);
    }

    public static int compareOrePrefix(ItemStack item1, ItemStack item2) {
        String prefix = OreDictHelper.getOrePrefix(item1);
        String prefix1 = OreDictHelper.getOrePrefix(item2);
        if (prefix == null && prefix1 == null) {
            return 0;
        }
        if (prefix == null) {
            return 1;
        }
        if (prefix1 == null) {
            return -1;
        }
        return Integer.compare(OreDictHelper.getOrePrefixIndex(prefix), OreDictHelper.getOrePrefixIndex(prefix1));
    }

    public static int compareEMC(ItemStack item1, ItemStack item2) {
        return Long.compare(ItemCompareHelper.getEmcValue(item2), ItemCompareHelper.getEmcValue(item1));
    }

    public static int compareBlockType(ItemStack item1, ItemStack item2) {
        int c = Boolean.compare(ItemCompareHelper.isBlock(item2), ItemCompareHelper.isBlock(item1));
        if (c != 0 || !ItemCompareHelper.isBlock(item1)) {
            return c;
        }
        Block block1 = ItemCompareHelper.getBlock(item1);
        Block block2 = ItemCompareHelper.getBlock(item2);
        Block state1 = ItemCompareHelper.getBlockState(block1, item1.func_77960_j());
        Block state2 = ItemCompareHelper.getBlockState(block2, item2.func_77960_j());
        c = Boolean.compare(state2.func_149730_j(), state1.func_149730_j());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(state2.func_149686_d(), state1.func_149686_d());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(state2.func_149662_c(), state1.func_149662_c());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(ItemCompareHelper.isSlab(block2), ItemCompareHelper.isSlab(block1));
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(ItemCompareHelper.isStair(block2), ItemCompareHelper.isStair(block1));
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(ItemCompareHelper.isPipe(block2), ItemCompareHelper.isPipe(block1));
        if (c != 0) {
            return c;
        }
        return Boolean.compare(block1.hasTileEntity(0), block2.hasTileEntity(0));
    }

    public static int compareBurnTime(ItemStack item1, ItemStack item2) {
        return Integer.compare(TileEntityFurnace.func_145952_a((ItemStack)item2), TileEntityFurnace.func_145952_a((ItemStack)item1));
    }

    public static int compareSaturation(ItemStack item1, ItemStack item2) {
        return Float.compare(ItemCompareHelper.getSaturation(item2), ItemCompareHelper.getSaturation(item1));
    }

    public static int compareHunger(ItemStack item1, ItemStack item2) {
        return Integer.compare(ItemCompareHelper.getHunger(item2), ItemCompareHelper.getHunger(item1));
    }

    public static int compareColor(ItemSortContainer item1, ItemSortContainer item2) {
        return Integer.compare(item1.getColorHue(), item2.getColorHue());
    }

    public static int compareColor(ItemStack item1, ItemStack item2) {
        return Integer.compare(ItemColorHelper.getItemColorHue(item1), ItemColorHelper.getItemColorHue(item2));
    }

    public static Block getBlockState(Block block, int meta) {
        try {
            return Block.func_149729_e((int)meta);
        }
        catch (Exception e) {
            return block;
        }
    }

    public static boolean isBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof ItemReed;
    }

    public static Block getBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a : ((ItemReed)stack.func_77973_b()).field_150935_a;
    }

    public static boolean isSlab(Block block) {
        return block instanceof BlockSlab || SLAB_PATTERN.matcher(block.getClass().getSimpleName()).matches();
    }

    public static boolean isStair(Block block) {
        return block instanceof BlockStairs || STAIR_PATTERN.matcher(block.getClass().getSimpleName()).matches();
    }

    public static boolean isPipe(Block block) {
        return PIPE_PATTERN.matcher(block.getClass().getSimpleName()).matches() || CABLE_PATTERN.matcher(block.getClass().getSimpleName()).matches() || WIRE_PATTERN.matcher(block.getClass().getSimpleName()).matches();
    }
}

