/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.KeyBind;
import com.cleanroommc.bogosorter.ShortcutHandler;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.config.ConfigGui;
import com.cleanroommc.bogosorter.common.config.SortRulesConfig;
import com.cleanroommc.bogosorter.common.dropoff.render.RendererCube;
import com.cleanroommc.bogosorter.common.network.CDropOff;
import com.cleanroommc.bogosorter.common.network.CSort;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.bogosorter.compat.screen.WarningScreen;
import com.cleanroommc.bogosorter.mixins.early.minecraft.SlotAccessor;
import com.cleanroommc.modularui.api.event.KeyboardInputEvent;
import com.cleanroommc.modularui.api.event.MouseInputEvent;
import com.cleanroommc.modularui.factory.ClientGUI;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientEventHandler {
    public static final List<ItemStack> allItems = new ArrayList<ItemStack>();
    public static final KeyBinding configGuiKey = new KeyBinding("key.sort_config", 0, "key.categories.bogosorter");
    public static final KeyBinding sortKey = new KeyBinding("key.sort", -98, "key.categories.bogosorter");
    public static final KeyBinding dropoffKey = new KeyBinding("key.dropoff", 0, "key.categories.bogosorter");
    public static final boolean isDeobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final KeyBind moveAllSame = KeyBind.builder("move_all_same").lmb(true).rmb(false).shift(false).ctrl(false).alt(true).space(false).build();
    public static final KeyBind moveAll = KeyBind.builder("move_all").lmb(true).rmb(false).shift(false).ctrl(false).alt(false).space(true).build();
    public static final KeyBind moveSingle = KeyBind.builder("move_single").lmb(true).rmb(false).shift(false).ctrl(true).alt(false).build();
    public static final KeyBind moveSingleEmpty = KeyBind.builder("move_single_empty").lmb(false).rmb(true).shift(false).ctrl(true).alt(false).build();
    public static final KeyBind throwAllSame = KeyBind.builder("throw_all_same").lmb(false).rmb(false).shift(false).ctrl(false).alt(true).space(false).validator(() -> ClientEventHandler.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74316_C)).build();
    public static final KeyBind throwAll = KeyBind.builder("throw_all").lmb(false).rmb(false).shift(false).ctrl(false).alt(false).space(true).validator(() -> ClientEventHandler.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74316_C)).build();
    private static long timeConfigGui = 0L;
    private static long timeSort = 0L;
    private static long timeShortcut = 0L;
    private static long timeDropoff = 0L;
    private static long ticks = 0L;
    private static GuiScreen nextGui = null;

    public static void openNextTick(GuiScreen screen) {
        nextGui = screen;
    }

    public static long getTicks() {
        return ticks;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++ticks;
        }
        if (nextGui != null) {
            ClientGUI.open((GuiScreen)nextGui);
            nextGui = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu && !WarningScreen.wasOpened) {
            WarningScreen.wasOpened = true;
            ArrayList<String> warnings = new ArrayList<String>();
            if (Loader.isModLoaded((String)"inventorytweaks")) {
                warnings.add("InventoryTweaks is loaded. This will cause issues!");
                warnings.add("Consider removing the mod and reload the game.");
            }
            if (!warnings.isEmpty()) {
                warnings.add(0, EnumChatFormatting.BOLD + "! Warning from Inventory Bogosorter !");
                warnings.add(1, "");
                event.gui = new WarningScreen(warnings);
            }
        }
    }

    private static void shortcutAction() {
        timeShortcut = Minecraft.func_71386_F();
    }

    private static boolean canDoShortcutAction() {
        return Minecraft.func_71386_F() - timeShortcut > 50L;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        long t;
        if (ClientEventHandler.Keypress(configGuiKey) && (t = Minecraft.func_71386_F()) - timeConfigGui > 500L) {
            if (!ConfigGui.closeCurrent()) {
                BogoSortAPI.INSTANCE.openConfigGui(Minecraft.func_71410_x().field_71462_r);
            }
            timeConfigGui = t;
        }
        if (ClientEventHandler.Keypress(dropoffKey) && (t = Minecraft.func_71386_F()) - timeDropoff > (long)BogoSorterConfig.dropOff.dropoffPacketThrottleInMS) {
            if (BogoSorterConfig.dropOff.enableDropOff) {
                NetworkHandler.sendToServer(new CDropOff());
            }
            timeDropoff = t;
        }
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.MouseInputEvent event) {
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiKeyInput(KeyboardInputEvent.Pre event) {
        KeyBind.checkKeys(ClientEventHandler.getTicks());
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        if (ClientEventHandler.handleInput((GuiContainer)event.gui)) {
            event.setCanceled(true);
            return;
        }
        if (isDeobfuscatedEnvironment) {
            if (Keyboard.isKeyDown((int)79)) {
                SlotAccessor slot = ClientEventHandler.getSlot(event.gui);
                SortHandler sortHandler = ClientEventHandler.createSortHandler(event.gui, slot);
                if (sortHandler == null) {
                    return;
                }
                sortHandler.clearAllItems(slot);
                return;
            }
            if (Keyboard.isKeyDown((int)80)) {
                SortHandler sortHandler;
                Object slot;
                if (allItems.isEmpty()) {
                    slot = Item.field_150901_e.func_148742_b().iterator();
                    while (slot.hasNext()) {
                        Object key = slot.next();
                        Item item = (Item)Item.field_150901_e.func_82594_a(key);
                        ArrayList subItems = Lists.newArrayList();
                        item.func_150895_a(item, CreativeTabs.field_78027_g, (List)subItems);
                        allItems.addAll(subItems);
                    }
                }
                if ((sortHandler = ClientEventHandler.createSortHandler(event.gui, (SlotAccessor)(slot = ClientEventHandler.getSlot(event.gui)))) == null) {
                    return;
                }
                sortHandler.randomizeItems((SlotAccessor)slot);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onMouseInput(MouseInputEvent.Pre event) {
        KeyBind.checkKeys(ClientEventHandler.getTicks());
        if (event.gui instanceof GuiContainer && ClientEventHandler.handleInput((GuiContainer)event.gui)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (BogoSorterConfig.dropOff.dropoffRender) {
            RendererCube.INSTANCE.tryToRender(event);
        }
    }

    public static boolean handleInput(@Nullable GuiContainer container) {
        long t;
        if (container != null && ClientEventHandler.canDoShortcutAction()) {
            if (moveAll.isFirstPress() && ShortcutHandler.moveAllItems(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveAllSame.isFirstPress() && ShortcutHandler.moveAllItems(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveSingle.isFirstPressOrHeldLong(15) && ShortcutHandler.moveSingleItem(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (moveSingleEmpty.isFirstPressOrHeldLong(15) && ShortcutHandler.moveSingleItem(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (throwAll.isFirstPress() && ShortcutHandler.dropItems(container, false)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            if (throwAllSame.isFirstPress() && ShortcutHandler.dropItems(container, true)) {
                ClientEventHandler.shortcutAction();
                return true;
            }
            ShortcutHandler.SetCanTakeStack = true;
        }
        if (container != null && ClientEventHandler.Keypress(sortKey) && (t = Minecraft.func_71386_F()) - timeSort > 500L) {
            SlotAccessor slot = ClientEventHandler.getSlot((GuiScreen)container);
            if (!ClientEventHandler.canSort(slot) || !ClientEventHandler.sort((GuiScreen)container, slot)) {
                return false;
            }
            timeSort = t;
            return true;
        }
        return false;
    }

    private static boolean canSort(@Nullable SlotAccessor slot) {
        return !Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && (slot == null || slot.callGetStack() == null);
    }

    private static boolean isButtonPressed(int button) {
        return Mouse.getEventButtonState() && Mouse.getEventButton() == button;
    }

    private static boolean isKeyDown(KeyBinding key) {
        if (key.func_151463_i() < 0) {
            return ClientEventHandler.isButtonPressed(key.func_151463_i() + 100);
        }
        return Keyboard.getEventKeyState() && Keyboard.getEventKey() == key.func_151463_i();
    }

    public static boolean isSortableContainer(GuiScreen screen) {
        return screen instanceof GuiContainer && BogoSortAPI.isValidSortable(((GuiContainer)screen).field_147002_h);
    }

    public static <T extends Container> T getSortableContainer(GuiScreen screen) {
        return (T)((GuiContainer)screen).field_147002_h;
    }

    @Nullable
    public static SlotAccessor getSlot(GuiScreen guiScreen) {
        if (guiScreen instanceof GuiContainer) {
            return (SlotAccessor)((GuiContainer)guiScreen).field_147006_u;
        }
        return null;
    }

    public static boolean sort(GuiScreen guiScreen, @Nullable SlotAccessor slot) {
        if (guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            if (sortingContext.isEmpty()) {
                return false;
            }
            SlotGroup slotGroup = null;
            if (slot == null) {
                if (sortingContext.getNonPlayerSlotGroupAmount() == 1) {
                    slotGroup = sortingContext.getNonPlayerSlotGroup();
                } else if (sortingContext.hasPlayer() && sortingContext.getNonPlayerSlotGroupAmount() == 0) {
                    slotGroup = sortingContext.getPlayerSlotGroup();
                }
                if (slotGroup == null || slotGroup.isEmpty()) {
                    return false;
                }
                slot = slotGroup.getSlots().get(0);
            } else {
                slotGroup = sortingContext.getSlotGroup(slot.getSlotNumber());
                if (slotGroup == null || slotGroup.isEmpty() || slotGroup.isHotbar() && !BogoSorterConfig.enableHotbarSort) {
                    return false;
                }
            }
            List<SortRule<ItemStack>> sortRules = SortRulesConfig.sortRules;
            boolean color = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("color"));
            boolean name = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("display_name"));
            NetworkHandler.sendToServer(new CSort(ClientEventHandler.createSortData(slotGroup, color, name), SortRulesConfig.sortRules, SortRulesConfig.nbtSortRules, slot.getSlotNumber(), slotGroup.isPlayerInventory()));
            SortHandler.playSortSound();
            return true;
        }
        return false;
    }

    public static Collection<ClientSortData> createSortData(SlotGroup slotGroup, boolean color, boolean name) {
        if (!color && !name) {
            return Collections.emptyList();
        }
        Object2ObjectOpenCustomHashMap map = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);
        for (SlotAccessor slot1 : slotGroup.getSlots()) {
            map.computeIfAbsent(slot1.callGetStack(), stack -> ClientSortData.of(stack, color, name)).getSlotNumbers().add(slot1.getSlotNumber());
        }
        return map.values();
    }

    public static SortHandler createSortHandler(GuiScreen guiScreen, @Nullable SlotAccessor slot) {
        if (slot != null && guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            boolean player = BogoSortAPI.isPlayerSlot(slot);
            if (!player && !ClientEventHandler.isSortableContainer(guiScreen)) {
                return null;
            }
            return new SortHandler((EntityPlayer)Minecraft.func_71410_x().field_71439_g, container, (Int2ObjectMap<ClientSortData>)Int2ObjectMaps.emptyMap());
        }
        return null;
    }

    private static boolean Keypress(KeyBinding key) {
        int keyCode = key.func_151463_i();
        if (keyCode > 0) {
            return key.func_151468_f();
        }
        return Mouse.isButtonDown((int)(100 + keyCode));
    }
}

