/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.helpers;

import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.GTUtility;
import java.io.IOException;
import java.util.ArrayList;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class GTHelper {
    public static long getMaxInputEU(MTEMultiBlockBase mte) {
        if (mte instanceof KubaTechGTMultiBlockBase) {
            return mte.getMaxInputEu();
        }
        long rEU = 0L;
        for (MTEHatchEnergy tHatch : mte.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            rEU += tHatch.maxEUInput() * tHatch.maxAmperesIn();
        }
        return rEU;
    }

    public static double getVoltageTierD(long voltage) {
        return GTUtility.log4(voltage / 8L);
    }

    public static double getVoltageTierD(MTEMultiBlockBase mte) {
        return GTUtility.log4(GTHelper.getMaxInputEU(mte) / 8L);
    }

    public static int getVoltageTier(long voltage) {
        return (int)GTHelper.getVoltageTierD(voltage);
    }

    public static int getVoltageTier(MTEMultiBlockBase mte) {
        return (int)GTHelper.getVoltageTierD(mte);
    }

    public static class StackableItemSlot {
        public final int count;
        public final ItemStack stack;
        private final int hashcode;
        public final ArrayList<Integer> realSlots;

        public StackableItemSlot(int count, @NotNull ItemStack stack, ArrayList<Integer> realSlots) {
            this.count = count;
            this.stack = stack;
            this.hashcode = GTUtility.ItemId.createNoCopyWithStackSize(stack).hashCode();
            this.realSlots = realSlots;
        }

        public void write(@NotNull PacketBuffer buffer) throws IOException {
            buffer.func_150787_b(this.count);
            buffer.func_150788_a(this.stack);
        }

        @NotNull
        public static StackableItemSlot read(@NotNull PacketBuffer buffer) throws IOException {
            return new StackableItemSlot(buffer.func_150792_a(), buffer.func_150791_c(), new ArrayList<Integer>());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StackableItemSlot)) {
                return false;
            }
            StackableItemSlot other = (StackableItemSlot)obj;
            return this.count == other.count && this.hashcode == other.hashcode && this.realSlots.equals(other.realSlots);
        }
    }
}

