/*
 * Decompiled with CFR 0.152.
 */
package gregtech.mixin;

import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import gregtech.common.config.Gregtech;
import gregtech.common.pollution.PollutionConfig;
import gregtech.mixin.TargetedMod;
import org.jetbrains.annotations.NotNull;

public enum Mixin implements IMixins
{
    GregtechCapes(new MixinBuilder().addClientMixins(new String[]{"minecraft.AbstractClientPlayerMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    SoundManagerMixin(new MixinBuilder("Seeking sound playback").addClientMixins(new String[]{"minecraft.SoundManagerMixin", "minecraft.SoundManagerInnerMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    WorldMixin(new MixinBuilder("Block update detection").addCommonMixins(new String[]{"minecraft.WorldMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    StringTranslateMixin(new MixinBuilder("Keep track of currently translating mods").addCommonMixins(new String[]{"minecraft.StringTranslateMixin", "minecraft.LanguageRegistryMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    LocaleMixin(new MixinBuilder("Keep track of currently translating client mods").addClientMixins(new String[]{"minecraft.LocaleMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    VANILLA_ACCESSORS(new MixinBuilder().addCommonMixins(new String[]{"minecraft.accessors.BlockStemMixin", "minecraft.accessors.ChunkCacheMixin", "minecraft.accessors.VanillaShapedRecipeMixin", "minecraft.accessors.VanillaShapelessRecipeMixin", "minecraft.accessors.ForgeShapedRecipeMixin", "minecraft.accessors.ForgeShapelessRecipeMixin", "minecraft.accessors.ItemArmorMixin", "minecraft.accessors.PotionMixin", "minecraft.accessors.EntityPlayerMPMixin", "minecraft.accessors.WeightedRandomFishableMixin", "minecraft.accessors.EntityMixin", "minecraft.accessors.LanguageRegistryMixin", "minecraft.accessors.EntityItemMixin"}).addClientMixins(new String[]{"minecraft.accessors.GuiTextFieldMixin", "minecraft.accessors.TessellatorMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    ItemMixinCoverFix(new MixinBuilder("Allow cover items to bypass sneak checks").addCommonMixins(new String[]{"minecraft.ItemMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    SplitPhysicRenderingPipeBoundingBox(new MixinBuilder("Allows pipes to have different bounding box for the rendering, physics and player pickblock").addClientMixins(new String[]{"minecraft.MinecraftMixin_MouseOver"}).setPhase(IBaseTransformer.Phase.EARLY)),
    VanillaToolChanges(new MixinBuilder("Changes wooden tools to be a little faster").addCommonMixins(new String[]{"minecraft.ItemToolMaterialMixin"}).setApplyIf(() -> Gregtech.general.changedWoodenVanillaTools).setPhase(IBaseTransformer.Phase.EARLY)),
    ForgeHooksMixin(new MixinBuilder("Adds missing hooks in ForgeHooks").addCommonMixins(new String[]{"forge.ForgeHooksMixin"}).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_MACHINE_WRENCHING(new MixinBuilder("Changes the behavior of the wrenching mechanic for IC2 machines").addCommonMixins(new String[]{"ic2.MixinDamageDropped", "ic2.MixinHarvestTool", "ic2.MixinItemDropped"}).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_REINFORCED_GLASS_SILK(new MixinBuilder("Lets Reinforced Glass be harvested by silk touch").addCommonMixins(new String[]{"ic2.MixinIc2ReinforcedGlass"}).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_REMOVE_FISSION_FUELS(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinIc2FissionFuelRemoval"}).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_HAZMAT(new MixinBuilder().setPhase(IBaseTransformer.Phase.LATE).addCommonMixins(new String[]{"ic2.MixinIc2Hazmat", "ic2.MixinIc2Nano", "ic2.MixinIc2Quantum"}).addRequiredMod((ITargetMod)TargetedMod.IC2).addExcludedMod((ITargetMod)TargetedMod.GT6)),
    ADV_SOLAR_HAZMAT(new MixinBuilder("Applies Hazmat API to Advanced Solar helmets").setPhase(IBaseTransformer.Phase.LATE).addCommonMixins(new String[]{"advanced_solar_panels.MixinAdvancedSolarHelmet"}).addRequiredMod((ITargetMod)TargetedMod.ADVANCED_SOLAR_PANELS)),
    VANILLA_TRADING(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addCommonMixins(new String[]{"minecraft.VanillaTradingMixin"})),
    POLLUTION_RENDER_BLOCKS(new MixinBuilder().addClientMixins(new String[]{"minecraft.pollution.MixinRenderBlocks_PollutionWithoutOptifine"}).addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(IBaseTransformer.Phase.EARLY)),
    POLLUTION_RENDER_BLOCKS_OPTIFINE(new MixinBuilder().addClientMixins(new String[]{"minecraft.pollution.MixinRenderBlocks_PollutionWithOptifine"}).addRequiredMod((ITargetMod)TargetedMod.OPTIFINE).addExcludedMod((ITargetMod)TargetedMod.ANGELICA).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(IBaseTransformer.Phase.EARLY)),
    POLLUTION_RENDER_BLOCKS_BOP(new MixinBuilder().addClientMixins(new String[]{"biomesoplenty.MixinFoliageRendererPollution"}).addRequiredMod((ITargetMod)TargetedMod.BIOMESOPLENTY).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(IBaseTransformer.Phase.LATE)),
    POLLUTION_MINECRAFT_FURNACE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addCommonMixins(new String[]{"minecraft.pollution.MixinTileEntityFurnacePollution"}).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute)),
    POLLUTION_MINECRAFT_EXPLOSION(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addCommonMixins(new String[]{"minecraft.pollution.MixinExplosionPollution"}).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.explosionPollutionAmount != 0.0f)),
    POLLUTION_IC2_IRON_FURNACE(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinIC2IronFurnacePollution"}).setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute).addRequiredMod((ITargetMod)TargetedMod.IC2)),
    POLLUTION_THAUMCRAFT_ALCHEMICAL_FURNACE(new MixinBuilder("Thaumcraft Alchemical Construct Pollutes").addCommonMixins(new String[]{"thaumcraft.MixinThaumcraftAlchemyFurnacePollution"}).setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT)),
    POLLUTION_RAILCRAFT(new MixinBuilder("Make Railcraft Pollute").addCommonMixins(new String[]{"railcraft.MixinRailcraftBoilerPollution", "railcraft.MixinRailcraftCokeOvenPollution", "railcraft.MixinRailcraftTunnelBorePollution"}).setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.railcraftPollutes).addRequiredMod((ITargetMod)TargetedMod.RAILCRAFT)),
    POLLUTION_ROCKET(new MixinBuilder().addCommonMixins(new String[]{"galacticraftcore.MixinGalacticraftRocketPollution"}).setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.rocketsPollute).addRequiredMod((ITargetMod)TargetedMod.GALACTICRAFT_CORE));

    private final MixinBuilder builder;

    private Mixin(MixinBuilder builder) {
        this.builder = builder;
    }

    @NotNull
    public MixinBuilder getBuilder() {
        return this.builder;
    }
}

