/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.items.GTGenericBlock;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.blocks.ItemStorage;
import gregtech.common.blocks.MaterialReinforced;
import gregtech.common.entity.EntityPowderBarrelPrimed;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReinforced
extends GTGenericBlock {
    public BlockReinforced(String name) {
        super(ItemStorage.class, name, new MaterialReinforced());
        for (int i = 0; i < 16; ++i) {
            Textures.BlockIcons.casingTexturePages[1][i + 80] = TextureFactory.of(this, i);
        }
        this.func_149672_a(field_149769_e);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Bronzeplate Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "Iridium Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Plascrete Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "Tungstensteel Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "Brittle Charcoal");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Powder Barrel");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Solid Super Fuel");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Magic Solid Super Fuel");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Steel Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".9.name", "Titanium Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".10.name", "Naquadah Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".11.name", "Neutronium Reinforced Block");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".12.name", "Raw Deep Dark Portal Block");
        ItemList.Block_BronzePlate.set(new ItemStack(this.func_149711_c(60.0f).func_149752_b(150.0f), 1, 0));
        ItemList.Block_IridiumTungstensteel.set(new ItemStack(this.func_149711_c(400.0f).func_149752_b(600.0f), 1, 1));
        ItemList.Block_Plascrete.set(new ItemStack(this.func_149711_c(5.0f).func_149752_b(6.0f), 1, 2));
        ItemList.Block_TungstenSteelReinforced.set(new ItemStack(this.func_149711_c(250.0f).func_149752_b(400.0f), 1, 3));
        ItemList.Block_BrittleCharcoal.set(new ItemStack(this.func_149711_c(0.5f).func_149752_b(8.0f), 1, 4));
        ItemList.Block_Powderbarrel.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 5));
        ItemList.Block_SSFUEL.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 6));
        ItemList.Block_MSSFUEL.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 7));
        ItemList.Block_SteelPlate.set(new ItemStack(this.func_149711_c(150.0f).func_149752_b(200.0f), 1, 8));
        ItemList.Block_TitaniumPlate.set(new ItemStack(this.func_149711_c(200.0f).func_149752_b(300.0f), 1, 9));
        ItemList.Block_NaquadahPlate.set(new ItemStack(this.func_149711_c(500.0f).func_149752_b(1000.0f), 1, 10));
        ItemList.Block_NeutroniumPlate.set(new ItemStack(this.func_149711_c(750.0f).func_149752_b(2500.0f), 1, 11));
        ItemList.Block_BedrockiumCompressed.set(new ItemStack(this.func_149711_c(1500.0f).func_149752_b(5000.0f), 1, 12));
        GTModHandler.addShapelessCraftingRecipe(new ItemStack(Items.field_151044_h, 1, 1), new Object[]{ItemList.Block_BrittleCharcoal.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Block_Powderbarrel.get(1L, new Object[0]), GTModHandler.RecipeBits.REVERSIBLE, new Object[]{"WSW", "GGG", "WGW", Character.valueOf('W'), OrePrefixes.plate.get(Materials.Wood), Character.valueOf('G'), new ItemStack(Items.field_151016_H, 1), Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1)});
        BlockDispenser.field_149943_a.func_82595_a((Object)ItemList.Block_Powderbarrel.getItem(), (Object)new BehaviorDefaultDispenseItem(){

            protected ItemStack func_82487_b(IBlockSource dispenser, ItemStack dispensedItem) {
                if (dispensedItem.func_77960_j() != 5) {
                    return super.func_82487_b(dispenser, dispensedItem);
                }
                EnumFacing enumfacing = BlockDispenser.func_149937_b((int)dispenser.func_82620_h());
                World world = dispenser.func_82618_k();
                int x = dispenser.func_82623_d() + enumfacing.func_82601_c();
                int y = dispenser.func_82622_e() + enumfacing.func_96559_d();
                int z = dispenser.func_82621_f() + enumfacing.func_82599_e();
                EntityPowderBarrelPrimed primedBarrel = new EntityPowderBarrelPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, null);
                world.func_72838_d((Entity)primedBarrel);
                ((WorldSpawnedEventBuilder.SoundAtEntityEventBuilder)new WorldSpawnedEventBuilder.SoundAtEntityEventBuilder().setPitch(1.0f).setVolume(1.0f).setIdentifier((Enum)SoundResource.GAME_TNT_PRIMED)).setEntity((Entity)primedBarrel).setWorld(world).run();
                --dispensedItem.field_77994_a;
                return dispensedItem;
            }
        });
        EntityRegistry.registerModEntity(EntityPowderBarrelPrimed.class, (String)"PowderBarrelPrimed", (int)0, (Object)GTMod.GT, (int)64, (int)10, (boolean)true);
    }

    public String getHarvestTool(int meta) {
        String string;
        switch (meta) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "axe";
                break;
            }
            case 2: {
                string = "wrench";
                break;
            }
            default: {
                string = "pickaxe";
            }
        }
        return string;
    }

    public int getHarvestLevel(int meta) {
        int n;
        switch (meta) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                n = 5;
                break;
            }
            case 10: 
            case 11: {
                n = 7;
                break;
            }
            default: {
                n = 4;
            }
        }
        return n;
    }

    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon;
        switch (meta) {
            case 0: {
                iIcon = Textures.BlockIcons.BLOCK_BRONZEPREIN.getIcon();
                break;
            }
            case 1: {
                iIcon = Textures.BlockIcons.BLOCK_IRREIN.getIcon();
                break;
            }
            case 2: {
                iIcon = Textures.BlockIcons.BLOCK_PLASCRETE.getIcon();
                break;
            }
            case 3: {
                iIcon = Textures.BlockIcons.BLOCK_TSREIN.getIcon();
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                iIcon = Blocks.field_150402_ci.func_149691_a(0, 0);
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.COVER_WOOD_PLATE.getIcon();
                break;
            }
            case 8: {
                iIcon = Textures.BlockIcons.BLOCK_STEELPREIN.getIcon();
                break;
            }
            case 9: {
                iIcon = Textures.BlockIcons.BLOCK_TITANIUMPREIN.getIcon();
                break;
            }
            case 10: {
                iIcon = Textures.BlockIcons.BLOCK_NAQUADAHPREIN.getIcon();
                break;
            }
            case 11: {
                iIcon = Textures.BlockIcons.BLOCK_NEUTRONIUMPREIN.getIcon();
                break;
            }
            case 12: {
                iIcon = Textures.BlockIcons.BLOCK_DEEP_DARK_RAW.getIcon();
                break;
            }
            default: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_SOLID_STEEL.getIcon();
            }
        }
        return iIcon;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        float f;
        if (world == null) {
            return 0.0f;
        }
        if (world.func_147437_c(x, y, z)) {
            return 0.0f;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                f = 60.0f;
                break;
            }
            case 1: {
                f = 400.0f;
                break;
            }
            case 2: {
                f = 5.0f;
                break;
            }
            case 3: {
                f = 250.0f;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                f = 0.5f;
                break;
            }
            case 8: {
                f = 150.0f;
                break;
            }
            case 9: {
                f = 200.0f;
                break;
            }
            case 10: {
                f = 500.0f;
                break;
            }
            case 11: {
                f = 750.0f;
                break;
            }
            default: {
                f = Blocks.field_150339_S.func_149712_f(world, x, y, z);
            }
        }
        return f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        float f;
        if (world == null) {
            return 0.0f;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                f = 150.0f;
                break;
            }
            case 1: {
                f = 600.0f;
                break;
            }
            case 2: {
                f = 6.0f;
                break;
            }
            case 3: {
                f = 400.0f;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                f = 8.0f;
                break;
            }
            case 5: {
                f = 1.0f;
                break;
            }
            case 8: {
                f = 200.0f;
                break;
            }
            case 9: {
                f = 300.0f;
                break;
            }
            case 10: {
                f = 1000.0f;
                break;
            }
            case 11: {
                f = 2500.0f;
                break;
            }
            default: {
                f = super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
            }
        }
        return f;
    }

    public String func_149739_a() {
        return this.mUnlocalizedName;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.mUnlocalizedName + ".name"));
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (meta == 4) {
            this.func_149642_a(world, x, y, z, new ItemStack(Items.field_151044_h, XSTR.XSTR_INSTANCE.nextInt(2) + 1, 1));
        } else {
            super.func_149690_a(world, x, y, z, meta, chance, fortune);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 5) {
            EntityPowderBarrelPrimed primedBarrel = new EntityPowderBarrelPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, (EntityLivingBase)player);
            world.func_72838_d((Entity)primedBarrel);
            ((WorldSpawnedEventBuilder.SoundAtEntityEventBuilder)new WorldSpawnedEventBuilder.SoundAtEntityEventBuilder().setPitch(1.0f).setVolume(1.0f).setIdentifier((Enum)SoundResource.GAME_TNT_PRIMED)).setEntity((Entity)primedBarrel).setWorld(world).run();
            world.func_147468_f(x, y, z);
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, null, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, null, x, y, z);
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 5) {
            EntityPowderBarrelPrimed primedBarrel = new EntityPowderBarrelPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, explosion.func_94613_c());
            primedBarrel.field_70516_a = world.field_73012_v.nextInt(primedBarrel.field_70516_a / 4) + primedBarrel.field_70516_a / 8;
            world.func_72838_d((Entity)primedBarrel);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int ordinalSide, float xOffset, float yOffset, float zOffset) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemFlintAndSteel && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, player, x, y, z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, ordinalSide, xOffset, yOffset, zOffset);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = new ItemStack(item, 1, i);
            if (stack.func_82833_r().contains(".name")) continue;
            list.add(stack);
        }
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityWither);
    }
}

