/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MTEBasicTank
extends MTETieredMachineBlock
implements IAddUIWidgets {
    public FluidStack mFluid;
    protected final FluidStackTank fluidTank = new FluidStackTank(() -> this.mFluid, fluidStack -> {
        this.mFluid = fluidStack;
    }, this::getRealCapacity);
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTEBasicTank(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTEBasicTank(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTEBasicTank(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != this.getStackDisplaySlot();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
    }

    public abstract boolean doesFillContainers();

    public abstract boolean doesEmptyContainers();

    public abstract boolean canTankBeFilled();

    public abstract boolean canTankBeEmptied();

    public int getInputSlot() {
        return 0;
    }

    public int getOutputSlot() {
        return 1;
    }

    public int getStackDisplaySlot() {
        return 2;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return true;
    }

    public boolean isFluidChangingAllowed() {
        return true;
    }

    public FluidStack getFillableStack() {
        return this.mFluid;
    }

    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDrainableStack() {
        return this.mFluid;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public boolean isDrainableStackSeparate() {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            FluidStack tFluid;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            int inputSlot = this.getInputSlot();
            if (this.doesEmptyContainers() && (tFluid = GTUtility.getFluidForFilledItem(this.mInventory[inputSlot], true)) != null && this.isFluidInputAllowed(tFluid)) {
                if (this.getFillableStack() == null) {
                    if (this.isFluidInputAllowed(tFluid) && tFluid.amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GTUtility.getContainerForFilledItem(this.mInventory[inputSlot], true), 1)) {
                        this.setFillableStack(tFluid.copy());
                        this.onEmptyingContainerWhenEmpty();
                        aBaseMetaTileEntity.func_70298_a(inputSlot, 1);
                    }
                } else if (tFluid.isFluidEqual(this.getFillableStack()) && (long)tFluid.amount + (long)this.getFillableStack().amount <= (long)this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GTUtility.getContainerForFilledItem(this.mInventory[inputSlot], true), 1)) {
                    this.getFillableStack().amount += tFluid.amount;
                    aBaseMetaTileEntity.func_70298_a(inputSlot, 1);
                }
            }
            if (this.doesFillContainers() && (tOutput = GTUtility.fillFluidContainer(this.getDrainableStack(), this.mInventory[inputSlot], false, true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid2 = GTUtility.getFluidForFilledItem(tOutput, true);
                aBaseMetaTileEntity.func_70298_a(inputSlot, 1);
                if (tFluid2 != null) {
                    this.getDrainableStack().amount -= tFluid2.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
        }
    }

    @Override
    public FluidStack getFluid() {
        return this.getDrainableStack();
    }

    @Override
    public int getFluidAmount() {
        return this.getDrainableStack() != null ? this.getDrainableStack().amount : 0;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (this.getFillableStack() == null || this.getFillableStack().getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                    this.getBaseMetaTileEntity().func_70296_d();
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return this.getCapacity();
        }
        if (!this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.getFillableStack().amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.getFillableStack().amount += aFluid.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.getFillableStack().amount = this.getCapacity();
        }
        return space;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getDrainableStack() == null || !this.canTankBeEmptied()) {
            return null;
        }
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        int used = maxDrain;
        if (this.getDrainableStack().amount < used) {
            used = this.getDrainableStack().amount;
        }
        if (doDrain) {
            this.getDrainableStack().amount -= used;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        FluidStack drained = this.getDrainableStack().copy();
        drained.amount = used;
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return drained;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.getCapacity() <= 0 && !this.isSteampowered()) {
            return GTValues.emptyFluidTankInfo;
        }
        if (this.isDrainableStackSeparate()) {
            return new FluidTankInfo[]{new FluidTankInfo(this.getFillableStack(), this.getCapacity()), new FluidTankInfo(this.getDrainableStack(), this.getCapacity())};
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this)};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == this.getOutputSlot();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == this.getInputSlot();
    }

    protected void onEmptyingContainerWhenEmpty() {
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GAUGE).setPos(79, 34).setSize(18, 18))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getInputSlot()).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getOutputSlot()).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(this.createFluidSlot().setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(58, 41))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.basic_tank.liquid_amount")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format(this.mFluid != null ? (long)this.mFluid.amount : 0L)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }

    protected Widget createMuffleButton() {
        return new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.getBaseMetaTileEntity().isClientSide()) {
                return;
            }
            this.getBaseMetaTileEntity().setMuffler(!this.getBaseMetaTileEntity().hasMufflerUpgrade());
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
                ret.add(GTUITextures.OVERLAY_BUTTON_MUFFLE_ON);
            } else {
                ret.add(GTUITextures.OVERLAY_BUTTON_MUFFLE_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.machines.muffled")).setPos(5, 5).setSize(9, 9);
    }

    protected FluidSlotWidget createFluidSlot() {
        return new FluidSlotWidget((IFluidTank)this.fluidTank);
    }
}

