/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final int labelBgAlpha = 180;
    static final Integer labelFg = 0xFFFFFF;
    static final int labelFgAlpha = 225;
    boolean hideSneaks;
    boolean showHeading;
    Minecraft minecraft;
    TextureImpl texture;
    TextureImpl locatorTexture;
    WeakReference<EntityLivingBase> entityLivingRef;
    String customName;
    boolean flip;
    double entityScale;
    boolean entityBlur;

    private DrawEntityStep(EntityLivingBase entityLiving) {
        this.hideSneaks = JourneymapClient.getCoreProperties().hideSneakingEntities.get();
        this.showHeading = true;
        this.minecraft = Minecraft.func_71410_x();
        this.entityLivingRef = new WeakReference<EntityLivingBase>(entityLiving);
    }

    public void update(boolean flip, TextureImpl locatorTexture, TextureImpl texture, boolean showHeading, double entityScale, boolean entityBlur) {
        this.locatorTexture = locatorTexture;
        this.texture = texture;
        this.flip = flip;
        this.showHeading = showHeading;
        this.entityScale = entityScale;
        this.entityBlur = entityBlur;
        EntityLivingBase entityLiving = (EntityLivingBase)this.entityLivingRef.get();
        if (entityLiving != null) {
            this.customName = DataCache.instance().getEntityDTO((EntityLivingBase)entityLiving).customName;
        }
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        EntityLivingBase entityLiving = (EntityLivingBase)this.entityLivingRef.get();
        if (entityLiving == null || entityLiving.field_70128_L || entityLiving.func_98034_c((EntityPlayer)this.minecraft.field_71439_g) || !entityLiving.field_70175_ag || this.hideSneaks && entityLiving.func_70093_af()) {
            return;
        }
        drawScale = (float)((double)drawScale * this.entityScale);
        Point2D.Double pixel = gridRenderer.getPixel(entityLiving.field_70165_t, entityLiving.field_70161_v);
        if (pixel != null) {
            double heading = entityLiving.field_70759_as;
            double drawX = ((Point2D)pixel).getX() + xOffset;
            double drawY = ((Point2D)pixel).getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.field_70163_u > this.minecraft.field_71439_g.field_70163_u) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.field_70163_u - this.minecraft.field_71439_g.field_70163_u) / 32.0));
            }
            if (entityLiving instanceof EntityPlayer) {
                int blockSize = (int)Math.pow(2.0, gridRenderer.getZoom());
                float labelOffset = this.texture != null ? (float)(this.texture.getHeight() / blockSize) : 0.0f;
                this.drawPlayer(drawX, drawY, gridRenderer, alpha, heading, drawScale, fontScale, rotation);
            } else {
                this.drawCreature(drawX, drawY, gridRenderer, alpha, heading, drawScale, fontScale, rotation);
            }
        }
    }

    private void drawPlayer(double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, float drawScale, double fontScale, double rotation) {
        EntityLivingBase entityLiving = (EntityLivingBase)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        if (this.locatorTexture != null && this.showHeading) {
            DrawUtil.drawEntity(drawX, drawY, heading, false, this.locatorTexture, alpha, drawScale, rotation, true);
        }
        if (this.texture != null) {
            DrawUtil.drawEntity(drawX, drawY, heading, true, this.texture, alpha, drawScale * 0.75f, rotation, true);
        }
        int labelOffset = this.texture == null ? 0 : (rotation == 0.0 ? -this.texture.getHeight() / 2 : this.texture.getHeight() / 2);
        Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, -labelOffset);
        Team team = entityLiving.func_96124_cp();
        if (team == null || !(entityLiving instanceof EntityPlayer)) {
            DrawUtil.drawLabel(ForgeHelper.INSTANCE.getEntityName((Entity)entityLiving), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 205, 65280, 255, fontScale, false, rotation);
        } else {
            String playerName = ScorePlayerTeam.func_96667_a((Team)entityLiving.func_96124_cp(), (String)ForgeHelper.INSTANCE.getEntityName((Entity)entityLiving));
            DrawUtil.drawLabel(playerName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 205, 0xFFFFFF, 255, fontScale, false, rotation);
        }
    }

    private void drawCreature(double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, float drawScale, double fontScale, double rotation) {
        int labelOffset;
        EntityLivingBase entityLiving = (EntityLivingBase)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        Math.min(1.0f, Math.max(0.0f, (float)(16.0 - (entityLiving.field_70163_u - this.minecraft.field_71439_g.field_70163_u))));
        if (this.locatorTexture != null && this.showHeading) {
            DrawUtil.drawEntity(drawX, drawY, heading, false, this.locatorTexture, alpha, drawScale, rotation, true);
        }
        int n = this.texture == null ? 8 : (labelOffset = rotation == 0.0 ? this.texture.getHeight() : -this.texture.getHeight());
        if (this.customName != null) {
            Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, labelOffset);
            DrawUtil.drawCenteredLabel(this.customName, labelPoint.getX(), labelPoint.getY(), labelBg, 180, (Integer)0xFFFFFF, 225, fontScale, rotation);
        }
        if (this.texture != null) {
            DrawUtil.drawEntity(drawX, drawY, heading, true, this.texture, alpha, drawScale, rotation, this.entityBlur);
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<EntityLivingBase, DrawEntityStep> {
        public DrawEntityStep load(EntityLivingBase entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

