/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.gui.widgets;

import mcp.mobius.opis.gui.events.MouseEvent;
import mcp.mobius.opis.gui.interfaces.CType;
import mcp.mobius.opis.gui.interfaces.IWidget;
import mcp.mobius.opis.gui.interfaces.Signal;
import mcp.mobius.opis.gui.widgets.LayoutBase;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Point;

public class LayoutCanvas
extends LayoutBase {
    private MouseEvent lastMouseEvent;
    private IWidget draggedWidget = null;

    public LayoutCanvas() {
        super(null);
        this.setGeometry(0.0, 0.0, this.rez.func_78326_a(), this.rez.func_78328_b(), CType.ABSXY, CType.ABSXY);
        Mouse.getDWheel();
        this.lastMouseEvent = new MouseEvent(this);
    }

    @Override
    public void draw() {
        this.rez = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.setGeometry(0.0, 0.0, this.rez.func_78326_a(), this.rez.func_78328_b(), CType.ABSXY, CType.ABSXY);
        super.draw();
        this.handleMouseInput();
    }

    @Override
    public void draw(Point pos) {
        super.draw(pos);
    }

    @Override
    public void handleMouseInput() {
        MouseEvent event = new MouseEvent(this);
        MouseEvent.EventType type = event.getEventType(this.lastMouseEvent);
        IWidget targetWidget = this.getWidgetAtCoordinates(event.x, event.y);
        switch (type) {
            case CLICK: {
                if (targetWidget == null) break;
                targetWidget.onMouseClick(event);
                break;
            }
            case DRAG: {
                if (targetWidget == null) break;
                targetWidget.onMouseDrag(event);
                break;
            }
            case MOVE: {
                if (targetWidget == null) break;
                targetWidget.onMouseMove(event);
                break;
            }
            case RELEASED: {
                if (targetWidget == null) break;
                targetWidget.onMouseRelease(event);
                break;
            }
            case WHEEL: {
                if (targetWidget == null) break;
                targetWidget.onMouseWheel(event);
                break;
            }
            case ENTER: {
                if (event.trgwidget != null) {
                    event.trgwidget.onMouseEnter(event);
                }
                if (this.lastMouseEvent.trgwidget == null) break;
                event.type = MouseEvent.EventType.LEAVE;
                this.lastMouseEvent.trgwidget.onMouseLeave(event);
                break;
            }
            case NONE: {
                break;
            }
        }
        this.lastMouseEvent = event;
    }

    @Override
    public void onWidgetEvent(IWidget srcwidget, Signal signal, Object ... params) {
        if (signal == Signal.DRAGGED) {
            this.draggedWidget = srcwidget;
        } else {
            super.onWidgetEvent(srcwidget, signal, params);
        }
    }

    @Override
    public void onMouseRelease(MouseEvent event) {
        if (event.button == 0) {
            this.draggedWidget = null;
        }
        super.onMouseRelease(event);
    }

    @Override
    public void onMouseDrag(MouseEvent event) {
        if (this.draggedWidget != null) {
            this.draggedWidget.onMouseDrag(event);
        } else {
            super.onMouseDrag(event);
        }
    }

    public boolean hasWidgetAtCursor() {
        double y;
        double x = (double)Mouse.getEventX() * (double)this.getSize().getX() / (double)this.mc.field_71443_c;
        IWidget widget = this.getWidgetAtCoordinates(x, y = (double)this.getSize().getY() - (double)Mouse.getEventY() * (double)this.getSize().getY() / (double)this.mc.field_71440_d - 1.0);
        return widget != null && !widget.equals(this);
    }
}

