/*
 * Decompiled with CFR 0.152.
 */
package advsolar.client.nei;

import advsolar.client.gui.GuiMolecularTransformer;
import advsolar.utils.ItemStackUtil;
import advsolar.utils.MTRecipeManager;
import advsolar.utils.MTRecipeRecord;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class MTRecipeHandler
extends TemplateRecipeHandler {
    public int ticks;

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)167, (int)67);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(17, 35, 12, 12), this.getRecipeId(), new Object[0]));
    }

    public String getRecipeName() {
        return "Molecular Transformer";
    }

    public String getRecipeId() {
        return "Molecular Transformer";
    }

    public void drawExtras(int r) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(15, 29, 177, 3, 10, 9, f, 1);
        CachedMTRecipe recipe = (CachedMTRecipe)((Object)this.arecipes.get(r));
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ItemStack inputStack = recipe.input;
        ItemStack outputStack = recipe.output;
        int energy = recipe.energy;
        String formatedEnergy = GuiMolecularTransformer.parsingNumber(String.valueOf(energy));
        fontRenderer.func_78276_b("Input: " + inputStack.func_82833_r(), 46, 18, 0xFFFFFF);
        fontRenderer.func_78276_b("Output: " + outputStack.func_82833_r(), 46, 28, 0xFFFFFF);
        fontRenderer.func_78276_b("Energy: " + formatedEnergy, 46, 38, 0xFFFFFF);
    }

    public String getGuiTexture() {
        return "advancedsolarpanel:textures/gui/guiMolecularTransformer_nei.png";
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MTRecipeRecord record : MTRecipeManager.transformerRecipes) {
            if (!ItemStackUtil.areStacksEqual(record.inputStack, ingredient)) continue;
            this.arecipes.add(new CachedMTRecipe(record.inputStack, record.outputStack, record.energyPerOperation));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (MTRecipeRecord record : MTRecipeManager.transformerRecipes) {
                this.arecipes.add(new CachedMTRecipe(record.inputStack, record.outputStack, record.energyPerOperation));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack ingredient) {
        for (MTRecipeRecord record : MTRecipeManager.transformerRecipes) {
            if (!ItemStackUtil.areStacksEqual(record.outputStack, ingredient)) continue;
            this.arecipes.add(new CachedMTRecipe(record.inputStack, record.outputStack, record.energyPerOperation));
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMolecularTransformer.class;
    }

    public class CachedMTRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ItemStack input;
        public ItemStack output;
        public int energy;

        public CachedMTRecipe(ItemStack input, ItemStack output, int energy) {
            super((TemplateRecipeHandler)MTRecipeHandler.this);
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.input, 12, 8);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.output, 12, 43);
        }
    }
}

