/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import java.util.List;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.misc.TimeType;
import serverutils.task.NotifyTask;

public abstract class Task {
    protected long nextTime;
    protected long interval;
    protected boolean repeatable;

    public Task() {
        this(-1L, Ticks.NO_TICKS, false);
    }

    public Task(Ticks interval) {
        this(System.currentTimeMillis(), interval, true);
    }

    public Task(long whenToRun) {
        this(whenToRun, Ticks.NO_TICKS, false);
    }

    public Task(long whenToRun, Ticks ticks, boolean repeatable) {
        this.interval = this.getTimeType() == TimeType.MILLIS ? ticks.millis() : ticks.ticks();
        this.nextTime = whenToRun + this.interval;
        this.repeatable = repeatable;
    }

    public abstract void execute(Universe var1);

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public long getNextTime() {
        return this.nextTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setNextTime(long time) {
        this.nextTime = time;
        this.queueNotifications(Universe.get());
    }

    public void queueNotifications(Universe universe) {
        List<NotifyTask> notifications = this.getNotifications();
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        this.getNotifications().forEach(universe::scheduleTask);
    }

    protected List<NotifyTask> getNotifications() {
        return null;
    }

    public boolean isComplete(Universe universe) {
        return (this.getTimeType() == TimeType.TICKS ? universe.ticks.ticks() : System.currentTimeMillis()) >= this.getNextTime();
    }

    protected TimeType getTimeType() {
        return TimeType.MILLIS;
    }
}

