/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import codechicken.lib.vec.BlockCoord;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.IInOutRenderSettings;
import com.thecodewarrior.catwalks.block.BlockCatwalk;
import com.thecodewarrior.catwalks.util.BiPredicates;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockScaffold
extends Block
implements ICustomLadder,
IInOutRenderSettings {
    IIcon side;
    IIcon top;
    IIcon inventory_top;
    IIcon inventory_side;
    IIcon builders_side;
    IIcon builders_top;
    IIcon builders_inventory_top;
    IIcon builders_inventory_side;
    private static final BiPredicate<BlockCoord, World> hasScaffoldAt = BiPredicates.hasLoadedBlockMatching(BlockScaffold::isScaffold);

    public BlockScaffold() {
        super(Material.field_151573_f);
        this.func_149647_a(CatwalkMod.catwalkTab);
        this.func_149672_a(CatwalkMod.catwalkSounds);
        this.func_149663_c("scaffold");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack((Block)this, 1, 0));
        subItems.add(new ItemStack((Block)this, 1, 1));
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) != 0;
    }

    public static boolean isScaffold(Block block) {
        return block instanceof BlockScaffold;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        ForgeDirection side = ForgeDirection.getOrientation((int)blockSide);
        if (CatwalkUtil.isHoldingWrench(player)) {
            if (player.func_70093_af()) {
                CatwalkUtil.retractBlock(world, x, y, z, side.getOpposite(), player, hasScaffoldAt);
            } else {
                int meta = world.func_72805_g(x, y, z);
                meta = meta == 0 ? 1 : 0;
                world.func_72921_c(x, y, z, meta, 3);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.side = reg.func_94245_a("catwalks:scaffold_side");
        this.top = reg.func_94245_a("catwalks:scaffold_top");
        this.inventory_top = reg.func_94245_a("catwalks:inventory/scaffold_top");
        this.inventory_side = reg.func_94245_a("catwalks:inventory/scaffold_side");
        this.builders_side = reg.func_94245_a("catwalks:scaffold_builders_side");
        this.builders_top = reg.func_94245_a("catwalks:scaffold_builders_top");
        this.builders_inventory_top = reg.func_94245_a("catwalks:inventory/scaffold_builders_top");
        this.builders_inventory_side = reg.func_94245_a("catwalks:inventory/scaffold_builders_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int _side, int meta) {
        if (_side >= 100) {
            ForgeDirection side = ForgeDirection.getOrientation((int)(_side - 100));
            if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
                return meta == 0 ? this.inventory_top : this.builders_inventory_top;
            }
            return meta == 0 ? this.inventory_side : this.builders_inventory_side;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return meta == 0 ? this.top : this.builders_top;
        }
        return meta == 0 ? this.side : this.builders_side;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int _side) {
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        return !w.isSideSolid(x, y, z, side, false) || w.func_147439_a(x, y, z) instanceof BlockCatwalk;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> arr = new ArrayList<ItemStack>();
        arr.add(new ItemStack(Item.func_150898_a((Block)this), 1, metadata == 1 ? 1 : 0));
        return arr;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public int func_149645_b() {
        return CatwalkMod.inAndOutRenderType;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() ? 0.0 : 0.15;
    }

    @Override
    public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.3;
    }

    @Override
    public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
        return true;
    }

    @Override
    public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() || BlockScaffold.isScaffold(CatwalkUtil.getHeldBlock(entity)) || CatwalkUtil.isHoldingWrench(entity, false);
    }

    @Override
    public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() && (BlockScaffold.isScaffold(CatwalkUtil.getHeldBlock(entity)) || CatwalkUtil.isHoldingWrench(entity, false));
    }

    @Override
    public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.15;
    }

    @Override
    public boolean shouldForceBackFaceRender() {
        return false;
    }
}

