/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IOreFilterable;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelNormal;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.building.InventoryAnalysis;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class AEPartData {
    public PortableItemStack mPart;
    public String mSettingsName = null;
    public NBTTagCompound mSettings = null;
    public String mCustomName = null;
    public PortableItemStack[] mAEUpgrades = null;
    public InventoryAnalysis mConfig = null;
    public InventoryAnalysis mAEPatterns = null;
    public String mOreDict = null;
    public boolean mP2POutput = false;
    public long mP2PFreq = 0L;
    public int priority = 0;
    private transient Optional<Class<? extends IPart>> mPartClass;

    public AEPartData() {
    }

    public AEPartData(IPart part) {
        IConfigurableObject configurable;
        this.mPart = new PortableItemStack(part.getItemStack(PartItemStack.Wrench));
        if (part instanceof ICustomNameObject) {
            ICustomNameObject customName = (ICustomNameObject)part;
            String string = this.mCustomName = customName.hasCustomName() ? customName.getCustomName() : null;
        }
        if (part instanceof IOreFilterable) {
            IOreFilterable filterable = (IOreFilterable)part;
            this.mOreDict = filterable.getFilter();
            if ("".equals(this.mOreDict)) {
                this.mOreDict = null;
            }
        }
        if (part instanceof IConfigurableObject && (configurable = (IConfigurableObject)part).getConfigManager() != null) {
            NBTTagCompound settings = new NBTTagCompound();
            configurable.getConfigManager().writeToNBT(settings);
            NBTTagCompound nBTTagCompound = this.mSettings = settings.func_82582_d() ? null : settings;
        }
        if (part instanceof PartP2PTunnel) {
            PartP2PTunnel tunnel = (PartP2PTunnel)part;
            this.mP2POutput = tunnel.isOutput();
            this.mP2PFreq = tunnel.getFrequency();
        }
        if (part instanceof ISegmentedInventory) {
            IInventory patterns;
            IInventory config;
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)part;
            IInventory upgrades = segmentedInventory.getInventoryByName("upgrades");
            if (upgrades != null) {
                this.mAEUpgrades = (PortableItemStack[])MMUtils.streamInventory(upgrades).filter(x -> x != null).map(PortableItemStack::new).toArray(PortableItemStack[]::new);
            }
            if ((config = segmentedInventory.getInventoryByName("config")) != null) {
                this.mConfig = InventoryAnalysis.fromInventory(config, false);
            }
            if ((patterns = segmentedInventory.getInventoryByName("patterns")) != null) {
                this.mAEPatterns = InventoryAnalysis.fromInventory(patterns, false);
            }
        }
        if (part instanceof IPriorityHost) {
            IPriorityHost priorityHost = (IPriorityHost)part;
            this.priority = priorityHost.getPriority();
        }
    }

    public Class<? extends IPart> getPartClass() {
        Item item;
        if (this.mPartClass == null && (item = this.mPart.toStack().func_77973_b()) instanceof IPartItem) {
            IPartItem partItem = (IPartItem)item;
            IPart part = partItem.createPartFromItemStack(this.mPart.toStack());
            this.mPartClass = Optional.ofNullable(part).map(Object::getClass);
        }
        return this.mPartClass.orElse(null);
    }

    public boolean isPartSubclassOf(Class<? extends IPart> superclass) {
        return superclass.isAssignableFrom(this.getPartClass());
    }

    public boolean isP2P() {
        return this.isPartSubclassOf(PartP2PTunnel.class);
    }

    public boolean isAttunable() {
        return this.isPartSubclassOf(PartP2PTunnelNormal.class);
    }

    public boolean updatePart(BlockAnalyzer.IBlockApplyContext context, IPartHost partHost, ForgeDirection side) {
        IConfigurableObject configurable;
        IPart part = partHost.getPart(side);
        boolean success = true;
        if (part instanceof PartP2PTunnelNormal && this.isAttunable()) {
            partHost.removePart(side, true);
            partHost.addPart(this.mPart.toStack(), side, context.getRealPlayer());
            part = partHost.getPart(side);
        }
        if (part instanceof PartP2PTunnel) {
            PartP2PTunnel tunnel = (PartP2PTunnel)part;
            tunnel.output = this.mP2POutput;
            if (tunnel.getFrequency() != this.mP2PFreq) {
                try {
                    P2PCache p2p = tunnel.getProxy().getP2P();
                    p2p.updateFreq(tunnel, this.mP2PFreq);
                }
                catch (GridAccessException e) {
                    tunnel.setFrequency(this.mP2PFreq);
                }
            }
            tunnel.onTunnelConfigChange();
        }
        if (part instanceof ICustomNameObject) {
            ICustomNameObject customName = (ICustomNameObject)part;
            if (this.mCustomName != null) {
                customName.setCustomName(this.mCustomName);
            }
        }
        if (part instanceof IConfigurableObject && (configurable = (IConfigurableObject)part).getConfigManager() != null) {
            NBTTagCompound settings = this.mSettings == null ? new NBTTagCompound() : this.mSettings;
            configurable.getConfigManager().readFromNBT(settings);
        }
        if (part instanceof ISegmentedInventory) {
            IInventory config;
            UpgradeInventory upgradeInv;
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)part;
            IInventory iInventory = segmentedInventory.getInventoryByName("upgrades");
            if (iInventory instanceof UpgradeInventory && !MMUtils.installUpgrades(context, upgradeInv = (UpgradeInventory)iInventory, this.mAEUpgrades, true, false)) {
                success = false;
            }
            if ((config = segmentedInventory.getInventoryByName("config")) != null && !this.mConfig.apply(context, config, false, false)) {
                success = false;
            }
            IInventory patterns = segmentedInventory.getInventoryByName("patterns");
            if (this.mAEPatterns != null && patterns != null && !this.mAEPatterns.apply(context, patterns, true, false)) {
                success = false;
            }
        }
        if (part instanceof IOreFilterable) {
            IOreFilterable filterable = (IOreFilterable)part;
            filterable.setFilter(this.mOreDict == null ? "" : this.mOreDict);
        }
        if (part instanceof IPriorityHost) {
            IPriorityHost priorityHost = (IPriorityHost)part;
            priorityHost.setPriority(this.priority);
        }
        return success;
    }

    public boolean getRequiredItemsForExistingPart(BlockAnalyzer.IBlockApplyContext context, IPartHost partHost, ForgeDirection side) {
        IPart part = partHost.getPart(side);
        boolean success = true;
        if (part instanceof ISegmentedInventory) {
            UpgradeInventory upgradeInv;
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)part;
            IInventory iInventory = segmentedInventory.getInventoryByName("upgrades");
            if (iInventory instanceof UpgradeInventory && !MMUtils.installUpgrades(context, upgradeInv = (UpgradeInventory)iInventory, this.mAEUpgrades, true, false)) {
                success = false;
            }
            IInventory patterns = segmentedInventory.getInventoryByName("patterns");
            if (this.mAEPatterns != null && patterns != null && !this.mAEPatterns.apply(context, patterns, true, true)) {
                success = false;
            }
        }
        return success;
    }

    public boolean getRequiredItemsForNewPart(BlockAnalyzer.IBlockApplyContext context) {
        if (this.mAEUpgrades != null) {
            for (IItemProvider iItemProvider : this.mAEUpgrades) {
                context.tryConsumeItems(((PortableItemStack)iItemProvider).toStack());
            }
        }
        if (this.mAEPatterns != null) {
            for (IItemProvider iItemProvider : this.mAEPatterns.mItems) {
                if (iItemProvider == null) continue;
                iItemProvider.getStack(context, true);
            }
        }
        return true;
    }

    public ItemStack getEffectivePartStack() {
        if (this.isAttunable() && this.isP2P()) {
            return (ItemStack)AEApi.instance().definitions().parts().p2PTunnelME().maybeStack(1).get();
        }
        return this.mPart.toStack();
    }

    public AEPartData clone() {
        AEPartData dup = new AEPartData();
        dup.mPart = this.mPart == null ? null : this.mPart.clone();
        dup.mSettingsName = this.mSettingsName;
        dup.mSettings = this.mSettings == null ? null : (NBTTagCompound)this.mSettings.func_74737_b();
        dup.mCustomName = this.mCustomName;
        dup.mAEUpgrades = this.mAEUpgrades == null ? null : MMUtils.mapToArray(this.mAEUpgrades, PortableItemStack[]::new, x -> x == null ? null : x.clone());
        dup.mConfig = this.mConfig == null ? null : this.mConfig.clone();
        dup.mAEPatterns = this.mAEPatterns == null ? null : this.mAEPatterns.clone();
        dup.mOreDict = this.mOreDict;
        dup.mP2POutput = this.mP2POutput;
        dup.mP2PFreq = this.mP2PFreq;
        dup.priority = this.priority;
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPart == null ? 0 : this.mPart.hashCode());
        result = 31 * result + (this.mSettingsName == null ? 0 : this.mSettingsName.hashCode());
        result = 31 * result + (this.mSettings == null ? 0 : this.mSettings.hashCode());
        result = 31 * result + (this.mCustomName == null ? 0 : this.mCustomName.hashCode());
        result = 31 * result + Arrays.hashCode(this.mAEUpgrades);
        result = 31 * result + (this.mConfig == null ? 0 : this.mConfig.hashCode());
        result = 31 * result + (this.mAEPatterns == null ? 0 : this.mAEPatterns.hashCode());
        result = 31 * result + (this.mOreDict == null ? 0 : this.mOreDict.hashCode());
        result = 31 * result + Boolean.hashCode(this.mP2POutput);
        result = 31 * result + Long.hashCode(this.mP2PFreq);
        result = 31 * result + (this.mPartClass == null ? 0 : this.mPartClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AEPartData other = (AEPartData)obj;
        if (this.mPart == null ? other.mPart != null : !this.mPart.equals(other.mPart)) {
            return false;
        }
        if (this.mSettingsName == null ? other.mSettingsName != null : !this.mSettingsName.equals(other.mSettingsName)) {
            return false;
        }
        if (this.mSettings == null ? other.mSettings != null : !this.mSettings.equals((Object)other.mSettings)) {
            return false;
        }
        if (this.mCustomName == null ? other.mCustomName != null : !this.mCustomName.equals(other.mCustomName)) {
            return false;
        }
        if (!Arrays.equals(this.mAEUpgrades, other.mAEUpgrades)) {
            return false;
        }
        if (this.mConfig == null ? other.mConfig != null : !this.mConfig.equals(other.mConfig)) {
            return false;
        }
        if (this.mAEPatterns == null ? other.mAEPatterns != null : !this.mAEPatterns.equals(other.mAEPatterns)) {
            return false;
        }
        if (this.mOreDict == null ? other.mOreDict != null : !this.mOreDict.equals(other.mOreDict)) {
            return false;
        }
        if (this.mP2POutput != other.mP2POutput) {
            return false;
        }
        if (this.mP2PFreq != other.mP2PFreq) {
            return false;
        }
        return !(this.mPartClass == null ? other.mPartClass != null : !this.mPartClass.equals(other.mPartClass));
    }
}

