/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel {
    private long lastBlickTick = -1L;
    protected String name;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() instanceof ItemDarkSteelPickaxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        if (!ItemDarkSteelPickaxe.isEquipped(player)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.func_71045_bC()) >= requiredPower;
    }

    public static ItemDarkSteelPickaxe create() {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe(String name, Item.ToolMaterial mat) {
        super(mat);
        this.name = name;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = name + "_pickaxe";
        this.func_77655_b(str);
        this.func_111206_d(EnderIO.DOMAIN + ":" + str);
    }

    public ItemDarkSteelPickaxe() {
        this("darkSteel", ItemDarkSteelSword.MATERIAL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        SpoonUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean func_150894_a(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase entLiving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0 && this.useObsidianEffeciency(item, block)) {
            this.extractEnergy(item, Config.darkSteelPickPowerUseObsidian, false);
        }
        return super.func_150894_a(item, world, block, x, y, z, entLiving);
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (!this.isTravelUpgradeActive(player, item) && world.field_72995_K) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    static boolean doRightClickItemPlace(EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int slot;
        int current = player.field_71071_by.field_70461_c;
        int n = slot = current == 0 && Config.slotZeroPlacesEight ? 8 : current + 1;
        if (slot < 9 && player.field_71071_by.field_70462_a[slot] != null && !(player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof IDarkSteelItem)) {
            player.field_71071_by.field_70461_c = slot;
            Minecraft mc = Minecraft.func_71410_x();
            boolean result = mc.field_71442_b.func_78760_a((EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e, player.field_71071_by.field_70462_a[slot], mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d, mc.field_71476_x.field_72310_e, mc.field_71476_x.field_72307_f);
            player.field_71071_by.field_70461_c = current;
            return result;
        }
        return false;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelPickPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block == Blocks.field_150431_aC ? true : block == Blocks.field_150433_aE || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(ItemStack item) {
        return SpoonUpgrade.loadFromItem(item) != null;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.useObsidianEffeciency(stack, block)) {
            return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered + (float)Config.darkSteelPickEffeciencyObsidian;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public float func_150893_a(ItemStack item, Block block) {
        if (block.func_149688_o() == Material.field_151592_s) {
            return this.field_77864_a;
        }
        return super.func_150893_a(item, block);
    }

    private boolean useObsidianEffeciency(ItemStack item, Block block) {
        boolean useObsidianSpeed = false;
        int energy = this.getEnergyStored(item);
        if (energy > Config.darkSteelPickPowerUseObsidian) {
            boolean bl = useObsidianSpeed = block == Blocks.field_150343_Z;
            if (!useObsidianSpeed && Config.darkSteelPickApplyObsidianEffeciencyAtHardess > 0.0f) {
                try {
                    useObsidianSpeed = block != null && block.func_149712_f(null, -1, -1, -1) >= Config.darkSteelPickApplyObsidianEffeciencyAtHardess;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return useObsidianSpeed;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        if (this.hasSpoonUpgrade(stack)) {
            set.add("shovel");
        }
        return set;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item." + this.name + "_pickaxe.tooltip.effPowered"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyObsidian + " " + EnderIO.lang.localize("item." + this.name + "_pickaxe.tooltip.effObs") + " ");
            list.add(EnumChatFormatting.WHITE + "     (" + EnderIO.lang.localize("item." + this.name + "_pickaxe.tooltip.cost") + " " + PowerDisplayUtil.formatPower(Config.darkSteelPickPowerUseObsidian) + " " + PowerDisplayUtil.abrevation() + ")");
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    @Override
    public int canExtractInternal(ItemStack equipped, int power) {
        return Math.min(this.getEnergyStored(equipped), power);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped) {
        return ItemDarkSteelPickaxe.isEquipped(ep) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isTravelUpgradeActive(player, stack)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, world, player, TravelSource.STAFF)) {
                player.func_71038_i();
                return stack;
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, player)) {
                player.func_71038_i();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }
}

