/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeTooltipLineHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class RecipeItemInputHandler
implements IContainerInputHandler,
IContainerTooltipHandler {
    protected RecipeTooltipLineHandler recipeTooltipLineHandler = null;

    public static void load() {
        RecipeItemInputHandler recipeHandler = new RecipeItemInputHandler();
        GuiContainerManager.addInputHandler(recipeHandler);
        GuiContainerManager.addTooltipHandler(recipeHandler);
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
        return ShortcutInputHandler.handleKeyEvent(GuiContainerManager.getStackMouseOver(gui));
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (!(gui instanceof GuiRecipe) || ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.bookmarkPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey)) {
            return false;
        }
        return ShortcutInputHandler.handleMouseClick(GuiContainerManager.getStackMouseOver(gui));
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        if (gui instanceof GuiRecipe || ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.bookmarkPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey)) {
            hotkeys.putAll(ShortcutInputHandler.handleHotkeys(gui, mousex, mousey, GuiContainerManager.getStackMouseOver(gui)));
        }
        return hotkeys;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        if (itemstack != null) {
            Recipe.RecipeId recipeId = this.getHoveredRecipeId(gui, itemstack, mousex, mousey);
            if (recipeId == null) {
                this.recipeTooltipLineHandler = null;
            } else if (this.recipeTooltipLineHandler == null || !this.recipeTooltipLineHandler.getRecipeId().equals(recipeId)) {
                this.recipeTooltipLineHandler = new RecipeTooltipLineHandler(recipeId);
            }
            if (this.recipeTooltipLineHandler != null) {
                currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.recipeTooltipLineHandler));
            }
        } else {
            this.recipeTooltipLineHandler = null;
        }
        return currenttip;
    }

    private Recipe.RecipeId getHoveredRecipeId(GuiContainer gui, ItemStack itemstack, int mousex, int mousey) {
        if (ItemPanels.bookmarkPanel.contains(mousex, mousey)) {
            BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mousex, mousey);
            if (slot != null && slot.getRecipeId() != null && !slot.isIngredient() && NEIClientConfig.getRecipeTooltipsMode() != 0) {
                int tooltipMode = NEIClientConfig.getRecipeTooltipsMode();
                BookmarkPanel.BookmarkViewMode viewMode = slot.getGroup().viewMode;
                if (tooltipMode == 3 || viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT && tooltipMode == 1 || viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && tooltipMode == 2) {
                    return slot.getRecipeId();
                }
            }
            return null;
        }
        if (ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey)) {
            return NEIClientConfig.showRecipeTooltipInPanel() ? FavoriteRecipes.getFavorite(itemstack) : null;
        }
        if (gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)gui;
            if (new Rectangle4i(gui.field_147003_i, gui.field_147009_r, gui.field_146999_f, gui.field_147000_g).contains(mousex, mousey) && NEIClientConfig.showRecipeTooltipInGui() && guiRecipe.getFocusedRecipe() == null) {
                return FavoriteRecipes.getFavorite(itemstack);
            }
        }
        return null;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyID) {
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }
}

