/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.ItemStackSet;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarkStorage;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.bookmark.GroupingItem;
import codechicken.nei.bookmark.SortableGroup;
import codechicken.nei.bookmark.SortableItem;
import codechicken.nei.recipe.AcceptsFollowingTooltipLineHandler;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import codechicken.nei.recipe.chain.RecipeChainTooltipLineHandler;
import codechicken.nei.util.NEIMouseUtils;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class BookmarkPanel
extends PanelWidget<BookmarkGrid> {
    protected BookmarkStorage storage = new BookmarkStorage();
    public SortableItem sortableItem;
    public SortableGroup sortableGroup;
    public GroupingItem groupingItem;
    protected AcceptsFollowingTooltipLineHandler acceptsFollowingTooltipLineHandler;
    protected RecipeChainTooltipLineHandler recipeChainTooltipLineHandler;
    public Button namespacePrev;
    public Button namespaceNext;
    public Button pullBookmarkedItems;
    public Label namespaceLabel;

    public BookmarkPanel() {
        this.grid = new BookmarkGrid();
    }

    @Override
    public void update() {
        this.grid = this.storage.getActiveGrid();
    }

    @Override
    public void init() {
        super.init();
        this.namespaceLabel = new Label("1", true);
        this.namespacePrev = new Button("<"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.storage.prevNamespace();
            }
        };
        this.namespaceNext = new Button(">"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (BookmarkPanel.this.inEditingState() || rightclick) {
                    return false;
                }
                return BookmarkPanel.this.storage.nextNamespace();
            }
        };
        this.pullBookmarkedItems = new Button("P"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.pullBookmarkItems(0, NEIClientUtils.shiftKey());
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("bookmark.pullBookmarkedItems.tip", new Object[0]);
            }
        };
    }

    @Override
    public BookmarksGridSlot getSlotMouseOver(int mousex, int mousey) {
        return (BookmarksGridSlot)((BookmarkGrid)this.grid).getSlotMouseOver(mousex, mousey);
    }

    @Override
    public String getLabelText() {
        if (((BookmarkGrid)this.grid).isCraftingMode(0)) {
            return String.format("\u00a72[\u00a7r%d/%d\u00a72]\u00a7r", this.getPage(), Math.max(1, this.getNumPages()));
        }
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    public boolean inEditingState() {
        return this.sortableItem != null || this.sortableGroup != null || this.draggedStack != null || this.groupingItem != null && this.groupingItem.hasEndRow();
    }

    public boolean addItem(ItemStack stack) {
        return this.addItem(stack, null, 0);
    }

    public boolean addItem(ItemStack itemStack, Recipe.RecipeId recipeId, int groupId) {
        if (itemStack != null && ((BookmarkGrid)this.grid).indexOf(groupId, itemStack, recipeId, false) == -1) {
            boolean existsRecipe = recipeId != null && ((BookmarkGrid)this.grid).existsRecipe(recipeId, 0);
            NBTTagCompound nbTag = StackInfo.itemStackToNBT(itemStack);
            long factor = nbTag.func_74762_e("Count");
            if (existsRecipe) {
                for (int i = 0; i < ((BookmarkGrid)this.grid).size(); ++i) {
                    if (!((BookmarkGrid)this.grid).getBookmarkItem(i).equalsRecipe(recipeId, groupId)) continue;
                    long multiplier = ((BookmarkGrid)this.grid).getBookmarkItem(i).getMultiplier();
                    factor *= multiplier;
                    break;
                }
            } else {
                factor = nbTag.func_74764_b("gtFluidName") ? (long)Math.min(144, nbTag.func_74762_e("Count")) : 1L;
            }
            ((BookmarkGrid)this.grid).addItem(BookmarkItem.of(groupId, itemStack, factor, recipeId, false), true);
            return true;
        }
        return false;
    }

    public boolean addRecipe(Recipe recipe, int groupId) {
        Recipe.RecipeId recipeId = recipe.getRecipeId();
        if (recipe != null && ((BookmarkGrid)this.grid).getGroup(groupId) != null && !((BookmarkGrid)this.grid).existsRecipe(recipeId, groupId)) {
            ((BookmarkGrid)this.grid).addRecipe(recipe, groupId);
            return true;
        }
        return false;
    }

    public boolean addGroup(List<?> items, BookmarkViewMode viewMode, boolean crafting) {
        if (items.isEmpty()) {
            return false;
        }
        if (viewMode == null) {
            viewMode = ((BookmarkGrid)this.grid).getViewMode(0);
        }
        int groupId = ((BookmarkGrid)this.grid).addGroup(new BookmarkGroup(viewMode, crafting));
        ItemStackSet uniqueStack = new ItemStackSet();
        HashSet<Recipe.RecipeId> uniqueRecipe = new HashSet<Recipe.RecipeId>();
        for (Object item : items) {
            ItemStack stack;
            if (item instanceof Recipe) {
                Recipe recipe = (Recipe)item;
                if (!uniqueRecipe.add(recipe.getRecipeId())) continue;
                ((BookmarkGrid)this.grid).addRecipe(recipe, groupId);
                continue;
            }
            if (item instanceof Recipe.RecipeId) {
                Recipe.RecipeId recipeId = (Recipe.RecipeId)item;
                stack = recipeId.getResult();
                if (stack == null || !uniqueRecipe.add(recipeId)) continue;
                ((BookmarkGrid)this.grid).addItem(BookmarkItem.of(groupId, stack, StackInfo.getAmount(stack), recipeId, false), true);
                uniqueStack.add(stack);
                continue;
            }
            stack = BookmarkPanel.extractItem(item);
            if (stack == null || uniqueStack.contains(stack)) continue;
            ((BookmarkGrid)this.grid).addItem(BookmarkItem.of(groupId, stack), true);
            uniqueStack.add(stack);
        }
        return true;
    }

    protected static ItemStack extractItem(Object item) {
        if (item instanceof PositionedStack) {
            PositionedStack positionedStack = (PositionedStack)item;
            return positionedStack.item;
        }
        if (item instanceof NBTTagCompound) {
            NBTTagCompound nbTag = (NBTTagCompound)item;
            return StackInfo.loadFromNBT(nbTag);
        }
        if (item instanceof Recipe.RecipeIngredient) {
            Recipe.RecipeIngredient ingr = (Recipe.RecipeIngredient)item;
            return ingr.getItemStack();
        }
        if (item instanceof ItemStack) {
            ItemStack stack = (ItemStack)item;
            return stack;
        }
        return null;
    }

    public boolean removeItem(ItemStack itemStack, Recipe.RecipeId recipeId, int groupId) {
        int itemIndex = ((BookmarkGrid)this.grid).indexOf(groupId, itemStack, recipeId, false);
        if (itemIndex != -1) {
            ((BookmarkGrid)this.grid).removeRecipe(itemIndex, false);
            return true;
        }
        return false;
    }

    public boolean removeSlot(int mousex, int mousey, boolean removeFullRecipe) {
        BookmarksGridSlot slot = this.getSlotMouseOver(mousex, mousey);
        if (slot == null) {
            return false;
        }
        int groupId = slot.getGroupId();
        Recipe.RecipeId recipeId = slot.getRecipeId();
        BookmarkGroup group = slot.getGroup();
        if (recipeId == null || !removeFullRecipe) {
            ((BookmarkGrid)this.grid).removeRecipe(slot.itemIndex, removeFullRecipe);
            return true;
        }
        if (group.crafting != null && group.collapsed && removeFullRecipe) {
            ((BookmarkGrid)this.grid).removeGroup(groupId);
            return true;
        }
        if (group.crafting != null) {
            Set<Object> recipes = group.crafting.recipeRelations.getOrDefault(recipeId, Collections.emptySet());
            if (removeFullRecipe && recipes.isEmpty()) {
                for (Map.Entry<Recipe.RecipeId, Set<Recipe.RecipeId>> entry : group.crafting.recipeRelations.entrySet()) {
                    if (!entry.getValue().contains(recipeId)) continue;
                    recipes = entry.getValue();
                    break;
                }
            }
            if (!recipes.isEmpty()) {
                boolean removed = false;
                for (Recipe.RecipeId relRecipeId : recipes) {
                    removed = ((BookmarkGrid)this.grid).removeRecipe(relRecipeId, groupId) || removed;
                }
                return removed;
            }
        }
        return ((BookmarkGrid)this.grid).removeRecipe(recipeId, groupId);
    }

    public boolean removeRecipe(Recipe.RecipeId recipeId, int groupId) {
        return ((BookmarkGrid)this.grid).removeRecipe(recipeId, groupId);
    }

    public boolean removeGroup(int groupId) {
        if (((BookmarkGrid)this.grid).getGroup(groupId) != null) {
            ((BookmarkGrid)this.grid).removeGroup(groupId);
            return true;
        }
        return false;
    }

    public Recipe.RecipeId getRecipeId(int itemIndex) {
        BookmarkItem meta = ((BookmarkGrid)this.grid).getCalculatedItem(itemIndex);
        return meta.isIngredient ? null : meta.recipeId;
    }

    public boolean existsRecipe(Recipe.RecipeId recipeId, int groupId) {
        return ((BookmarkGrid)this.grid).existsRecipe(recipeId, groupId);
    }

    public int getHoveredGroupId(boolean groupPanel) {
        int overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(groupPanel);
        if (groupPanel && overRowIndex == -1 && !((BookmarkGrid)this.grid).isEmpty()) {
            Point mouse = GuiDraw.getMousePosition();
            if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mouse.x, mouse.y)) {
                return 0;
            }
        }
        if (overRowIndex >= 0) {
            int groupId = ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex);
            return groupId == 0 ? -1 : groupId;
        }
        return -1;
    }

    protected String getNamespaceLabelText(boolean shortFormat) {
        String activePage = String.valueOf(this.storage.getActiveIndex() + 1);
        return shortFormat ? activePage : activePage + "/" + this.storage.getNamespaceSize();
    }

    public void load() {
        File bookmarkFile;
        File dir;
        String worldPath = "global";
        if (NEIClientConfig.getBooleanSetting("inventory.bookmarks.worldSpecific")) {
            worldPath = NEIClientConfig.getWorldPath();
        }
        if (!(dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath)).exists()) {
            dir.mkdirs();
        }
        if (!(bookmarkFile = new File(dir, "bookmarks.ini")).exists()) {
            File defaultBookmarks;
            File globalBookmarks = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/bookmarks.ini");
            File configBookmarks = new File(NEIClientConfig.configDir, "bookmarks.ini");
            File file = defaultBookmarks = configBookmarks.exists() ? configBookmarks : globalBookmarks;
            if (defaultBookmarks.exists()) {
                try {
                    if (bookmarkFile.createNewFile()) {
                        FileInputStream src = new FileInputStream(defaultBookmarks);
                        FileOutputStream dst = new FileOutputStream(bookmarkFile);
                        IOUtils.copy((InputStream)src, (OutputStream)dst);
                        ((InputStream)src).close();
                        ((OutputStream)dst).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.storage.load(bookmarkFile);
    }

    public void save() {
        this.storage.save();
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        int rows = (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons);
        int diff = rows * 19 + this.getMarginTop(gui) - this.y;
        if (diff > 0) {
            this.y += diff;
            this.h -= diff;
        }
        return super.resizeHeader(gui);
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        int labelWidth;
        int BUTTON_SIZE = 16;
        ButtonCycled button = LayoutManager.bookmarksButton;
        int leftBorder = this.y + this.h > button.y ? button.x + button.w + 2 : this.x;
        int rightBorder = this.x + this.w;
        int center = leftBorder + Math.max(0, (rightBorder - leftBorder) / 2);
        this.pullBookmarkedItems.h = 16;
        this.namespaceNext.h = 16;
        this.namespacePrev.h = 16;
        this.pullBookmarkedItems.w = 16;
        this.namespaceNext.w = 16;
        this.namespacePrev.w = 16;
        this.namespaceNext.y = this.pullBookmarkedItems.y = this.y + this.h - 16;
        this.namespacePrev.y = this.pullBookmarkedItems.y;
        if (rightBorder - leftBorder >= 70) {
            labelWidth = 36;
            this.namespaceLabel.text = this.getNamespaceLabelText(false);
        } else {
            labelWidth = 18;
            this.namespaceLabel.text = this.getNamespaceLabelText(true);
        }
        this.namespaceLabel.y = this.namespacePrev.y + 5;
        this.namespaceLabel.x = center;
        this.namespacePrev.x = center - labelWidth / 2 - 2 - this.namespacePrev.w;
        this.namespaceNext.x = center + labelWidth / 2 + 2;
        this.pullBookmarkedItems.x = center + 2 * labelWidth / 2 + 2;
        return 18;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (((BookmarkGrid)this.grid).getPerPage() > 0 && !this.storage.isEmpty()) {
            LayoutManager.addWidget(this.namespacePrev);
            LayoutManager.addWidget(this.namespaceNext);
            LayoutManager.addWidget(this.namespaceLabel);
            if (!((BookmarkGrid)this.grid).isEmpty() && BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
                LayoutManager.addWidget(this.pullBookmarkedItems);
            }
        }
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.bookmarks";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, StackInfo.getAmount(itemStack));
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (((BookmarkGrid)this.grid).getSlotBySlotIndex(this.mouseDownSlot) == null) {
            this.mouseDownSlot = -1;
        }
        if (this.groupingItem != null) {
            int overRowIndex = ((BookmarkGrid)this.grid).getRowIndex(mousey);
            if (this.groupingItem.hasEndRow() || overRowIndex != this.groupingItem.getStartSlotIndex() || heldTime > 250L) {
                this.groupingItem.setEndPoint(Math.max(0, Math.min(overRowIndex, ((BookmarkGrid)this.grid).getLastRowIndex())));
            }
            return;
        }
        if (this.sortableGroup != null) {
            int overRowIndex = ((BookmarkGrid)this.grid).getRowIndex(mousey);
            if (overRowIndex >= 0 && this.sortableGroup.groupId != ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex)) {
                ((BookmarkGrid)this.grid).moveGroup(this.sortableGroup, overRowIndex);
            }
            return;
        }
        if (this.sortableItem != null) {
            if (!this.sortableItem.isEmpty()) {
                this.sortableItem.mouseDragged(mousex, mousey);
            }
            return;
        }
        if (button == 0 && NEIClientUtils.shiftKey() && this.mouseDownSlot >= 0 && this.sortableItem == null) {
            BookmarksGridSlot slot;
            BookmarksGridSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if ((mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 250L) && (slot = (BookmarksGridSlot)((BookmarkGrid)this.grid).getSlotBySlotIndex(this.mouseDownSlot)) != null && slot.itemIndex >= 0) {
                this.sortableItem = new SortableItem((BookmarkGrid)this.grid, slot.getBookmarkItem());
                ((BookmarkGrid)this.grid).onGridChanged();
            }
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    private int getNextSlot() {
        int slotIndex;
        int columns = ((BookmarkGrid)this.grid).getColumns();
        int perPage = ((BookmarkGrid)this.grid).getRows() * columns;
        boolean line = ((BookmarkGrid)this.grid).getViewMode(0) == BookmarkViewMode.TODO_LIST;
        List<BookmarksGridSlot> mask = ((BookmarkGrid)this.grid).getMask();
        int n = slotIndex = mask.isEmpty() ? 0 : mask.get((int)(mask.size() - 1)).slotIndex + 1;
        while (slotIndex < perPage) {
            if (!(line && slotIndex % columns != 0 || ((BookmarkGrid)this.grid).isInvalidSlot(slotIndex))) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        int slotIndex;
        if (this.sortableItem != null) {
            this.sortableItem.postDraw(mousex, mousey);
        }
        if (this.sortableGroup != null) {
            this.sortableGroup.postDraw(mousex, mousey);
        }
        if (ItemPanels.itemPanel.draggedStack != null && this.contains(mousex, mousey) && (slotIndex = this.getNextSlot()) >= 0) {
            Rectangle4i rect = ((BookmarkGrid)this.grid).getSlotRect(slotIndex);
            NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, ItemsGrid.HIGHLIGHT_COLOR);
        }
        super.postDraw(mousex, mousey);
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        int groupId;
        int overRowIndex;
        if (button == 0 && NEIClientUtils.shiftKey()) {
            overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true);
            int n = groupId = overRowIndex != -1 ? ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex) : 0;
            if (groupId != 0) {
                int rowIndex;
                for (rowIndex = overRowIndex; rowIndex >= 0 && groupId == ((BookmarkGrid)this.grid).getRowGroupId(rowIndex); --rowIndex) {
                }
                Rectangle4i rect = ((BookmarkGrid)this.grid).getSlotRect(rowIndex + 1, 0);
                this.sortableGroup = new SortableGroup((BookmarkGrid)this.grid, groupId);
                this.sortableGroup.shiftX = rect.x - mousex;
                this.sortableGroup.shiftY = rect.y - mousey;
                return true;
            }
        }
        if (!(NEIClientUtils.shiftKey() || button != 0 && button != 1 || (overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true)) == -1)) {
            groupId = ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex);
            if (button == 1) {
                groupId = 0;
            } else if (groupId == 0) {
                groupId = Integer.MIN_VALUE;
            }
            this.groupingItem = new GroupingItem((BookmarkGrid)this.grid, groupId, overRowIndex);
            if (this.groupingItem.startPoint.topRowIndex == -1 || this.groupingItem.startPoint.bottomRowIndex == -1) {
                this.groupingItem = null;
            }
            return true;
        }
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            if (NEIClientUtils.altKey() && button == 0) {
                ((BookmarkGrid)this.grid).toggleCollapsedState(0);
                NEIClientUtils.playClickSound();
            } else if (button == 0) {
                ((BookmarkGrid)this.grid).toggleViewMode(0);
                NEIClientUtils.playClickSound();
            } else if (button == 1) {
                ((BookmarkGrid)this.grid).toggleCraftingMode(0);
                NEIClientUtils.playClickSound();
            }
            return true;
        }
        return super.handleClickExt(mousex, mousey, button);
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        if (((BookmarkGrid)this.grid).getPerPage() == 0 || ((BookmarkGrid)this.grid).isEmpty()) {
            return new ArrayList<String>();
        }
        int overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true);
        if (overRowIndex != -1) {
            int groupId = ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex);
            currenttip.add(NEIClientUtils.translate("bookmark.group", new Object[0]));
            if (groupId != 0) {
                currenttip = this.recipeChainTooltip(groupId, currenttip);
            } else {
                this.recipeChainTooltipLineHandler = null;
            }
        } else if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            currenttip.add(NEIClientUtils.translate("bookmark.group", new Object[0]));
            currenttip = this.recipeChainTooltip(0, currenttip);
        } else {
            this.recipeChainTooltipLineHandler = null;
        }
        return super.handleTooltip(gui, mousex, mousey, currenttip);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        BookmarksGridSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && button == 0 && NEIClientUtils.altKey()) {
            BookmarkGroup group = hoverSlot.getGroup();
            if (group.collapsed) {
                group.collapsed = false;
                NEIClientUtils.playClickSound();
                ((BookmarkGrid)this.grid).onItemsChanged();
            } else if (group.crafting != null && hoverSlot.getRecipeId() != null) {
                ((BookmarkGrid)this.grid).toggleCollapsedRecipe(hoverSlot.getGroupId(), hoverSlot.getRecipeId());
                NEIClientUtils.playClickSound();
            }
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        int overRowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true);
        BookmarksGridSlot slot = this.getSlotMouseOver(mousex, mousey);
        if (((BookmarkGrid)this.grid).getPerPage() == 0 || ((BookmarkGrid)this.grid).isEmpty()) {
            return hotkeys;
        }
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            hotkeys.put(NEIClientUtils.getKeyName(0x2000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity", new Object[0]));
            hotkeys.put(NEIClientUtils.getKeyName(0xA000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity_step", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("bookmark.group.toggle_mode", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("bookmark.group.toggle_crafting_chain", new Object[0]));
            hotkeys.put(NEIClientConfig.getKeyName("gui.remove_recipe"), NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items"), NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items", 0x4000000), NEIClientUtils.translate("bookmark.group.pull_items_shift", new Object[0]));
            }
            hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate("bookmark.group.toggle_collapse", new Object[0]));
        }
        if (overRowIndex != -1) {
            int groupId = ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex);
            hotkeys.put(NEIMouseUtils.getKeyName(0x4000000), NEIClientUtils.translate("bookmark.group.include_group", new Object[0]));
            if (groupId != 0) {
                hotkeys.put(NEIClientUtils.getKeyName(0x2000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity", new Object[0]));
                hotkeys.put(NEIClientUtils.getKeyName(0xA000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity_step", new Object[0]));
                hotkeys.put(NEIMouseUtils.getKeyName(0x4000001), NEIClientUtils.translate("bookmark.group.exclude_group", new Object[0]));
                hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("bookmark.group.toggle_mode", new Object[0]));
                hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("bookmark.group.toggle_crafting_chain", new Object[0]));
                hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0x4000000), NEIClientUtils.translate("bookmark.group.sorting", new Object[0]));
                hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate("bookmark.group.toggle_collapse", new Object[0]));
            }
        }
        if (slot != null) {
            BookmarkGroup group = slot.getGroup();
            hotkeys.put(NEIClientUtils.getKeyName(0x2000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity", new Object[0]));
            hotkeys.put(NEIClientUtils.getKeyName(0xA000000, -2013265920), NEIClientUtils.translate("bookmark.change_quantity_step", new Object[0]));
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0x4000000), NEIClientUtils.translate("bookmark.item.sorting", new Object[0]));
            if (group.collapsed) {
                hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate("bookmark.group.toggle_collapse", new Object[0]));
            } else if (group.crafting != null) {
                hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate("bookmark.recipe.toggle_collapse", new Object[0]));
            }
            if (this.acceptsFollowingTooltipLineHandler != null) {
                hotkeys.put(NEIClientUtils.getKeyName(0x4000000, -2013265920), NEIClientUtils.translate("recipe.accepts.scroll", new Object[0]));
            }
        }
        return hotkeys;
    }

    private List<String> recipeChainTooltip(int groupId, List<String> currenttip) {
        boolean crafting;
        boolean bl = crafting = ((BookmarkGrid)this.grid).getGroup((int)groupId).crafting != null;
        if (this.recipeChainTooltipLineHandler == null || this.recipeChainTooltipLineHandler.groupId != groupId || this.recipeChainTooltipLineHandler.crafting != crafting) {
            this.recipeChainTooltipLineHandler = new RecipeChainTooltipLineHandler(groupId, crafting, ((BookmarkGrid)this.grid).createRecipeChainMath(groupId));
        }
        if (this.recipeChainTooltipLineHandler != null) {
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.recipeChainTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public boolean contains(int px, int py) {
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(px, py)) {
            return true;
        }
        if (((BookmarkGrid)this.grid).getHoveredRowIndex(true) != -1) {
            return true;
        }
        return super.contains(px, py);
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        BookmarksGridSlot slot = (BookmarksGridSlot)((BookmarkGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (slot != null) {
            if (slot.isIngredient() && slot.getRecipeId() != null && slot.getBookmarkItem().permutations.size() > 1) {
                Recipe.RecipeId recipeId = slot.getRecipeId();
                if (recipeId == null) {
                    this.acceptsFollowingTooltipLineHandler = null;
                } else if (this.acceptsFollowingTooltipLineHandler == null || (Integer)this.acceptsFollowingTooltipLineHandler.tooltipGUID != slot.itemIndex) {
                    this.acceptsFollowingTooltipLineHandler = AcceptsFollowingTooltipLineHandler.of(slot.itemIndex, new ArrayList<ItemStack>(slot.getBookmarkItem().permutations.values()), slot.getItemStack(), 2);
                }
                if (this.acceptsFollowingTooltipLineHandler != null) {
                    currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.acceptsFollowingTooltipLineHandler));
                }
            } else {
                this.acceptsFollowingTooltipLineHandler = null;
            }
        } else {
            this.acceptsFollowingTooltipLineHandler = null;
        }
        return currenttip;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.sortableItem != null) {
            ((BookmarkGrid)this.grid).onItemsChanged();
        } else if (this.sortableGroup != null) {
            ((BookmarkGrid)this.grid).onItemsChanged();
        } else if (this.groupingItem != null && this.groupingItem.hasEndRow()) {
            ((BookmarkGrid)this.grid).createGroup(this.groupingItem);
            ((BookmarkGrid)this.grid).onItemsChanged();
        } else {
            int groupId;
            int rowIndex = ((BookmarkGrid)this.grid).getHoveredRowIndex(true);
            int n = groupId = rowIndex != -1 ? ((BookmarkGrid)this.grid).getRowGroupId(rowIndex) : 0;
            if (groupId != 0) {
                if (button == 0 && NEIClientUtils.altKey()) {
                    ((BookmarkGrid)this.grid).toggleCollapsedState(groupId);
                    NEIClientUtils.playClickSound();
                } else if (button == 0) {
                    ((BookmarkGrid)this.grid).toggleViewMode(groupId);
                    NEIClientUtils.playClickSound();
                } else if (button == 1) {
                    ((BookmarkGrid)this.grid).toggleCraftingMode(groupId);
                    NEIClientUtils.playClickSound();
                }
                ((BookmarkGrid)this.grid).onItemsChanged();
            } else {
                super.mouseUp(mousex, mousey, button);
            }
        }
        this.sortableItem = null;
        this.sortableGroup = null;
        this.groupingItem = null;
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int shift, int mousex, int mousey) {
        if (!this.inEditingState() && new Rectangle4i(this.namespacePrev.x, this.namespacePrev.y, this.namespaceNext.x + this.namespaceNext.w - this.namespacePrev.x, this.namespacePrev.h).contains(mousex, mousey)) {
            if (shift > 0) {
                this.storage.prevNamespace();
            } else {
                this.storage.nextNamespace();
            }
            return true;
        }
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        if (!this.inEditingState() && NEIClientUtils.controlKey()) {
            BookmarksGridSlot slot = (BookmarksGridSlot)((BookmarkGrid)this.grid).getSlotMouseOver(mousex, mousey);
            if (slot != null) {
                int multiplier = 1;
                if (NEIClientUtils.altKey()) {
                    int n = multiplier = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
                    if (multiplier == 0) {
                        multiplier = slot.getItemStack().func_77976_d();
                    }
                }
                ((BookmarkGrid)this.grid).shiftItemAmount(slot.itemIndex, multiplier * shift);
                return true;
            }
            int groupId = this.getHoveredGroupId(true);
            if (groupId != -1) {
                int multiplier = 1;
                if (NEIClientUtils.altKey()) {
                    int n = multiplier = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
                    if (multiplier == 0) {
                        multiplier = 64;
                    }
                }
                ((BookmarkGrid)this.grid).shiftGroupAmount(groupId, multiplier * shift);
                return true;
            }
        }
        if (!this.inEditingState() && NEIClientUtils.shiftKey() && ((BookmarkGrid)this.grid).contains(mousex, mousey) && this.acceptsFollowingTooltipLineHandler != null) {
            int itemIndex = (Integer)this.acceptsFollowingTooltipLineHandler.tooltipGUID;
            BookmarkItem item = ((BookmarkGrid)this.grid).getCalculatedItem(itemIndex);
            if (item.permutations.size() > 1) {
                List items = this.acceptsFollowingTooltipLineHandler.items;
                ItemStack activeStack = this.acceptsFollowingTooltipLineHandler.getActiveStack();
                int stackIndex = 0;
                for (int i = 0; i < items.size(); ++i) {
                    if (!StackInfo.equalItemAndNBT(activeStack, (ItemStack)items.get(i), true)) continue;
                    stackIndex = i;
                    break;
                }
                activeStack = (ItemStack)items.get((items.size() - shift + stackIndex) % items.size());
                this.acceptsFollowingTooltipLineHandler.setActiveStack(activeStack);
                ((BookmarkGrid)this.grid).getBookmarkItem((int)Math.abs((int)itemIndex)).itemStack = activeStack;
                ((BookmarkGrid)this.grid).onItemsChanged();
            }
            return true;
        }
        if (super.onMouseWheel(shift, mousex, mousey)) {
            int overRowIndex = ((BookmarkGrid)this.grid).getRowIndex(mousey);
            if (this.sortableGroup != null && overRowIndex >= 0 && this.sortableGroup.groupId != ((BookmarkGrid)this.grid).getRowGroupId(overRowIndex)) {
                ((BookmarkGrid)this.grid).moveGroup(this.sortableGroup, overRowIndex);
            }
            if (this.groupingItem != null && (this.groupingItem.hasEndRow() || overRowIndex != this.groupingItem.getStartSlotIndex())) {
                this.groupingItem.setEndPoint(Math.max(0, Math.min(overRowIndex, ((BookmarkGrid)this.grid).getLastRowIndex())));
            }
            return true;
        }
        return false;
    }

    public boolean pullBookmarkItems(int groupId, boolean shift) {
        return this.pullBookmarkItems(((BookmarkGrid)this.grid).createRecipeChainMath(groupId), shift);
    }

    public boolean pullBookmarkItems(RecipeChainMath math, boolean shift) {
        ItemStackAmount inventory;
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        IBookmarkContainerHandler containerHandler = BookmarkContainerInfo.getBookmarkContainerHandler(guiContainer);
        if (containerHandler == null || math == null) {
            return false;
        }
        ItemStackAmount pullItemStacks = new ItemStackAmount();
        InventoryPlayer playerInventory = guiContainer.field_146297_k.field_71439_g.field_71071_by;
        ItemStackAmount itemStackAmount = inventory = shift ? ItemStackAmount.of(Arrays.asList(playerInventory.field_70462_a)) : new ItemStackAmount();
        if (math.outputRecipes.isEmpty()) {
            for (BookmarkItem item : math.initialItems) {
                long invStackSize = inventory.getOrDefault(item.itemStack, 0L);
                long amount = item.amount - invStackSize * (long)item.fluidCellAmount;
                if (amount <= 0L) continue;
                pullItemStacks.add(item.getItemStack(amount));
            }
        } else {
            ItemStackAmount containerStorage = ItemStackAmount.of(containerHandler.getStorageStacks(guiContainer));
            ArrayList<BookmarkItem> initialItems = new ArrayList<BookmarkItem>();
            for (BookmarkItem item : math.initialItems) {
                long strStackSize;
                long invStackSize = inventory.getOrDefault(item.itemStack, 0L);
                long amount = item.amount - invStackSize * (long)item.fluidCellAmount - (strStackSize = containerStorage.getOrDefault(item.itemStack, 0L)) * (long)item.fluidCellAmount;
                if (amount <= 0L) continue;
                initialItems.add(item.copyWithAmount(amount));
            }
            math.initialItems.clear();
            math.initialItems.addAll(initialItems);
            for (ItemStack stack : inventory.values()) {
                math.initialItems.add(BookmarkItem.of(-1, stack));
            }
            for (ItemStack stack : containerStorage.values()) {
                math.initialItems.add(BookmarkItem.of(-2, stack));
            }
            math.refresh();
            for (BookmarkItem item : math.initialItems) {
                if (item.groupId != -2 || math.requiredAmount.getOrDefault(item, -1L) <= 0L) continue;
                pullItemStacks.add(item.getItemStack(math.requiredAmount.get(item)));
            }
        }
        if (pullItemStacks.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int freeSlots = 0;
        for (ItemStack stack : playerInventory.field_70462_a) {
            if (stack != null && (stack.field_77994_a >= stack.func_77976_d() || !pullItemStacks.contains(stack))) continue;
            ++freeSlots;
        }
        if (freeSlots == 0) {
            return false;
        }
        for (ItemStack stack : pullItemStacks.values()) {
            stack.field_77994_a = Math.min(stack.field_77994_a, freeSlots * stack.func_77976_d());
            if (stack.field_77994_a <= 0) continue;
            items.add(stack);
        }
        if (!items.isEmpty()) {
            containerHandler.pullBookmarkItemsFromContainer(guiContainer, items);
        }
        return true;
    }

    public void clearTooltips() {
        this.acceptsFollowingTooltipLineHandler = null;
        this.recipeChainTooltipLineHandler = null;
    }

    @Deprecated
    public void addItem(ItemStack stack, boolean saveSize) {
        this.addItem(saveSize ? stack : StackInfo.withAmount(stack, 0L));
    }

    @Deprecated
    public void addOrRemoveItem(ItemStack stack) {
        if (!this.removeItem(stack, null, 0)) {
            this.addItem(stack);
        }
    }

    @Deprecated
    public void addOrRemoveItem(ItemStack stack, String handlerName, List<PositionedStack> ingredients, boolean saveIngredients, boolean saveSize) {
        if (!this.removeItem(stack, null, 0)) {
            if (saveIngredients && handlerName != null && !handlerName.isEmpty() && ingredients != null && !ingredients.isEmpty()) {
                this.addRecipe(Recipe.of(Arrays.asList(stack), handlerName, ingredients), 0);
            } else {
                this.addItem(stack, saveSize);
            }
        }
    }

    @Deprecated
    public void addRecipe(BookmarkRecipe recipe, boolean saveSize) {
        this.addRecipe(recipe, saveSize, 0);
    }

    @Deprecated
    public void addRecipe(BookmarkRecipe recipe, boolean saveSize, int groupId) {
        this.addRecipe(recipe.getRecipe(), groupId);
    }

    @Deprecated
    public void addBookmarkGroup(List<ItemStack> items, BookmarkViewMode viewMode) {
        this.addGroup(items, viewMode, false);
    }

    @Deprecated
    public void addBookmarkGroup(List<BookmarkRecipe> recipes, BookmarkViewMode viewMode, boolean crafting) {
        ArrayList<Recipe> items = new ArrayList<Recipe>();
        for (BookmarkRecipe recipe : recipes) {
            items.add(recipe.getRecipe());
        }
        this.addGroup(items, viewMode, crafting);
    }

    @Deprecated
    public BookmarkRecipeId getBookmarkRecipeId(int itemIndex) {
        BookmarkItem item = ((BookmarkGrid)this.grid).getCalculatedItem(itemIndex);
        return item == null || item.isIngredient || item.recipeId == null ? null : new BookmarkRecipeId(item.recipeId.getHandleName(), item.recipeId.getIngredients());
    }

    @Deprecated
    public BookmarkRecipeId getBookmarkRecipeId(ItemStack stackA) {
        BookmarkRecipeId recipeId = null;
        for (int itemIndex = 0; itemIndex < ((BookmarkGrid)this.grid).size(); ++itemIndex) {
            if (!StackInfo.equalItemAndNBT(stackA, ((BookmarkGrid)this.grid).getBookmarkItem((int)itemIndex).itemStack, true) || (recipeId = this.getBookmarkRecipeId(itemIndex)) == null) continue;
            return recipeId;
        }
        return null;
    }

    @Deprecated
    public boolean removeBookmarkRecipeId(BookmarkRecipeId recipeId) {
        return false;
    }

    public static enum BookmarkViewMode {
        DEFAULT,
        TODO_LIST;

    }

    @Deprecated
    public static class BookmarkRecipe {
        public String handlerName = "";
        public List<ItemStack> result = new ArrayList<ItemStack>();
        public List<ItemStack> ingredients = new ArrayList<ItemStack>();
        public BookmarkRecipeId recipeId = null;

        public BookmarkRecipe(ItemStack ... result) {
            this.result.addAll(Arrays.asList(result));
        }

        public BookmarkRecipeId getRecipeId() {
            if (!this.handlerName.isEmpty() && !this.ingredients.isEmpty() && this.recipeId == null) {
                this.recipeId = new BookmarkRecipeId(this.handlerName, this.ingredients);
            }
            return this.recipeId;
        }

        public Recipe getRecipe() {
            String handlerName = this.handlerName;
            if (handlerName.isEmpty() && this.recipeId != null) {
                handlerName = this.recipeId.handlerName;
            }
            return Recipe.of(this.result, handlerName, this.ingredients);
        }
    }
}

