/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.visrelay;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.glease.tc4tweak.CommonUtils;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.TC4Tweak;
import net.glease.tc4tweak.asm.ITileVisNode;
import net.glease.tc4tweak.modules.visrelay.SetParentHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.visnet.VisNetHandler;

public class SavedLinkHandler {
    private static String getNodeType(TileVisNode node) {
        return node.isSource() ? "Source" : "Relay";
    }

    public static boolean processSavedLink(ITileVisNode visNode) {
        Action action;
        TileVisNode node = (TileVisNode)visNode;
        WorldCoordinates c = new WorldCoordinates((TileEntity)node);
        try {
            action = SavedLinkHandler.processSavedLink0(visNode);
        }
        catch (Exception e) {
            TC4Tweak.log.error("Failed to process saved link. Defaulting to no saved link!", (Throwable)e);
            visNode.clearSavedLink();
            return false;
        }
        if (ConfigurationHandler.INSTANCE.isSavedLinkDebugEnabled() && action != Action.DISABLED) {
            TC4Tweak.log.info("Processed saved link for node {} at {},{},{}: {}", new Object[]{SavedLinkHandler.getNodeType(node), c.x, c.y, c.z, action});
        }
        return action.returnValue();
    }

    private static Action processSavedLink0(ITileVisNode visNode) {
        TileVisNode next;
        List<ChunkCoordinates> link = visNode.getSavedLink();
        if (link == null) {
            return Action.DISABLED;
        }
        TileVisNode node = (TileVisNode)visNode;
        ChunkCoordinates c = link.get(0);
        World w = node.func_145831_w();
        if (!w.func_72899_e(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
            return Action.RETURN;
        }
        TileEntity tile = w.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        if (!SavedLinkHandler.canConnect(node, tile)) {
            HashMap sourcelist = (HashMap)VisNetHandler.sources.get(w.field_73011_w.field_76574_g);
            TileVisNode sourcenode = (TileVisNode)CommonUtils.deref((Reference)sourcelist.get(new WorldCoordinates(c.field_71574_a, c.field_71572_b, c.field_71573_c, w.field_73011_w.field_76574_g)));
            if (sourcenode == null) {
                visNode.clearSavedLink();
                return Action.CLEAR_CONTINUE;
            }
            tile = sourcenode;
        }
        if ((next = (TileVisNode)tile).isSource()) {
            SetParentHelper.setParent(next, node);
            w.func_147471_g(node.field_145851_c, node.field_145848_d, node.field_145849_e);
            node.parentChanged();
            visNode.clearSavedLink();
            return Action.SET_PARENT_RETURN;
        }
        ITileVisNode nextExt = (ITileVisNode)next;
        List<ChunkCoordinates> nextLink = nextExt.getSavedLink();
        if (nextLink == null) {
            visNode.clearSavedLink();
            if (VisNetHandler.isNodeValid((WeakReference)next.getRootSource())) {
                SetParentHelper.setParent(next, node);
                w.func_147471_g(node.field_145851_c, node.field_145848_d, node.field_145849_e);
                node.parentChanged();
                return Action.SET_PARENT_RETURN;
            }
            return Action.CLEAR_CONTINUE;
        }
        if (link.size() == 1 || nextLink.get(0).equals((Object)link.get(1))) {
            return Action.RETURN;
        }
        visNode.clearSavedLink();
        return Action.CLEAR_CONTINUE;
    }

    private static boolean canConnect(TileVisNode node, TileEntity tile) {
        if (!(tile instanceof TileVisNode)) {
            return false;
        }
        TileVisNode next = (TileVisNode)tile;
        if (VisNetHandler.canNodeBeSeen((TileVisNode)node, (TileVisNode)next)) {
            return true;
        }
        return node.getAttunement() == -1 || next.getAttunement() == -1 || next.getAttunement() == node.getAttunement();
    }

    public static List<ChunkCoordinates> readFromNBT(TileVisNode thiz, NBTTagCompound tag) {
        if (thiz.isSource() || !tag.func_74764_b("Link") || !ConfigurationHandler.INSTANCE.isSavedLinkEnabled()) {
            return null;
        }
        NBTTagList linkRaw = tag.func_150295_c("Link", 10);
        TC4Tweak.log.trace("Reading link for node {} at {},{},{}. {} nodes.", new Object[]{SavedLinkHandler.getNodeType(thiz), thiz.field_145851_c, thiz.field_145848_d, thiz.field_145849_e, linkRaw.func_74745_c()});
        ArrayList<ChunkCoordinates> link = new ArrayList<ChunkCoordinates>();
        int end = Math.min(linkRaw.func_74745_c(), 2);
        for (int i = 0; i < end; ++i) {
            link.add(SavedLinkHandler.readOne(linkRaw.func_150305_b(i)));
        }
        return link;
    }

    public static void writeToNBT(TileVisNode thiz, NBTTagCompound tag) {
        if (thiz.isSource() || !ConfigurationHandler.INSTANCE.isSavedLinkEnabled()) {
            return;
        }
        TileVisNode root = (TileVisNode)CommonUtils.deref(thiz.getRootSource());
        if (root == null) {
            return;
        }
        NBTTagList path = new NBTTagList();
        TileVisNode node = (TileVisNode)CommonUtils.deref(thiz.getParent());
        while (node != null && (path.func_74745_c() <= 1 || ConfigurationHandler.INSTANCE.isSavedLinkSaveWholeLink())) {
            path.func_74742_a((NBTBase)SavedLinkHandler.writeOne(node));
            node = (TileVisNode)CommonUtils.deref(node.getParent());
        }
        tag.func_74782_a("Link", (NBTBase)path);
        TC4Tweak.log.trace("Written link for node {} at {},{},{}. {} element.", new Object[]{SavedLinkHandler.getNodeType(thiz), thiz.field_145851_c, thiz.field_145848_d, thiz.field_145849_e, path.func_74745_c()});
    }

    private static NBTTagCompound writeOne(TileVisNode node) {
        NBTTagCompound elem = new NBTTagCompound();
        elem.func_74768_a("x", node.field_145851_c);
        elem.func_74768_a("y", node.field_145848_d);
        elem.func_74768_a("z", node.field_145849_e);
        return elem;
    }

    private static ChunkCoordinates readOne(NBTTagCompound elem) {
        return new ChunkCoordinates(elem.func_74762_e("x"), elem.func_74762_e("y"), elem.func_74762_e("z"));
    }

    private static enum Action {
        RETURN(true),
        SET_PARENT_RETURN(true),
        CLEAR_CONTINUE(false),
        DISABLED(false);

        private final boolean decision;

        private Action(boolean decision) {
            this.decision = decision;
        }

        public boolean returnValue() {
            return this.decision;
        }
    }
}

