/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.DummyWorld;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.google.common.collect.AbstractIterator;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3ic;

public class SchemaWorld
extends DummyWorld
implements ISchema {
    private final ObjectLinkedOpenHashSet<BlockPos> blocks = new ObjectLinkedOpenHashSet();
    private BiPredicate<BlockPos, BlockInfo> renderFilter;
    private final BlockPos min = new BlockPos();
    private final BlockPos max = new BlockPos();

    public SchemaWorld() {
        this((blockPos, blockInfo) -> true);
    }

    public SchemaWorld(BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    public boolean func_147465_d(int x, int y, int z, Block blockIn, int metadataIn, int flags) {
        boolean state;
        boolean renderTest;
        BlockPos pos = new BlockPos(x, y, z);
        BlockInfo blockInfo = BlockInfo.of((IBlockAccess)this, pos);
        if (this.renderFilter == null || this.renderFilter.test(pos, blockInfo)) {
            renderTest = true;
            state = super.func_147465_d(x, y, z, blockIn, metadataIn, flags);
        } else {
            state = false;
            renderTest = false;
        }
        if (blockInfo.getBlock().isAir((IBlockAccess)this, x, y, z)) {
            if (this.blocks.remove((Object)pos) && BlockPosUtil.isOnBorder(this.min, this.max, pos)) {
                if (this.blocks.isEmpty()) {
                    this.min.set(0, 0, 0);
                    this.max.set(0, 0, 0);
                } else {
                    this.min.set((Vector3ic)BlockPosUtil.MAX);
                    this.max.set((Vector3ic)BlockPosUtil.MIN);
                    for (BlockPos pos1 : this.blocks) {
                        BlockPosUtil.setMin(this.min, pos1);
                        BlockPosUtil.setMax(this.max, pos1);
                    }
                }
            }
        } else if (this.blocks.isEmpty()) {
            if (!renderTest) {
                return false;
            }
            this.blocks.add((Object)pos);
            this.min.set((Vector3ic)pos);
            this.max.set((Vector3ic)pos);
        } else if (renderTest && this.blocks.add((Object)pos)) {
            BlockPosUtil.setMin(this.min, pos);
            BlockPosUtil.setMax(this.max, pos);
        }
        return renderTest && state;
    }

    @Override
    public World getWorld() {
        return this;
    }

    @Override
    public Vector3d getFocus() {
        return BlockPosUtil.getCenterD(this.min, this.max);
    }

    @Override
    public BlockPos getOrigin() {
        return this.min;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockInfo>> iterator() {
        return new AbstractIterator<Map.Entry<BlockPos, BlockInfo>>(){
            private final ObjectListIterator<BlockPos> it;
            private final BlockInfo.Mut info;
            private final MutablePair<BlockPos, BlockInfo> pair;
            {
                this.it = SchemaWorld.this.blocks.iterator();
                this.info = new BlockInfo.Mut();
                this.pair = new MutablePair(null, (Object)this.info);
            }

            protected Map.Entry<BlockPos, BlockInfo> computeNext() {
                while (this.it.hasNext()) {
                    BlockPos pos = (BlockPos)this.it.next();
                    this.info.set((IBlockAccess)SchemaWorld.this, pos);
                    this.pair.setLeft((Object)pos);
                    if (SchemaWorld.this.renderFilter != null && !SchemaWorld.this.renderFilter.test(pos, this.info)) continue;
                    return this.pair;
                }
                return (Map.Entry)this.endOfData();
            }
        };
    }

    @Override
    protected int func_152379_p() {
        return -1;
    }

    @Override
    public Entity func_73045_a(int p_73045_1_) {
        return null;
    }
}

