/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import bartworks.system.material.Werkstoff;
import bartworks.system.oregen.BWOreLayer;
import com.sinthoras.visualprospecting.database.veintypes.BartworksOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.GregTechOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreMixes;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VeinTypeCaching {
    private static final Object2ObjectMap<String, VeinType> veinTypes = new Object2ObjectOpenHashMap();

    public static void init() {
        veinTypes.put((Object)"ore.mix.none", (Object)VeinType.NO_VEIN);
        for (OreMixes mix : OreMixes.values()) {
            veinTypes.put((Object)mix.oreMixBuilder.oreMixName, (Object)new VeinType(mix.oreMixBuilder));
        }
        for (BWOreLayer vein : BWOreLayer.sList) {
            IOreMaterialProvider oreMaterialProvider = VeinTypeCaching.containsBartworksOres(vein.bwOres) ? VeinTypeCaching.getRepresentativeProvider(vein.mWorldGenName, new int[]{vein.mPrimaryMeta, vein.mSecondaryMeta, vein.mBetweenMeta, vein.mSporadicMeta}) : new GregTechOreMaterialProvider(GregTechAPI.sGeneratedMaterials[(short)vein.mPrimaryMeta]);
            veinTypes.put((Object)vein.mWorldGenName, (Object)new VeinType(vein.mWorldGenName, oreMaterialProvider, vein.mSize, (short)vein.mPrimaryMeta, (short)vein.mSecondaryMeta, (short)vein.mBetweenMeta, (short)vein.mSporadicMeta, vein.mMinY, vein.mMaxY, vein.getDimName()));
        }
    }

    @NotNull
    public static VeinType getVeinType(String veinTypeName) {
        return (VeinType)veinTypes.getOrDefault((Object)veinTypeName, (Object)VeinType.NO_VEIN);
    }

    public static Collection<VeinType> getVeinTypes() {
        return veinTypes.values();
    }

    public static void recalculateSearch(@Nullable Pattern filterPattern) {
        for (VeinType veinType : veinTypes.values()) {
            if (veinType == VeinType.NO_VEIN) continue;
            if (filterPattern != null) {
                ArrayList<String> searchableStrings = new ArrayList<String>((Collection<String>)veinType.getOreMaterialNames());
                searchableStrings.add(veinType.getVeinName());
                boolean match = searchableStrings.stream().map(EnumChatFormatting::func_110646_a).map(String::toLowerCase).anyMatch(searchableString -> filterPattern.matcher((CharSequence)searchableString).find());
                veinType.setNEISearchHighlight(match);
                continue;
            }
            veinType.setNEISearchHighlight(true);
        }
    }

    private static boolean containsBartworksOres(byte bwOres) {
        return (bwOres & 0xF) != 0;
    }

    private static IOreMaterialProvider getRepresentativeProvider(String veinName, int[] ores) {
        for (int meta2 : ores) {
            String defaultName;
            Werkstoff werkstoff = (Werkstoff)Werkstoff.werkstoffHashMap.get((short)meta2);
            if (werkstoff == null || !StringUtils.endsWithIgnoreCase((CharSequence)veinName, (CharSequence)(defaultName = werkstoff.getDefaultName())) && !StringUtils.containsIgnoreCase((CharSequence)veinName, (CharSequence)defaultName.substring(0, defaultName.length() - 2))) continue;
            return new BartworksOreMaterialProvider(werkstoff);
        }
        Werkstoff primaryMaterial = Arrays.stream(ores).mapToObj(meta -> (Werkstoff)Werkstoff.werkstoffHashMap.get((short)meta)).filter(Objects::nonNull).findFirst().orElse(null);
        return primaryMaterial == null ? new GregTechOreMaterialProvider(Materials._NULL) : new BartworksOreMaterialProvider(primaryMaterial);
    }
}

