/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.coremod;

import com.dreammaster.coremod.IDreamTransformer;
import com.dreammaster.coremod.transformers.ItemFocusWardingTransformer;
import com.dreammaster.coremod.transformers.recipenukers.AdvancedSolarPanelTransformer;
import com.dreammaster.coremod.transformers.recipenukers.BibliocraftTransformer;
import com.dreammaster.coremod.transformers.recipenukers.GraviSuiteTransformer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class DreamClassTransformer
implements IClassTransformer {
    private final Map<String, IDreamTransformer> transformerMap = new HashMap<String, IDreamTransformer>();

    public DreamClassTransformer() {
        this.registerTransformer(new AdvancedSolarPanelTransformer());
        this.registerTransformer(new BibliocraftTransformer());
        this.registerTransformer(new GraviSuiteTransformer());
        this.registerTransformer(new ItemFocusWardingTransformer());
    }

    private void registerTransformer(IDreamTransformer transformer) {
        for (String targetedClass : transformer.targetedClasses()) {
            this.registerTransformer(targetedClass, transformer);
        }
    }

    private void registerTransformer(String targetedClass, IDreamTransformer transformer) {
        this.transformerMap.put(targetedClass, transformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName == null || transformedName.startsWith("com.dreammaster.coremod.")) {
            return basicClass;
        }
        IDreamTransformer transformer = this.transformerMap.get(transformedName);
        if (transformer == null) {
            return basicClass;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(0);
        transformer.transform(classNode);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

