/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.sodium.vertex_format.terrain_xhfp;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import net.coderbot.iris.sodium.block_context.BlockContextHolder;
import net.coderbot.iris.sodium.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.sodium.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.sodium.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void writeQuad(float x, float y, float z, int color, float u, float v, int light, int shaderBlockId) {
        this.uSum += u;
        this.vSum += v;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort(x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort(u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort(v), light, shaderBlockId != -1 ? (short)shaderBlockId : this.contextHolder.blockId, this.contextHolder.renderType, ExtendedDataHelper.computeMidBlock(x, y, z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType, int packedMidBlock) {
        long i = this.writePointer;
        ++this.vertexCount;
        MemoryUtilities.memPutShort((long)i, (short)x);
        MemoryUtilities.memPutShort((long)(i + 2L), (short)y);
        MemoryUtilities.memPutShort((long)(i + 4L), (short)z);
        MemoryUtilities.memPutInt((long)(i + 8L), (int)color);
        MemoryUtilities.memPutShort((long)(i + 12L), (short)u);
        MemoryUtilities.memPutShort((long)(i + 14L), (short)v);
        MemoryUtilities.memPutShort((long)(i + 16L), (short)((short)(light & 0xFFFF)));
        MemoryUtilities.memPutShort((long)(i + 18L), (short)((short)(light >> 16 & 0xFFFF)));
        MemoryUtilities.memPutShort((long)(i + 36L), (short)materialId);
        MemoryUtilities.memPutShort((long)(i + 38L), (short)renderType);
        MemoryUtilities.memPutInt((long)(i + 40L), (int)packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            MemoryUtilities.memPutFloat((long)(i + 20L), (float)this.uSum);
            MemoryUtilities.memPutFloat((long)(i + 20L - 44L), (float)this.uSum);
            MemoryUtilities.memPutFloat((long)(i + 20L - 88L), (float)this.uSum);
            MemoryUtilities.memPutFloat((long)(i + 20L - 132L), (float)this.uSum);
            MemoryUtilities.memPutFloat((long)(i + 24L), (float)this.vSum);
            MemoryUtilities.memPutFloat((long)(i + 24L - 44L), (float)this.vSum);
            MemoryUtilities.memPutFloat((long)(i + 24L - 88L), (float)this.vSum);
            MemoryUtilities.memPutFloat((long)(i + 24L - 132L), (float)this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(i, 44);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtilities.memPutInt((long)(i + 32L), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(i + 32L - 44L), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(i + 32L - 88L), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(i + 32L - 132L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtilities.memPutInt((long)(i + 28L), (int)tangent);
            MemoryUtilities.memPutInt((long)(i + 28L - 44L), (int)tangent);
            MemoryUtilities.memPutInt((long)(i + 28L - 88L), (int)tangent);
            MemoryUtilities.memPutInt((long)(i + 28L - 132L), (int)tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

