/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss;

import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.block.EntityBlockFallingObsidian;
import chylex.hee.entity.boss.dragon.attacks.passive.DragonAttackBite;
import chylex.hee.entity.boss.dragon.attacks.passive.DragonAttackFireball;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackBloodlust;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackDefault;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackDivebomb;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackFireburst;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackPunch;
import chylex.hee.entity.boss.dragon.attacks.special.DragonAttackSummoning;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.CollisionEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.DamageTakenEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.MotionUpdateEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.entity.boss.dragon.managers.DragonAchievementManager;
import chylex.hee.entity.boss.dragon.managers.DragonAttackManager;
import chylex.hee.entity.boss.dragon.managers.DragonChunkManager;
import chylex.hee.entity.boss.dragon.managers.DragonDebugManager;
import chylex.hee.entity.boss.dragon.managers.DragonRewardManager;
import chylex.hee.entity.boss.dragon.managers.DragonShotManager;
import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.entity.weather.EntityWeatherLightningBoltSafe;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C01ParticleEndPortalCreation;
import chylex.hee.packets.client.C06SetPlayerVelocity;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.commands.DebugBoard;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Log;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.util.Direction;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBossDragon
extends EntityLiving
implements IBossDisplayData,
IEntityMultiPart,
IMob,
GlobalMobData.IIgnoreEnderGoo {
    public static final byte ATTACK_FIREBALL = 0;
    public static final byte ATTACK_BITE = 1;
    public static long lastUpdate;
    private double[][] movementBuffer = new double[64][2];
    private int movementBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead;
    public EntityDragonPart dragonPartBody;
    public EntityDragonPart dragonPartTail1;
    public EntityDragonPart dragonPartTail2;
    public EntityDragonPart dragonPartTail3;
    public EntityDragonPart dragonPartWing1;
    public EntityDragonPart dragonPartWing2;
    public EntityEnderCrystal healingEnderCrystal;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    public boolean slowed;
    public int deathTicks;
    public EntityPlayer target;
    public double targetX;
    public double targetY;
    public double targetZ;
    public boolean angryStatus;
    public boolean forceAttackEnd;
    public boolean noViablePlayers;
    public boolean freezeAI;
    public boolean frozen;
    public int nextAttackTicks;
    public byte dragonHurtTime;
    public int spawnCooldown = 1200;
    public int lastAttackInterruption = -600;
    public byte loadTimer = (byte)10;
    public double moveSpeedMp = 1.0;
    public final DragonAttackManager attacks;
    public final DragonShotManager shots;
    public final DragonRewardManager rewards;
    public final DragonAchievementManager achievements;
    private final DragonSpecialAttackBase defaultAttack;
    private DragonSpecialAttackBase lastAttack;
    private DragonSpecialAttackBase currentAttack;

    public EntityBossDragon(World world) {
        super(world);
        this.dragonPartHead = new EntityDragonPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
        this.dragonPartBody = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 8.0f);
        this.dragonPartTail1 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail2 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail3 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartWing1 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartWing2 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 8.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.targetY = 100.0;
        this.field_70158_ak = true;
        this.field_70155_l = 5.0;
        this.attacks = new DragonAttackManager(this);
        this.shots = new DragonShotManager(this);
        this.rewards = new DragonRewardManager(this);
        this.achievements = new DragonAchievementManager(this);
        this.attacks.registerPassive(new DragonAttackFireball(this, 0));
        this.attacks.registerPassive(new DragonAttackBite(this, 1));
        this.defaultAttack = new DragonAttackDefault(this, 0);
        this.attacks.registerSpecial(this.defaultAttack);
        this.attacks.registerSpecial(new DragonAttackDivebomb(this, 1, 10).setDisabledPassiveAttacks(0));
        this.attacks.registerSpecial(new DragonAttackFireburst(this, 2, 10).setDisabledPassiveAttacks(0, 1));
        this.attacks.registerSpecial(new DragonAttackPunch(this, 3, 10).setDisabledPassiveAttacks(0));
        this.attacks.registerSpecial(new DragonAttackSummoning(this, 4, 7).setDisabledPassiveAttacks(0, 1));
        this.attacks.registerSpecial(new DragonAttackBloodlust(this, 5, 7).setDisabledPassiveAttacks(0, 1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0 + (double)Math.min(90, ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount() * 15) + (ModCommonProxy.opMobs ? 80.0 : 0.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(1.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_70636_d() {
        if (this.freezeAI) {
            if (this.field_70173_aa % 10 != 0 || this.attacks.getViablePlayers().isEmpty()) return;
            this.noViablePlayers = false;
            this.freezeAI = false;
        } else {
            if (this.noViablePlayers && this.field_70173_aa % 10 == 0 && !this.attacks.getViablePlayers().isEmpty()) {
                this.noViablePlayers = false;
            }
            if (this.field_70173_aa % 40 == 0 && this.attacks.getViablePlayers().isEmpty()) {
                this.noViablePlayers = true;
                if (this.field_70170_p.func_72890_a((Entity)this, 180.0) == null) {
                    this.freezeAI = true;
                    DragonChunkManager.release(this);
                    return;
                }
                this.freezeAI = false;
            }
        }
        if (this.currentAttack == null) {
            this.currentAttack = this.defaultAttack;
        }
        this.angryStatus = this.isAngry();
        if (!this.field_70170_p.field_72995_K) {
            DragonSavefile save;
            if (this.spawnCooldown > 0 && --this.spawnCooldown > 0 && this.field_70173_aa % 20 == 0) {
                for (EntityPlayer player : this.attacks.getViablePlayers()) {
                    if (BlockPosM.tmp((Entity)player).moveDown().getBlock((IBlockAccess)this.field_70170_p) != Blocks.field_150377_bs) continue;
                    this.spawnCooldown = 0;
                    break;
                }
            }
            if (this.loadTimer > 0 && (this.loadTimer = (byte)(this.loadTimer - 1)) == 1) {
                for (int chunkX = -6; chunkX <= 6; ++chunkX) {
                    for (int chunkZ = -6; chunkZ <= 6; ++chunkZ) {
                        this.field_70170_p.func_72964_e(chunkX, chunkZ);
                    }
                }
            }
            if (!(this.loadTimer != 0 || this.angryStatus || this.field_70173_aa % 10 != 0 || (save = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).countCrystals() > 2 + save.getDragonDeathAmount() && this.attacks.getHealthPercentage() > 80)) {
                this.setAngry(true);
                this.spawnCooldown = 0;
            }
            this.currentAttack.update();
            if (this.angryStatus) {
                DebugBoard.updateValue("AttackId", this.currentAttack.id);
                if (this.currentAttack.equals(this.defaultAttack)) {
                    if (this.nextAttackTicks-- <= 0 && this.target == null) {
                        this.lastAttack = this.currentAttack;
                        this.currentAttack = this.attacks.pickSpecialAttack(this.lastAttack);
                        if (this.currentAttack == null) {
                            this.currentAttack = this.defaultAttack;
                            this.nextAttackTicks = this.currentAttack.getNextAttackTimer();
                        }
                        this.currentAttack.init();
                    }
                } else if (this.currentAttack.hasEnded() || this.forceAttackEnd) {
                    this.forceAttackEnd = false;
                    this.currentAttack.end();
                    this.nextAttackTicks = MathUtil.ceil((double)this.currentAttack.getNextAttackTimer() * (0.5 + (double)this.attacks.getHealthPercentage() / 200.0));
                    this.currentAttack = this.defaultAttack;
                    this.currentAttack.init();
                }
            }
            if (this.func_110143_aJ() > 0.0f) {
                double spd;
                this.rewards.updateManager();
                this.achievements.updateManager();
                DragonChunkManager.ping(this);
                if (this.dragonHurtTime > 0) {
                    this.dragonHurtTime = (byte)(this.dragonHurtTime - 1);
                }
                if (this.moveSpeedMp > (spd = (double)this.currentAttack.overrideMovementSpeed())) {
                    this.moveSpeedMp = this.moveSpeedMp < 0.2 && spd == 0.0 ? 0.0 : Math.max(spd, this.moveSpeedMp - 0.0175);
                } else if (this.moveSpeedMp < spd) {
                    this.moveSpeedMp = Math.min(spd, this.moveSpeedMp + 0.0175);
                }
                float wng = this.frozen ? HeeDebugCommand.overrideWingSpeed : this.currentAttack.overrideWingSpeed();
                float curWng = this.getWingSpeed();
                if (curWng > wng) {
                    curWng = Math.max(wng, curWng - 0.015f);
                } else if (curWng < wng) {
                    curWng = Math.min(wng, curWng + 0.015f);
                }
                if (curWng != this.getWingSpeed()) {
                    this.setWingSpeed(curWng);
                }
                if (this.field_70173_aa % 2 == 0) {
                    int perc = this.attacks.getHealthPercentage();
                    if (perc < 40 && this.field_70146_Z.nextInt(500 - (50 - perc) * 8) == 0) {
                        int x = (int)this.field_70165_t + this.field_70146_Z.nextInt(301) - 150;
                        int z = (int)this.field_70161_v + this.field_70146_Z.nextInt(301) - 150;
                        int y = 1 + DragonUtil.getTopBlockY(this.field_70170_p, Blocks.field_150377_bs, x, z);
                        EntityMobAngryEnderman buddy = new EntityMobAngryEnderman(this.field_70170_p);
                        buddy.func_70107_b(x, y, z);
                        this.field_70170_p.func_72942_c((Entity)new EntityWeatherLightningBoltSafe(this.field_70170_p, x, y, z));
                        this.field_70170_p.func_72838_d((Entity)buddy);
                    }
                    lastUpdate = this.field_70170_p.func_82737_E();
                }
            }
            if (Log.isDebugEnabled()) {
                DragonDebugManager.updateBoard(this);
            }
        }
        if (this.field_70170_p.field_72995_K && MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f)) <= -0.3f && MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f)) >= -0.3f) {
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.enderdragon.wings", 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 8.0f), this.field_70163_u + 2.0 + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 4.0f), this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 8.0f), 0.0, 0.0, 0.0);
            return;
        } else {
            this.updateEnderCrystal();
            float animAdvance = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            animAdvance *= (float)Math.pow(2.0, this.field_70181_x);
            this.animTime += this.slowed ? animAdvance * 0.5f : (animAdvance *= this.getWingSpeed());
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.movementBufferIndex < 0) {
                for (int index = 0; index < this.movementBuffer.length; ++index) {
                    this.movementBuffer[index][0] = this.field_70177_z;
                    this.movementBuffer[index][1] = this.field_70163_u;
                }
            }
            if (++this.movementBufferIndex == this.movementBuffer.length) {
                this.movementBufferIndex = 0;
            }
            this.movementBuffer[this.movementBufferIndex][0] = this.field_70177_z;
            this.movementBuffer[this.movementBufferIndex][1] = this.field_70163_u;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70716_bi > 0) {
                    double finalPosX = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
                    double finalPosY = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
                    double finalPosZ = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
                    this.field_70177_z = (float)((double)this.field_70177_z + MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z)) / (double)this.field_70716_bi);
                    this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
                    --this.field_70716_bi;
                    this.func_70107_b(finalPosX, finalPosY, finalPosZ);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else {
                double xDiff = this.targetX - this.field_70165_t;
                double yDiff = this.targetY - this.field_70163_u;
                double zDiff = this.targetZ - this.field_70161_v;
                double distFromTargetSq = xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
                if (this.noViablePlayers) {
                    this.forceAttackEnd = true;
                    this.trySetTarget(null);
                    this.trySetTargetPosition(this.field_70146_Z.nextDouble() * 60.0 - 30.0, this.targetY, this.field_70146_Z.nextDouble() * 60.0 - 30.0);
                }
                if (this.target != null) {
                    this.targetX = this.target.field_70165_t;
                    this.targetZ = this.target.field_70161_v;
                    this.targetY = this.target.field_70121_D.field_72338_b + Math.min(0.4 + Math.sqrt(Math.pow(this.targetX - this.field_70165_t, 2.0) + Math.pow(this.targetZ - this.field_70161_v, 2.0)) / 80.0 - 1.0, 10.0);
                } else {
                    this.trySetTargetPosition(this.targetX + this.field_70146_Z.nextGaussian() * 2.0, this.targetY, this.targetZ + this.field_70146_Z.nextGaussian() * 2.0);
                }
                if (this.target != null && this.target.field_70128_L || distFromTargetSq > 22500.0) {
                    this.forceNewTarget = true;
                    this.forceAttackEnd = true;
                }
                if (this.forceNewTarget || distFromTargetSq < 90.0 || distFromTargetSq > 22500.0 || this.field_70123_F || this.field_70124_G) {
                    this.setNewTarget();
                }
                yDiff = MathUtil.clamp(yDiff / MathUtil.distance(xDiff, zDiff), (double)-0.6f, (double)0.6f);
                this.field_70181_x += yDiff * 0.1;
                this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                double d9 = MathUtil.clamp(MathHelper.func_76138_g((double)(180.0 - MathUtil.toDeg(Math.atan2(xDiff, zDiff)) - (double)this.field_70177_z)), -50.0, 50.0);
                Vec3 targetDiffVec = Vec3.func_72443_a((double)(this.targetX - this.field_70165_t), (double)(this.targetY - this.field_70163_u), (double)(this.targetZ - this.field_70161_v)).func_72432_b();
                Vec3 rotationVec = Vec3.func_72443_a((double)MathHelper.func_76126_a((float)MathUtil.toRad(this.field_70177_z)), (double)this.field_70181_x, (double)(-MathHelper.func_76134_b((float)MathUtil.toRad(this.field_70177_z)))).func_72432_b();
                float f4 = Math.max((float)(rotationVec.func_72430_b(targetDiffVec) + 0.5) / 1.5f, 0.0f);
                this.field_70704_bt *= 0.8f;
                float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) + 1.0f;
                double speedLimited = Math.min(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) + 1.0, 40.0);
                this.field_70704_bt = (float)((double)this.field_70704_bt + d9 * (0.7 / speedLimited / (double)speed));
                this.field_70177_z += this.field_70704_bt * 0.1f;
                float f6 = (float)(2.0 / (speedLimited + 1.0));
                this.func_70060_a(0.0f, -1.0f, 0.06f * (f4 * f6 + (1.0f - f6)));
                if (this.frozen) {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                }
                MotionUpdateEvent event = new MotionUpdateEvent(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.currentAttack.onMotionUpdateEvent(event);
                this.field_70159_w = event.motionX;
                this.field_70181_x = event.motionY;
                this.field_70179_y = event.motionZ;
                if (this.slowed) {
                    this.func_70091_d(this.field_70159_w * this.moveSpeedMp * 0.8, this.field_70181_x * this.moveSpeedMp * 0.8, this.field_70179_y * this.moveSpeedMp * 0.8);
                } else {
                    this.func_70091_d(this.field_70159_w * this.moveSpeedMp, this.field_70181_x * this.moveSpeedMp, this.field_70179_y * this.moveSpeedMp);
                }
                double motionMultiplier = 0.8 + 0.15 * ((Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b().func_72430_b(rotationVec) + 1.0) * 0.5);
                this.field_70159_w *= motionMultiplier;
                this.field_70179_y *= motionMultiplier;
                this.field_70181_x *= 0.91;
            }
            this.field_70761_aq = this.field_70177_z;
            this.dragonPartHead.field_70131_O = 3.0f;
            this.dragonPartHead.field_70130_N = 3.0f;
            this.dragonPartTail1.field_70131_O = 2.0f;
            this.dragonPartTail1.field_70130_N = 2.0f;
            this.dragonPartTail2.field_70131_O = 2.0f;
            this.dragonPartTail2.field_70130_N = 2.0f;
            this.dragonPartTail3.field_70131_O = 2.0f;
            this.dragonPartTail3.field_70130_N = 2.0f;
            this.dragonPartBody.field_70130_N = 5.0f;
            this.dragonPartBody.field_70131_O = 3.0f;
            this.dragonPartWing1.field_70130_N = 4.0f;
            this.dragonPartWing1.field_70131_O = 2.0f;
            this.dragonPartWing2.field_70130_N = 4.0f;
            this.dragonPartWing2.field_70131_O = 3.0f;
            float offsetAngle = MathUtil.toRad((float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f);
            float angleCos = MathHelper.func_76134_b((float)offsetAngle);
            float angleSin = -MathHelper.func_76126_a((float)offsetAngle);
            float yawRad = MathUtil.toRad(this.field_70177_z);
            float yawSin = MathHelper.func_76126_a((float)yawRad);
            float yawCos = MathHelper.func_76134_b((float)yawRad);
            this.dragonPartBody.func_70071_h_();
            this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(yawSin * 0.5f), this.field_70163_u, this.field_70161_v - (double)(yawCos * 0.5f), 0.0f, 0.0f);
            this.dragonPartWing1.func_70071_h_();
            this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(yawCos * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(yawSin * 4.5f), 0.0f, 0.0f);
            this.dragonPartWing2.func_70071_h_();
            this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(yawCos * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(yawSin * 4.5f), 0.0f, 0.0f);
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.field_70121_D.func_72314_b(1.5, 2.0, 1.5).func_72317_d(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.field_70121_D.func_72314_b(1.5, 2.0, 1.5).func_72317_d(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail3.field_70121_D.func_72314_b(0.8, 1.0, 0.8)));
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.field_70121_D.func_72314_b(0.6, 1.0, 0.6)));
            double[] oldOffsets = this.getMovementOffsets(5, 1.0f);
            double[] currentOffsets = this.getMovementOffsets(0, 1.0f);
            float moveX = MathHelper.func_76126_a((float)(MathUtil.toRad(this.field_70177_z) - this.field_70704_bt * 0.01f));
            float moveZ = MathHelper.func_76134_b((float)(MathUtil.toRad(this.field_70177_z) - this.field_70704_bt * 0.01f));
            this.dragonPartHead.func_70071_h_();
            this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(moveX * 5.5f * angleCos), this.field_70163_u + currentOffsets[1] - oldOffsets[1] + (double)(angleSin * 5.5f), this.field_70161_v - (double)(moveZ * 5.5f * angleCos), 0.0f, 0.0f);
            for (int part = 0; part < 3; ++part) {
                EntityDragonPart tailPart = part == 0 ? this.dragonPartTail1 : (part == 1 ? this.dragonPartTail2 : this.dragonPartTail3);
                double[] partOffsets = this.getMovementOffsets(12 + part * 2, 1.0f);
                float partYaw = MathUtil.toRad(this.field_70177_z) + MathUtil.toRad((float)MathHelper.func_76138_g((double)(partOffsets[0] - oldOffsets[0])));
                float partYawSin = MathHelper.func_76126_a((float)partYaw);
                float partYawCos = MathHelper.func_76134_b((float)partYaw);
                float partMp = (float)(part + 1) * 2.0f;
                tailPart.func_70071_h_();
                tailPart.func_70012_b(this.field_70165_t - (double)((yawSin * 1.5f + partYawSin * partMp) * angleCos), this.field_70163_u + (partOffsets[1] - oldOffsets[1]) - (double)((partMp + 1.5f) * angleSin) + 1.5, this.field_70161_v + (double)((yawCos * 1.5f + partYawCos * partMp) * angleCos), 0.0f, 0.0f);
            }
            if (this.field_70170_p.field_72995_K) return;
            this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.field_70121_D) | this.destroyBlocksInAABB(this.dragonPartBody.field_70121_D);
            if (this.currentAttack.id == 1) {
                this.slowed |= this.destroyBlocksInAABB(this.dragonPartWing1.field_70121_D.func_72314_b(0.5, 0.5, 0.5)) | this.destroyBlocksInAABB(this.dragonPartWing2.field_70121_D.func_72314_b(0.5, 0.5, 0.5));
            }
            this.attacks.updatePassiveAttacks(this.currentAttack);
        }
    }

    public boolean func_70965_a(EntityDragonPart dragonPart, DamageSource source, float amount) {
        boolean shouldChangeTarget;
        if (source.func_94541_c() && source.func_76346_g() == this || this.dragonHurtTime > 0 || this.freezeAI) {
            return false;
        }
        if (this.noViablePlayers && source.func_76346_g() instanceof EntityPlayer && !this.attacks.isPlayerViable((EntityPlayer)source.func_76346_g())) {
            amount *= 0.1f;
        }
        this.spawnCooldown = 0;
        if (dragonPart != this.dragonPartHead) {
            amount = amount / 3.0f + 1.0f;
        }
        amount = Math.min(amount, ModCommonProxy.opMobs ? 14.0f : 18.0f);
        int players = this.attacks.getViablePlayers().size();
        if (players > 1) {
            amount *= 1.0f - Math.max(0.5f, (float)(players - 1) * 0.05f);
        }
        DamageTakenEvent event = new DamageTakenEvent(source, amount);
        this.currentAttack.onDamageTakenEvent(event);
        this.currentAttack.onDamageTaken(event.damage);
        amount = event.damage;
        boolean bl = shouldChangeTarget = this.target != null && this.func_70068_e((Entity)this.target) < 4600.0 && (!this.angryStatus || this.field_70146_Z.nextInt(3) != 0);
        if (shouldChangeTarget && this.field_70173_aa - this.lastAttackInterruption >= 500) {
            this.trySetTarget(null);
            this.lastAttackInterruption = this.field_70173_aa;
            float yawRad = MathUtil.toRad(this.field_70177_z);
            this.trySetTargetPosition(this.field_70165_t + (double)(MathHelper.func_76126_a((float)yawRad) * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.0f) + 1.0, this.field_70161_v - (double)(MathHelper.func_76134_b((float)yawRad) * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f));
        }
        if ((source.func_76346_g() instanceof EntityPlayer || source.func_94541_c()) && super.func_70097_a(source, amount)) {
            this.field_70737_aN = 15;
            this.dragonHurtTime = (byte)15;
            this.field_70172_ad = this.dragonHurtTime + 10;
        }
        CausatumUtils.increase(source, CausatumMeters.DRAGON_DAMAGE, amount * 16.0f);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks == 1) {
                PacketPipeline.sendToDimension(this.field_71093_bK, new C01ParticleEndPortalCreation(MathUtil.floor(this.field_70165_t), MathUtil.floor(this.field_70161_v)));
                this.achievements.onBattleFinished();
                ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).setDragonDead(true);
                this.field_70170_p.func_82739_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            } else if (this.deathTicks == 20 || this.deathTicks == 140) {
                for (Entity entity : this.field_70170_p.field_72996_f) {
                    if (MathUtil.distance(entity.field_70165_t, entity.field_70161_v) > 180.0) continue;
                    if (entity instanceof EntityEnderman) {
                        ((EntityEnderman)entity).func_70784_b(null);
                        continue;
                    }
                    if (!(entity instanceof EntityMobAngryEnderman)) continue;
                    ((EntityMobAngryEnderman)entity).func_70606_j(0.0f);
                }
            } else if (this.deathTicks > 4 && this.deathTicks < 70 && this.deathTicks % 4 == 0) {
                BlockPosM tmpPos = BlockPosM.tmp();
                for (int a = 0; a < 250; ++a) {
                    tmpPos.set(this.field_70165_t + (double)this.field_70146_Z.nextInt(51) - 25.0, -1.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(51) - 25.0);
                    tmpPos.setY(1 + DragonUtil.getTopBlockY(this.field_70170_p, Blocks.field_150377_bs, tmpPos.x, tmpPos.z, 65));
                    if (tmpPos.y <= 40 || tmpPos.getBlock((IBlockAccess)this.field_70170_p) != Blocks.field_150480_ab) continue;
                    tmpPos.setAir(this.field_70170_p);
                }
            } else if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                DragonUtil.spawnXP((Entity)this, 550 + 250 * (this.rewards.getFinalDifficulty() >> 2));
            } else if (this.deathTicks == 191) {
                for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                    player.func_71064_a((StatBase)AchievementManager.GO_INTO_THE_END, 1);
                }
            } else if (this.deathTicks == 200) {
                DragonUtil.spawnXP((Entity)this, 4000);
            }
            if (this.deathTicks > 40 && this.deathTicks < 140) {
                this.rewards.spawnEssence(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
            }
        } else if (this.deathTicks > 20 && this.field_70170_p.field_72995_K) {
            int amount = 1 + this.deathTicks / 40;
            int xx = DragonUtil.portalEffectX;
            int zz = DragonUtil.portalEffectZ;
            int bottomY = 64;
            int portalSize = 4;
            for (int iy = bottomY - 1; iy <= bottomY + 32; ++iy) {
                for (int ix = xx - portalSize; ix <= xx + portalSize; ++ix) {
                    for (int iz = zz - portalSize; iz <= zz + portalSize; ++iz) {
                        double distSq = MathUtil.square(ix - xx) + MathUtil.square(iz - zz);
                        if (!(distSq <= ((double)portalSize - 0.5) * ((double)portalSize - 0.5)) || iy < bottomY && distSq <= ((double)(portalSize - 1) - 0.5) * ((double)(portalSize - 1) - 0.5) || iy > bottomY) continue;
                        for (int a = 0; a < this.field_70146_Z.nextInt(amount); ++a) {
                            this.field_70170_p.func_72869_a("portal", (double)ix + this.field_70146_Z.nextDouble(), (double)iy + this.field_70146_Z.nextDouble() - 0.5, (double)iz + this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            for (int minX = 2; minX < 5; ++minX) {
                for (int a = 0; a < this.field_70146_Z.nextInt(amount); ++a) {
                    this.field_70170_p.func_72869_a("portal", (double)xx + this.field_70146_Z.nextDouble(), (double)(bottomY + a) + this.field_70146_Z.nextDouble() - 0.5, (double)zz + this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 8.0f), this.field_70163_u + 2.0 + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 4.0f), this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 8.0f), 0.0, 0.0, 0.0);
        }
        this.func_70091_d(0.0, 0.1, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            DragonUtil.spawnXP((Entity)this, 2000);
            this.createEnderPortal(MathUtil.floor(this.field_70165_t), MathUtil.floor(this.field_70161_v));
            DragonChunkManager.release(this);
            this.func_70106_y();
        }
    }

    private void createEnderPortal(int x, int z) {
        int yy;
        BlockEndPortal.field_149948_a = true;
        int portalSize = 4;
        int bottomY = 64;
        BlockPosM tmpPos = BlockPosM.tmp();
        for (yy = bottomY - 1; yy <= bottomY + 32; ++yy) {
            for (int xx = x - portalSize; xx <= x + portalSize; ++xx) {
                for (int zz = z - portalSize; zz <= z + portalSize; ++zz) {
                    double distSq = MathUtil.square(xx - x) + MathUtil.square(zz - z);
                    if (!(distSq <= ((double)portalSize - 0.5) * ((double)portalSize - 0.5))) continue;
                    tmpPos.set(xx, yy, zz);
                    if (yy < bottomY) {
                        if (!(distSq <= MathUtil.square((double)(portalSize - 1) - 0.5))) continue;
                        tmpPos.setBlock(this.field_70170_p, Blocks.field_150357_h);
                        continue;
                    }
                    if (yy > bottomY) {
                        tmpPos.setAir(this.field_70170_p);
                        continue;
                    }
                    if (distSq > MathUtil.square((double)(portalSize - 1) - 0.5)) {
                        tmpPos.setBlock(this.field_70170_p, Blocks.field_150357_h);
                        continue;
                    }
                    tmpPos.setBlock(this.field_70170_p, Blocks.field_150384_bq);
                }
            }
        }
        for (yy = bottomY; yy <= bottomY + 3; ++yy) {
            tmpPos.set(x, yy, z).setBlock(this.field_70170_p, Blocks.field_150357_h);
        }
        for (int dir = 0; dir < 4; ++dir) {
            tmpPos.set(x + Direction.offsetX[dir], bottomY + 2, z + Direction.offsetZ[dir]).setBlock(this.field_70170_p, Blocks.field_150478_aa);
        }
        tmpPos.set(x, bottomY + 4, z).setBlock(this.field_70170_p, Blocks.field_150380_bt);
        BlockEndPortal.field_149948_a = false;
        ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getPortalEggLocation().set(x, bottomY + 4, z);
    }

    public double[] getMovementOffsets(int offset, float partialTickTime) {
        partialTickTime = this.func_110143_aJ() <= 0.0f ? 0.0f : 1.0f - partialTickTime;
        int index = this.movementBufferIndex - offset & 0x3F;
        int prevIndex = this.movementBufferIndex - offset - 1 & 0x3F;
        return new double[]{this.movementBuffer[index][0] + MathHelper.func_76138_g((double)(this.movementBuffer[prevIndex][0] - this.movementBuffer[index][0])) * (double)partialTickTime, this.movementBuffer[index][1] + (this.movementBuffer[prevIndex][1] - this.movementBuffer[index][1]) * (double)partialTickTime};
    }

    private void updateEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70965_a(this.dragonPartHead, DamageSource.func_94539_a(null), 10.0f);
                    if (this.target == null) {
                        this.trySetTarget(this.attacks.getRandomPlayer());
                    }
                }
                this.healingEnderCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + (ModCommonProxy.opMobs ? 2.0f : 1.0f));
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float dist = 30.0f + 4.0f * (float)this.field_70170_p.field_73013_u.func_151525_a() + (ModCommonProxy.opMobs ? 8.0f : 0.0f);
            this.healingEnderCrystal = (EntityEnderCrystal)DragonUtil.getClosestEntity((Entity)this, this.field_70170_p.func_72872_a(EntityEnderCrystal.class, this.field_70121_D.func_72314_b((double)dist, (double)dist, (double)dist)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collideWithEntities(List<? extends Entity> list) {
        double bodyCenterX = (this.dragonPartBody.field_70121_D.field_72340_a + this.dragonPartBody.field_70121_D.field_72336_d) * 0.5;
        double bodyCenterZ = (this.dragonPartBody.field_70121_D.field_72339_c + this.dragonPartBody.field_70121_D.field_72334_f) * 0.5;
        for (Entity entity : list) {
            void var7_5;
            if (!(entity instanceof EntityLivingBase) && !(entity instanceof EntityBlockFallingObsidian)) continue;
            while (var7_5.field_70154_o != null) {
                Entity entity2 = var7_5.field_70154_o;
            }
            double[] vec = DragonUtil.getNormalizedVector(var7_5.field_70165_t - bodyCenterX, var7_5.field_70161_v - bodyCenterZ);
            CollisionEvent event = new CollisionEvent((Entity)var7_5, vec[0] * 2.0, 0.2, vec[1] * 2.0);
            this.currentAttack.onCollisionEvent(event);
            event.collidedEntity.field_70159_w = event.velocityX;
            event.collidedEntity.field_70181_x = event.velocityY;
            event.collidedEntity.field_70179_y = event.velocityZ;
            if (!(var7_5 instanceof EntityPlayerMP)) continue;
            PacketPipeline.sendToPlayer((EntityPlayer)((EntityPlayerMP)var7_5), new C06SetPlayerVelocity(event.velocityX, event.velocityY, event.velocityZ));
        }
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB aabb) {
        if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            return false;
        }
        boolean wasBlocked = false;
        boolean spawnParticles = false;
        int minX = MathUtil.floor(aabb.field_72340_a + 0.5 - this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        int minY = MathUtil.floor(aabb.field_72338_b + 0.5 - this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        int minZ = MathUtil.floor(aabb.field_72339_c + 0.5 - this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        int maxX = MathUtil.floor(aabb.field_72336_d - 0.5 + this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        int maxY = MathUtil.floor(aabb.field_72337_e - 0.5 + this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        int maxZ = MathUtil.floor(aabb.field_72334_f - 0.5 + this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 5.0);
        double rad = 2.8 + Math.min((aabb.field_72336_d - aabb.field_72340_a) * 0.5, (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
        int cx = (int)((aabb.field_72336_d - aabb.field_72340_a) * 0.5 + aabb.field_72340_a);
        int cy = (int)((aabb.field_72337_e - aabb.field_72338_b) * 0.5 + aabb.field_72338_b);
        int cz = (int)((aabb.field_72334_f - aabb.field_72339_c) * 0.5 + aabb.field_72339_c);
        BlockPosM tmpPos = BlockPosM.tmp();
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int yy = minY; yy <= maxY; ++yy) {
                for (int zz = minZ; zz <= maxZ; ++zz) {
                    Block block = tmpPos.set(xx, yy, zz).getBlock((IBlockAccess)this.field_70170_p);
                    if (this.angryStatus && block == BlockList.obsidian_falling) {
                        tmpPos.setAir(this.field_70170_p);
                        EntityBlockFallingObsidian obsidian = new EntityBlockFallingObsidian(this.field_70170_p, xx, yy, zz);
                        obsidian.field_70181_x = -0.2;
                        this.field_70170_p.func_72838_d((Entity)obsidian);
                        spawnParticles = true;
                        continue;
                    }
                    if (block == Blocks.field_150357_h || !this.angryStatus && (block == Blocks.field_150343_Z || block == BlockList.obsidian_falling || block == Blocks.field_150411_aY && tmpPos.moveDown().getBlock((IBlockAccess)this.field_70170_p) == BlockList.obsidian_falling)) {
                        wasBlocked = true;
                        continue;
                    }
                    if (!block.canEntityDestroy((IBlockAccess)this.field_70170_p, xx, yy, zz, (Entity)this) || !(MathUtil.distance(xx - cx, yy - cy, zz - cz) <= rad + (0.9 * this.field_70146_Z.nextDouble() - 0.4))) continue;
                    spawnParticles = tmpPos.set(xx, yy, zz).setAir(this.field_70170_p) || spawnParticles;
                }
            }
        }
        if (spawnParticles) {
            this.field_70170_p.func_72869_a("largeexplode", aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * (double)this.field_70146_Z.nextFloat(), aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * (double)this.field_70146_Z.nextFloat(), aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        }
        return wasBlocked;
    }

    private void setNewTarget() {
        double newTargetZ;
        double newTargetY;
        double newTargetX;
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextBoolean() && this.trySetTarget(this.attacks.getWeakPlayer())) {
            return;
        }
        do {
            newTargetX = this.field_70146_Z.nextFloat() * 120.0f - 60.0f;
            newTargetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
            newTargetZ = this.field_70146_Z.nextFloat() * 120.0f - 60.0f;
        } while (!(MathUtil.square(this.field_70165_t - newTargetX) + MathUtil.square(this.field_70163_u - newTargetY) + MathUtil.square(this.field_70161_v - newTargetZ) > 100.0));
        this.trySetTargetPosition(newTargetX, newTargetY, newTargetZ);
    }

    public boolean trySetTarget(EntityPlayer entity) {
        if (entity != null && (entity.field_70128_L || !this.attacks.isPlayerViable(entity) || this.spawnCooldown > 0)) {
            return false;
        }
        this.forceNewTarget = false;
        TargetSetEvent event = new TargetSetEvent(this.target, entity);
        this.currentAttack.onTargetSetEvent(event);
        this.target = event.newTarget;
        return this.target != null;
    }

    public void trySetTargetPosition(double newTargetX, double newTargetY, double newTargetZ) {
        TargetPositionSetEvent event = new TargetPositionSetEvent(this.target, this.targetX, this.targetY, this.targetZ, newTargetX, newTargetY, newTargetZ);
        this.currentAttack.onTargetPositionSetEvent(event);
        if (event.isCancelled() && event.currentEntityTarget != null) {
            this.target = event.currentEntityTarget;
        } else {
            this.targetX = event.newTargetX;
            this.targetY = event.newTargetY;
            this.targetZ = event.newTargetZ;
            this.target = null;
        }
    }

    public void forceSpecialAttack(DragonSpecialAttackBase newAttack) {
        this.lastAttack = this.currentAttack;
        if (this.currentAttack != null) {
            this.currentAttack.end();
            this.nextAttackTicks = this.currentAttack.getNextAttackTimer();
        }
        this.currentAttack = newAttack;
        this.currentAttack.init();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("angry", this.isAngry());
        nbt.func_74777_a("nat", (short)Math.max(120, this.nextAttackTicks));
        nbt.func_74777_a("dth", (short)this.deathTicks);
        nbt.func_74777_a("scd", (short)Math.max(200, this.spawnCooldown));
        nbt.func_74774_a("load", this.loadTimer);
        nbt.func_74782_a("atk", (NBTBase)this.attacks.writeToNBT());
        nbt.func_74782_a("rwr", (NBTBase)this.rewards.writeToNBT());
        nbt.func_74782_a("acv", (NBTBase)this.achievements.writeToNBT());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setAngry(nbt.func_74767_n("angry"));
        this.nextAttackTicks = nbt.func_74765_d("nat");
        this.deathTicks = nbt.func_74765_d("dth");
        this.spawnCooldown = nbt.func_74765_d("scd");
        this.loadTimer = nbt.func_74764_b("load") ? nbt.func_74771_c("load") : this.loadTimer;
        this.attacks.readFromNBT(nbt.func_74775_l("atk"));
        this.rewards.readFromNBT(nbt.func_74775_l("rwr"));
        this.achievements.readFromNBT(nbt.func_74775_l("acv"));
    }

    public void setAngry(boolean angry) {
        this.field_70180_af.func_75692_b(17, (Object)(angry ? (byte)1 : 0));
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(17) & 1) != 0;
    }

    public void setWingSpeed(float wingSpeed) {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(wingSpeed));
    }

    public float getWingSpeed() {
        return this.field_70180_af.func_111145_d(18);
    }

    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return false;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public String func_70005_c_() {
        return this.func_94056_bM() ? this.func_94057_bL() : StatCollector.func_74838_a((String)Baconizer.mobName("entity.dragon.name"));
    }

    protected String func_70639_aQ() {
        return "mob.enderdragon.growl";
    }

    protected String func_70621_aR() {
        return Baconizer.soundNormal("mob.enderdragon.hit");
    }

    protected float func_70599_aP() {
        return this.angryStatus ? 6.5f : 5.0f;
    }
}

