/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import net.fuzzycraft.botanichorizons.addons.tileentity.SimpleAutomationTileEntity;
import net.fuzzycraft.botanichorizons.util.Facing2D;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.RecipeManaInfusion;

public abstract class TileAdvancedManaPool
extends SimpleAutomationTileEntity<RecipeManaInfusion> {
    public final int MANA_CAPACITY = 50000;
    public final int CYCLE_TICKS = 20;
    public final int MAX_PARALLELS = 64;
    public final int ACTIVATE_MANA = 1000;
    protected int cycleRemaining = 0;

    public TileAdvancedManaPool(MultiblockHelper structure) {
        super(structure);
    }

    @Override
    protected void updateEntityCrafting() {
        if (!this.isOnline) {
            return;
        }
        if (this.cycleRemaining > 0) {
            --this.cycleRemaining;
        } else if (this.partialStructureValidation()) {
            this.cycleRemaining = 20;
            this.handleCrafts();
            this.handleOutputs();
            this.cleanupInventory(0, 2);
            this.cleanupInventory(2, 4);
            this.func_70296_d();
        } else {
            this.isOnline = false;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
        }
    }

    @Override
    public int getAvailableParallels(@NotNull RecipeManaInfusion recipe) {
        int parallel = 64;
        int recipeManaCost = recipe.getManaToConsume();
        if (recipeManaCost > 0) {
            int manaParallel = this.storedMana / recipeManaCost;
            parallel = Math.min(parallel, manaParallel);
        }
        return parallel;
    }

    @Override
    public int getRecipeInputStackSize(@NotNull RecipeManaInfusion recipe) {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getRecipeOutput(@NotNull RecipeManaInfusion recipe) {
        return recipe.getOutput();
    }

    @Override
    public int getManaMaximum() {
        return 50000;
    }

    public boolean onWanded(EntityPlayer wandUser) {
        this.facing = Facing2D.fromIndex(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >> 1 & 3);
        if (!this.isOnline) {
            Exception error = this.structure.checkEntireStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing);
            if (error != null) {
                boolean handled = MultiblockHelper.handleFailedStructure(this.field_145850_b, wandUser, error);
                return false;
            }
            if (this.storedMana <= 1000) {
                return false;
            }
            this.storedMana -= 1000;
            this.cycleRemaining = 20;
            this.isOnline = true;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1 + this.facing.index * 2, 3);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

