/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import ic2.api.tile.IWrenchable;
import java.util.List;
import net.fuzzycraft.botanichorizons.util.Facing2D;
import net.fuzzycraft.botanichorizons.util.SparkHelper;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

public abstract class AutomationTileEntity
extends TileEntity
implements IManaReceiver,
ISparkAttachable,
IWrenchable {
    final MultiblockHelper structure;
    protected int storedMana = 0;
    protected Facing2D facing = Facing2D.NORTH;
    protected boolean isOnline = false;
    protected int sparkCycleRemaining = 0;
    protected boolean clientSparkTransfer = false;
    protected int structureCycle = 0;
    protected int cachedMana = Integer.MIN_VALUE;
    protected int statusCycle = 0;
    public final int SPARK_CYCLE_TICKS = 100;
    public final int SPARK_BUFFER_MANA = 2000;
    public final int STATUS_CYCLE = 100;
    public final int DEFAULT_MANA_ERROR_RANGE = 500;
    public static final String KEY_MANA = "mana";
    public static final String KEY_ONLINE = "enabled";
    public static final String KEY_SPARK_TRANSFER = "st";
    public static final String KEY_FACING = "face";

    public abstract int getManaMaximum();

    protected abstract void updateEntityCrafting();

    public AutomationTileEntity(MultiblockHelper structure) {
        this.structure = structure;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.clientSparkTransfer) {
                SparkHelper.requestSparkTransfers(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getAttachedSpark());
                this.clientSparkTransfer = false;
            }
        } else {
            this.updateEntityCrafting();
            this.updateEntitySparks();
            this.shareTEIfNeeded();
        }
    }

    protected void updateEntitySparks() {
        if (this.sparkCycleRemaining > 0) {
            --this.sparkCycleRemaining;
        } else {
            this.sparkCycleRemaining = 100;
            if (this.areIncomingTranfersDone()) {
                return;
            }
            if (this.storedMana < this.getManaMaximum() + 2000) {
                SparkHelper.requestSparkTransfers(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getAttachedSpark());
                this.func_70296_d();
            }
        }
    }

    protected boolean partialStructureValidation() {
        ++this.structureCycle;
        if (this.structureCycle >= this.structure.blocks.length) {
            this.structureCycle = 0;
        }
        return this.structure.checkStructurePart(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, this.structureCycle);
    }

    protected void shareTEIfNeeded() {
        ++this.statusCycle;
        if (this.statusCycle > 100) {
            if (this.shouldShareTE()) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
                this.cachedMana = this.storedMana;
            }
            this.statusCycle = 0;
        }
    }

    protected boolean shouldShareTE() {
        int delta = this.cachedMana - this.storedMana;
        return delta <= -500 || delta >= 500;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74757_a(KEY_ONLINE, this.isOnline);
        compound.func_74768_a(KEY_MANA, this.storedMana);
        compound.func_74774_a(KEY_FACING, (byte)this.facing.index);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        this.isOnline = compound.func_74767_n(KEY_ONLINE);
        this.storedMana = compound.func_74762_e(KEY_MANA);
        this.clientSparkTransfer = compound.func_74767_n(KEY_SPARK_TRANSFER);
        this.facing = Facing2D.fromIndex(compound.func_74771_c(KEY_FACING));
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeCustomNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public void attachSpark(ISparkEntity entity) {
        this.sparkCycleRemaining = 0;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_72872_a(ISparkEntity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.getManaMaximum() - this.storedMana);
    }

    public boolean areIncomingTranfersDone() {
        return this.storedMana >= this.getManaMaximum();
    }

    public boolean isFull() {
        return this.storedMana >= this.getManaMaximum();
    }

    public void recieveMana(int i) {
        this.storedMana += i;
        this.func_70296_d();
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.storedMana;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int facingIndex) {
        return Facing2D.fromIC2(facingIndex) != null;
    }

    public short getFacing() {
        return (short)this.facing.ic2index;
    }

    public void setFacing(short facingIndex) {
        Facing2D newFacing = Facing2D.fromIC2(facingIndex);
        if (newFacing != null && newFacing == this.facing) {
            return;
        }
        this.isOnline = false;
        this.facing = newFacing;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }
}

