/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import dev.rndmorris.salisarcana.lib.WandHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;

public enum WandType {
    UNKNOWN,
    WAND,
    SCEPTER,
    STAFF;


    @Nonnull
    public static WandType getWandType(@Nullable ItemStack itemStack) {
        ItemWandCasting wandInstance = WandHelper.getWandItem(itemStack);
        if (wandInstance == null) {
            return UNKNOWN;
        }
        if (wandInstance.isSceptre(itemStack)) {
            return SCEPTER;
        }
        if (wandInstance.isStaff(itemStack)) {
            return STAFF;
        }
        return WAND;
    }

    public int getCraftingVisCost(WandCap forCap, WandRod forRod) {
        int n;
        if (forCap == null || forRod == null) {
            return -1;
        }
        if (forCap == ConfigItems.WAND_CAP_IRON && forRod == ConfigItems.WAND_ROD_WOOD) {
            return 0;
        }
        switch (this) {
            case WAND: 
            case STAFF: {
                n = forCap.getCraftCost() * forRod.getCraftCost();
                break;
            }
            case SCEPTER: {
                n = (int)((float)(forCap.getCraftCost() * forRod.getCraftCost()) * 1.5f);
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public int getRequiredCaps() {
        int n;
        switch (this) {
            case WAND: 
            case STAFF: {
                n = 2;
                break;
            }
            case SCEPTER: {
                n = 3;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public <R extends WandRod> boolean isCoreSuitable(@Nullable R coreType) {
        boolean bl;
        switch (this) {
            case WAND: 
            case SCEPTER: {
                if (coreType instanceof WandRod && !(coreType instanceof StaffRod)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case STAFF: {
                bl = coreType instanceof StaffRod;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

