/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.ClientEventHandler;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.McUtils;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.config.SortRulesConfig;
import com.cleanroommc.bogosorter.common.network.CSlotSync;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientItemSortRule;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.ItemCompareHelper;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortHandler {
    public static final Map<EntityPlayer, List<SortRule<ItemStack>>> cacheItemSortRules = new Object2ObjectOpenHashMap();
    public static final Map<EntityPlayer, List<NbtSortRule>> cacheNbtSortRules = new Object2ObjectOpenHashMap();
    public static final AtomicReference<List<NbtSortRule>> currentNbtSortRules = new AtomicReference(Collections.emptyList());
    @Nullable
    private static ResourceLocation sortSound = new ResourceLocation(BogoSorterConfig.sortSound);
    private static ResourceLocation FallbacksortSound = new ResourceLocation("gui.button.press");
    private static List<ResourceLocation> foolsSounds = null;
    private static int foolsSortCounter = 0;
    private final EntityPlayer player;
    private final Container container;
    private final GuiSortingContext context;
    private final Comparator<ItemSortContainer> containerComparator;
    private final Int2ObjectMap<ClientSortData> clientSortData;
    private final List<SortRule<ItemStack>> itemSortRules;

    @SideOnly(value=Side.CLIENT)
    public static void playSortSound() {
        ResourceLocation sound = null;
        Minecraft mc = Minecraft.func_71410_x();
        SoundHandler soundHandler = mc.func_147118_V();
        if (BogoSorter.isAprilFools()) {
            if (++foolsSortCounter >= BogoSorter.RND.nextInt(100)) {
                if (foolsSounds == null) {
                    List<ResourceLocation> sounds = SortHandler.getResourceLocations(soundHandler);
                    foolsSounds = sounds;
                }
                foolsSortCounter = 0;
                sound = foolsSounds.get(BogoSorter.RND.nextInt(foolsSounds.size()));
            }
        } else {
            sound = sortSound;
        }
        if (!soundHandler.field_147697_e.func_148741_d((Object)sound)) {
            sound = FallbacksortSound;
        }
        if (sound != null) {
            soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)sound, (float)1.0f));
        }
    }

    @NotNull
    private static List<ResourceLocation> getResourceLocations(SoundHandler soundHandler) {
        ArrayList<ResourceLocation> sounds = new ArrayList<ResourceLocation>(256);
        for (Object key : soundHandler.field_147697_e.func_148742_b()) {
            ResourceLocation soundEvent;
            if (!(key instanceof ResourceLocation) || (soundEvent = (ResourceLocation)key) == null || soundEvent.func_110623_a().contains("music.") || soundEvent.func_110623_a().contains("records.")) continue;
            sounds.add(soundEvent);
        }
        return sounds;
    }

    public SortHandler(EntityPlayer entityPlayer, Container container, Int2ObjectMap<ClientSortData> clientSortData) {
        this(entityPlayer, container, GuiSortingContext.getOrCreate(container), clientSortData);
    }

    public SortHandler(EntityPlayer player, Container container, GuiSortingContext sortingContext, Int2ObjectMap<ClientSortData> clientSortData) {
        this.player = player;
        this.container = container;
        this.context = sortingContext;
        this.itemSortRules = cacheItemSortRules.getOrDefault(player, Collections.emptyList());
        this.containerComparator = (container1, container2) -> {
            int result;
            for (SortRule<ItemStack> sortRule : this.itemSortRules) {
                result = sortRule instanceof ClientItemSortRule ? ((ClientItemSortRule)sortRule).compareServer((ItemSortContainer)container1, (ItemSortContainer)container2) : sortRule.compare(container1.getItemStack(), container2.getItemStack());
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(container1.getItemStack(), container2.getItemStack());
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(container1.getItemStack(), container2.getItemStack());
            return result;
        };
        this.clientSortData = clientSortData;
    }

    public void sort(int slotId) {
        this.sort(slotId, true);
    }

    public void sort(int slotId, boolean sync) {
        SlotGroup slotGroup = this.context.getSlotGroup(slotId);
        this.sort(slotGroup, sync);
    }

    public void sort(SlotGroup slotGroup, boolean sync) {
        if (slotGroup != null) {
            if (BogoSorter.isAprilFools() && BogoSorter.RND.nextFloat() < 0.01f) {
                this.sortBogo(slotGroup);
                this.player.func_145747_a((IChatComponent)new ChatComponentText("Get Bogo'd!"));
            } else {
                this.sortHorizontal(slotGroup);
            }
            if (sync) {
                this.container.func_75142_b();
            }
        }
    }

    public void sortHorizontal(SlotGroup slotGroup) {
        LinkedList<ItemSortContainer> itemList = this.gatherItems(slotGroup);
        if (itemList.isEmpty()) {
            return;
        }
        currentNbtSortRules.set(cacheNbtSortRules.getOrDefault(this.player, Collections.emptyList()));
        itemList.sort(this.containerComparator);
        currentNbtSortRules.set(Collections.emptyList());
        ItemSortContainer itemSortContainer = itemList.pollFirst();
        if (itemSortContainer == null) {
            return;
        }
        for (ISlot slot : this.getSortableSlots(slotGroup)) {
            if (itemSortContainer == null) {
                slot.bogo$putStack(null);
                continue;
            }
            int max = Math.min(slot.bogo$getItemStackLimit(itemSortContainer.getItemStack()), slot.bogo$getMaxStackSize(itemSortContainer.getItemStack()));
            if (max <= 0) continue;
            slot.bogo$putStack(itemSortContainer.makeStack(max));
            if (itemSortContainer.canMakeStack()) continue;
            itemSortContainer = itemList.pollFirst();
        }
        if (!itemList.isEmpty()) {
            McUtils.giveItemsToPlayer(this.player, SortHandler.prepareDropList(itemList));
        }
    }

    public void sortBogo(SlotGroup slotGroup) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ISlot slot : this.getSortableSlots(slotGroup)) {
            ItemStack stack = slot.bogo$getStack();
            items.add(stack);
        }
        Collections.shuffle(items);
        List<ISlot> slots = this.getSortableSlots(slotGroup);
        for (int i = 0; i < slots.size(); ++i) {
            ISlot slot = slots.get(i);
            slot.bogo$putStack((ItemStack)items.get(i));
        }
    }

    public LinkedList<ItemSortContainer> gatherItems(SlotGroup slotGroup) {
        LinkedList<ItemSortContainer> list = new LinkedList<ItemSortContainer>();
        Object2ObjectOpenCustomHashMap items = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);
        for (ISlot slot : this.getSortableSlots(slotGroup)) {
            ItemStack stack = slot.bogo$getStack();
            if (stack == null) continue;
            ItemSortContainer container1 = (ItemSortContainer)items.get((Object)stack);
            if (container1 == null) {
                container1 = new ItemSortContainer(stack, (ClientSortData)this.clientSortData.get(slot.bogo$getSlotNumber()));
                items.put((Object)stack, (Object)container1);
                list.add(container1);
                continue;
            }
            container1.grow(stack.field_77994_a);
        }
        return list;
    }

    private static List<ItemStack> prepareDropList(List<ItemSortContainer> sortedList) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (ItemSortContainer itemSortContainer : sortedList) {
            while (itemSortContainer.canMakeStack()) {
                dropList.add(itemSortContainer.makeStack(itemSortContainer.getItemStack().func_77976_d()));
            }
        }
        return dropList;
    }

    @SideOnly(value=Side.CLIENT)
    public static Comparator<ItemStack> getClientItemComparator() {
        return (stack1, stack2) -> {
            int result = 0;
            for (SortRule<ItemStack> sortRule : SortRulesConfig.sortRules) {
                result = sortRule.compare((ItemStack)stack1, (ItemStack)stack2);
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(stack1, stack2);
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(stack1, stack2);
            return result;
        };
    }

    public void clearAllItems(ISlot slot1) {
        SlotGroup slotGroup = this.context.getSlotGroup(slot1.bogo$getSlotNumber());
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            for (ISlot slot : this.getSortableSlots(slotGroup)) {
                if (slot.bogo$getStack() == null) continue;
                slot.bogo$putStack(null);
                slots.add((Pair<ItemStack, Integer>)Pair.of(null, (Object)slot.bogo$getSlotNumber()));
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }

    public void randomizeItems(ISlot slot1) {
        SlotGroup slotGroup = this.context.getSlotGroup(slot1.bogo$getSlotNumber());
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            Random random = new Random();
            for (ISlot slot : this.getSortableSlots(slotGroup)) {
                if (!(random.nextFloat() < 0.3f)) continue;
                ItemStack randomItem = ClientEventHandler.allItems.get(random.nextInt(ClientEventHandler.allItems.size())).func_77946_l();
                slot.bogo$putStack(randomItem.func_77946_l());
                slots.add((Pair<ItemStack, Integer>)Pair.of((Object)randomItem, (Object)slot.bogo$getSlotNumber()));
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }

    public List<ISlot> getSortableSlots(SlotGroup slotGroup) {
        ArrayList<ISlot> result = new ArrayList<ISlot>();
        for (ISlot slot : slotGroup.getSlots()) {
            boolean isEmpty;
            boolean canTake = slot.bogo$canTakeStack(this.player);
            boolean canInsert = slot.bogo$getStack() != null && slot.bogo$isItemValid(slot.bogo$getStack().func_77946_l());
            boolean bl = isEmpty = slot.bogo$getStack() == null;
            if (!canTake && !canInsert && !isEmpty) continue;
            result.add(slot);
        }
        return result;
    }
}

