/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="bogosorter")
public class BogoSorterConfig {
    @Config.Comment(value={"DropOff Configuration"})
    public static final DropOff dropOff = new DropOff();
    @Config.Comment(value={"Usage Ticker Configuration"})
    public static final UsageTicker usageTicker = new UsageTicker();
    @Config.DefaultString(value="gui.button.press")
    @Config.Comment(value={"Sound played when the sort button is pressed."})
    @Config.LangKey(value="bogosorter.config.sort.sound")
    public static String sortSound;
    @Config.DefaultBoolean(value=true)
    @Config.Comment(value={"Enable the hotbar sort feature."})
    @Config.LangKey(value="bogosorter.config.hotbarsort.enable")
    public static boolean enableHotbarSort;
    @Config.DefaultBoolean(value=true)
    @Config.Comment(value={"Enable the auto-refill feature."})
    @Config.LangKey(value="bogosorter.config.autorefill.enable")
    @Config.Sync
    public static boolean enableAutoRefill;
    @Config.DefaultInt(value=1)
    @Config.Comment(value={"The damage threshold for auto-refill. If the item has less than this amount of durability, it will be refilled."})
    @Config.LangKey(value="bogosorter.config.autorefill.damage_threshold")
    @Config.Sync
    public static int autoRefillDamageThreshold;
    @Config.DefaultString(value="#FFFFFFFF")
    @Config.Comment(value={"The color of the sort button in hex format (e.g. #FFFFFFFF or 0xFFFFFFFF)."})
    @Config.LangKey(value="bogosorter.config.button.color")
    public static String buttonColor;
    @Config.DefaultBoolean(value=true)
    @Config.Comment(value={"Enable the hotbar swap feature."})
    @Config.LangKey(value="bogosorter.config.hotbarswap.enable")
    public static boolean enableHotbarSwap;

    public static int getButtonColor() {
        try {
            return (int)Long.parseLong(buttonColor.replace("#", "").replace("0x", ""), 16);
        }
        catch (NumberFormatException e) {
            return -348161;
        }
    }

    @Config.LangKey(value="bogosorter.config.dropoff")
    public static class DropOff {
        @Config.Comment(value={"DropOff Button Configuration"})
        @Config.LangKey(value="bogosorter.config.dropoff.button")
        public final DropOffButton button = new DropOffButton();
        @Config.DefaultInt(value=4)
        @Config.Comment(value={"The radius (in blocks) around the player to scan for drop-off targets."})
        @Config.LangKey(value="bogosorter.config.dropoff.scan_radius")
        @Config.Sync
        public int dropoffRadius;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Enable the drop-off button in the player inventory."})
        @Config.LangKey(value="bogosorter.config.dropoff.enable")
        public boolean enableDropOff;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Render a highlight on eligible drop-off containers."})
        @Config.LangKey(value="bogosorter.config.dropoff.render")
        public boolean dropoffRender;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Show a chat message after dropping off items."})
        @Config.LangKey(value="bogosorter.config.dropoff.chat_message")
        public boolean dropoffChatMessage;
        @Config.DefaultInt(value=1)
        @Config.Comment(value={"Time quota for drop-off in milliseconds."})
        @Config.LangKey(value="bogosorter.config.dropoff.quota")
        public int dropoffQuotaInMS;
        @Config.DefaultInt(value=500)
        @Config.Comment(value={"Throttle drop-off packets in milliseconds."})
        @Config.LangKey(value="bogosorter.config.dropoff.throttle")
        public int dropoffPacketThrottleInMS;
        @Config.DefaultStringList(value={"Chest", "Barrel", "Drawer", "Crate"})
        @Config.Comment(value={"Valid inventory names for drop-off targeting (substring match)."})
        @Config.LangKey(value="bogosorter.config.dropoff.targets")
        public String[] dropoffTargetNames;

        public static class DropOffButton {
            @Config.DefaultInt(value=160)
            @Config.Comment(value={"X position of the drop-off button in the player inventory."})
            @Config.LangKey(value="bogosorter.config.dropoff.button.x")
            public int buttonX;
            @Config.DefaultInt(value=5)
            @Config.Comment(value={"Y position of the drop-off button in the player inventory."})
            @Config.LangKey(value="bogosorter.config.dropoff.button.y")
            public int buttonY;
            @Config.DefaultBoolean(value=true)
            @Config.Comment(value={"Show the drop-off button in the player inventory."})
            @Config.LangKey(value="bogosorter.config.dropoff.button.visible")
            public boolean showButton;
        }
    }

    @Config.LangKey(value="bogosorter.config.usage_ticker")
    public static class UsageTicker {
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Enable usage ticker module."})
        @Config.LangKey(value="bogosorter.config.usage_ticker.enable")
        public boolean enableModule;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Show usage ticker for main hand."})
        @Config.LangKey(value="bogosorter.config.usage_ticker.mainhand")
        public boolean enableMainHand;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Show usage ticker for off hand."})
        @Config.LangKey(value="bogosorter.config.usage_ticker.offhand")
        public boolean enableOffHand;
        @Config.DefaultBoolean(value=true)
        @Config.Comment(value={"Show usage ticker for armor."})
        @Config.LangKey(value="bogosorter.config.usage_ticker.armor")
        public boolean enableArmor;
    }
}

