/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.genetics.AlleleColor;
import binnie.core.BinnieCore;
import binnie.core.ManagerBase;
import binnie.core.genetics.BeeBreedingSystem;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.FlowerBreedingSystem;
import binnie.core.genetics.MothBreedingSystem;
import binnie.core.genetics.Tolerance;
import binnie.core.genetics.TreeBreedingSystem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.WorldEvent;

public class ManagerGenetics
extends ManagerBase {
    public BreedingSystem beeBreedingSystem;
    public BreedingSystem treeBreedingSystem;
    public BreedingSystem mothBreedingSystem;
    public BreedingSystem flowerBreedingSystem;
    private final Map<ISpeciesRoot, BreedingSystem> breedingSystems = new LinkedHashMap<ISpeciesRoot, BreedingSystem>();
    private final List<IChromosomeType> invalidChromosomeTypes = new ArrayList<IChromosomeType>();
    private final Map<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>> chromosomeArray = new LinkedHashMap<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>>();

    @Override
    public void init() {
        if (BinnieCore.isApicultureActive()) {
            this.beeBreedingSystem = new BeeBreedingSystem();
        }
        if (BinnieCore.isArboricultureActive()) {
            this.treeBreedingSystem = new TreeBreedingSystem();
        }
        if (BinnieCore.isLepidopteryActive()) {
            this.mothBreedingSystem = new MothBreedingSystem();
        }
        this.flowerBreedingSystem = new FlowerBreedingSystem();
    }

    @Override
    public void postInit() {
        this.refreshData();
    }

    public ITreeRoot getTreeRoot() {
        return (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    public IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public IButterflyRoot getButterflyRoot() {
        return (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
    }

    public IFlowerRoot getFlowerRoot() {
        return (IFlowerRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers");
    }

    public BreedingSystem getSystem(String string) {
        for (BreedingSystem system : this.breedingSystems.values()) {
            if (!system.getIdent().equals(string)) continue;
            return system;
        }
        return null;
    }

    public BreedingSystem getSystem(ISpeciesRoot root) {
        if (root == null) {
            return null;
        }
        return this.getSystem(root.getUID());
    }

    public ISpeciesRoot getSpeciesRoot(IAlleleSpecies species) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            if (!root.getKaryotype()[0].getAlleleClass().isInstance(species)) continue;
            return root;
        }
        return null;
    }

    public int[] getTolerance(EnumTolerance tol) {
        return Tolerance.values()[tol.ordinal()].getBounds();
    }

    public Collection<BreedingSystem> getActiveSystems() {
        return this.breedingSystems.values();
    }

    public void registerBreedingSystem(BreedingSystem system) {
        this.breedingSystems.put(system.getSpeciesRoot(), system);
    }

    public BreedingSystem getConversionSystem(ItemStack stack) {
        for (BreedingSystem system : this.getActiveSystems()) {
            if (system.getConversion(stack) == null) continue;
            return system;
        }
        return null;
    }

    public ItemStack getConversionStack(ItemStack stack) {
        BreedingSystem system = this.getConversionSystem(stack);
        return system == null ? null : system.getConversionStack(stack);
    }

    public IIndividual getConversion(ItemStack stack) {
        BreedingSystem system = this.getConversionSystem(stack);
        return system == null ? null : system.getConversion(stack);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.refreshData();
    }

    private void refreshData() {
        this.loadAlleles();
        for (BreedingSystem system : Binnie.Genetics.getActiveSystems()) {
            system.calculateArrays();
        }
    }

    private void loadAlleles() {
        this.invalidChromosomeTypes.clear();
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            BreedingSystem system = this.getSystem(root);
            LinkedHashMap<IChromosomeType, ArrayList<IAllele>> chromosomeMap = new LinkedHashMap<IChromosomeType, ArrayList<IAllele>>();
            for (IChromosomeType chromosome : root.getKaryotype()) {
                TreeSet<IAllele> alleles = new TreeSet<IAllele>(new ComparatorAllele());
                for (IIndividual individual : root.getIndividualTemplates()) {
                    IGenome genome = individual.getGenome();
                    try {
                        IAllele a1 = genome.getActiveAllele(chromosome);
                        IAllele a2 = genome.getInactiveAllele(chromosome);
                        if (chromosome.getAlleleClass().isInstance(a1)) {
                            alleles.add(a1);
                        }
                        if (!chromosome.getAlleleClass().isInstance(a2)) continue;
                        alleles.add(a2);
                    }
                    catch (Exception exception) {}
                }
                system.addExtraAlleles(chromosome, alleles);
                if (alleles.isEmpty()) {
                    this.invalidChromosomeTypes.add(chromosome);
                    continue;
                }
                ArrayList<IAllele> alleleList = new ArrayList<IAllele>(alleles);
                chromosomeMap.put(chromosome, alleleList);
            }
            this.chromosomeArray.put(root, chromosomeMap);
        }
    }

    public Map<IChromosomeType, List<IAllele>> getChromosomeMap(ISpeciesRoot root) {
        return this.chromosomeArray.get(root);
    }

    public Collection<IChromosomeType> getActiveChromosomes(ISpeciesRoot root) {
        return this.getChromosomeMap(root).keySet();
    }

    public boolean isInvalidChromosome(IChromosomeType type) {
        return this.invalidChromosomeTypes.contains(type);
    }

    static class ComparatorAllele
    implements Comparator<IAllele> {
        ComparatorAllele() {
        }

        @Override
        public int compare(IAllele o1, IAllele o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Allele is null!");
            }
            if (o1 instanceof IAlleleFloat) {
                IAlleleFloat af1 = (IAlleleFloat)o1;
                if (o2 instanceof IAlleleFloat) {
                    IAlleleFloat af2 = (IAlleleFloat)o2;
                    return Float.compare(af1.getValue(), af2.getValue());
                }
            }
            if (o1 instanceof IAlleleInteger) {
                IAlleleInteger ai1 = (IAlleleInteger)o1;
                if (o2 instanceof IAlleleInteger) {
                    IAlleleInteger ai2 = (IAlleleInteger)o2;
                    if (!(o1 instanceof AlleleColor)) {
                        return Integer.compare(ai1.getValue(), ai2.getValue());
                    }
                }
            }
            return o1.getUID().compareTo(o2.getUID());
        }
    }
}

