/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.hazards.HazardProtection;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.loader.MainLoader;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTEMicrowave
extends TTMultiblockBase
implements ISurvivalConstructable {
    private boolean hasBeenPausedThisCycle = false;
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.hint.1")};
    private static final IStructureDefinition<MTEMicrowave> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAAAA", "A---A", "A---A", "A---A", "AAAAA"}, {"AAAAA", "A---A", "A---A", "A---A", "AAAAA"}, {"AA~AA", "A---A", "A---A", "A---A", "AAAAA"}, {"ABBBA", "BAAAB", "BAAAB", "BAAAB", "ABBBA"}})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('B', GTStructureUtility.ofHatchAdderOptional(TTMultiblockBase::addClassicToMachineList, 49, 1, GregTechAPI.sBlockCasings4, 1)).build();
    protected Parameters.Group.ParameterIn powerSetting;
    protected Parameters.Group.ParameterIn timerSetting;
    protected Parameters.Group.ParameterOut timerValue;
    protected Parameters.Group.ParameterOut remainingTime;
    private static final INameFunction<MTEMicrowave> POWER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.cfgi.0");
    private static final INameFunction<MTEMicrowave> TIMER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.cfgi.1");
    private static final INameFunction<MTEMicrowave> TIMER_VALUE_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.cfgo.0");
    private static final INameFunction<MTEMicrowave> TIMER_REMAINING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.cfgo.1");
    private static final IStatusFunction<MTEMicrowave> POWER_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 300.0, 1000.0, 1000.0, Double.POSITIVE_INFINITY, new double[0]);
    private static final IStatusFunction<MTEMicrowave> TIMER_STATUS = (base, p) -> {
        double value = p.get();
        if (Double.isNaN(value)) {
            return LedStatus.STATUS_WRONG;
        }
        if ((value = (double)((int)value)) <= 0.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (value > 3000.0) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        return LedStatus.STATUS_OK;
    };

    public MTEMicrowave(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMicrowave(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMicrowave(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM("main", 2, 2, 0);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        this.hasBeenPausedThisCycle = false;
        if ((int)this.powerSetting.get() < 300 || this.timerSetting.get() <= 0.0 || this.timerSetting.get() > 3000.0) {
            return SimpleCheckRecipeResult.ofFailure("invalid_timer");
        }
        if (this.remainingTime.get() <= 0.0) {
            this.remainingTime.set(this.timerSetting.get());
            this.timerValue.set(0.0);
        }
        this.mEUt = -((int)this.powerSetting.get() >> 1);
        this.eAmpereFlow = 1L;
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        return SimpleCheckRecipeResult.ofSuccess("microwaving");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (this.hasBeenPausedThisCycle) {
            return;
        }
        this.timerValue.set(this.timerValue.get() + 1.0);
        this.remainingTime.set(this.timerSetting.get() - this.timerValue.get());
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        Vec3Impl xyzOffsets = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, -1, 2));
        double xPos = (float)mte.getXCoord() + 0.5f + (float)xyzOffsets.get0();
        double yPos = (float)mte.getYCoord() + 0.5f + (float)xyzOffsets.get1();
        double zPos = (float)mte.getZCoord() + 0.5f + (float)xyzOffsets.get2();
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)-2.0, (double)-2.0, (double)-2.0, (double)2.0, (double)2.0, (double)2.0).func_72317_d(xPos, yPos, zPos);
        xyzOffsets = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, -4, 0));
        Vec3Impl xyzExpansion = this.getExtendedFacing().getWorldOffset(new Vec3Impl(1, 0, 1)).abs();
        int power = (int)this.powerSetting.get();
        int damagingFactor = Math.min(power >> 6, 8) + Math.min(power >> 8, 24) + Math.min(power >> 12, 48) + (power >> 18);
        ArrayList<ItemStack> itemsToOutput = new ArrayList<ItemStack>();
        HashSet<Entity> tickedStuff = new HashSet<Entity>();
        boolean inside = true;
        do {
            for (Entity entity : mte.getWorld().func_72839_b(null, aabb)) {
                if (!tickedStuff.add(entity)) continue;
                if (inside && entity instanceof EntityItem) {
                    GTRecipe tRecipe = RecipeMaps.microwaveRecipes.findRecipeQuery().items(((EntityItem)entity).func_92059_d()).voltage(128L).notUnificated(true).find();
                    if (tRecipe == null || tRecipe.mInputs.length == 0 || tRecipe.mInputs[0].field_77994_a != 1) {
                        itemsToOutput.add(((EntityItem)entity).func_92059_d());
                    } else {
                        ItemStack newStuff = tRecipe.getOutput(0).func_77946_l();
                        newStuff.field_77994_a = ((EntityItem)entity).func_92059_d().field_77994_a;
                        itemsToOutput.add(newStuff);
                    }
                    ((EntityItem)entity).field_145804_b = 2;
                    entity.func_70106_y();
                    continue;
                }
                if (!(entity instanceof EntityLivingBase) || HazardProtection.isWearingFullElectroHazmat((EntityLivingBase)entity)) continue;
                entity.func_70097_a(MainLoader.microwaving, (float)damagingFactor);
            }
            aabb.func_72317_d((double)xyzOffsets.get0(), (double)xyzOffsets.get1(), (double)xyzOffsets.get2());
            aabb = aabb.func_72314_b((double)xyzExpansion.get0() * 1.5, (double)xyzExpansion.get1() * 1.5, (double)xyzExpansion.get2() * 1.5);
            inside = false;
        } while ((damagingFactor >>= 1) > 0);
        this.mOutputItems = itemsToOutput.toArray(new ItemStack[0]);
        if (this.remainingTime.get() <= 0.0) {
            mte.getWorld().func_72908_a(xPos, yPos, zPos, "tectech:microwave_ding", 1.0f, 1.0f);
            this.stopMachine(ShutDownReasonRegistry.NONE);
        }
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.3")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.4")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.microwave.desc.5")).beginStructureBlock(5, 4, 5, true).addController(StatCollector.func_74838_a((String)"tt.keyword.Structure.FrontCenter")).addCasingInfoMin(StatCollector.func_74838_a((String)"tt.keyword.Structure.StainlessSteelCasing"), 60, false).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataConnector"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyOuterCasingOnBottom"), 2).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyOuterCasingOnBottom"), 1).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyOuterCasingOnBottom"), 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], new TTRenderedExtendedFacingTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE)};
        }
        if (side == facing.getOpposite()) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], aActive ? Textures.BlockIcons.casingTexturePages[0][52] : Textures.BlockIcons.casingTexturePages[0][53]};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, true);
        this.powerSetting = hatch_0.makeInParameter(0, 1000.0, POWER_SETTING_NAME, POWER_STATUS);
        this.timerSetting = hatch_0.makeInParameter(1, 360.0, TIMER_SETTING_NAME, TIMER_STATUS);
        this.timerValue = hatch_0.makeOutParameter(0, 0.0, TIMER_VALUE_NAME, TIMER_STATUS);
        this.remainingTime = hatch_0.makeOutParameter(1, 360.0, TIMER_REMAINING_NAME, TIMER_STATUS);
    }

    @Override
    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        this.remainingTime.set(this.timerSetting.get());
        this.timerValue.set(0.0);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.eSafeVoid) {
            this.hasBeenPausedThisCycle = true;
        }
        return this.hasBeenPausedThisCycle || super.onRunningTick(aStack);
    }

    @Override
    public byte getTileEntityBaseType() {
        return 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 2, 2, 0, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("main", stackSize, 2, 2, 0, elementBudget, source, actor, false, true);
    }

    public IStructureDefinition<MTEMicrowave> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    @Override
    public boolean isSafeVoidButtonEnabled() {
        return false;
    }
}

