/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import bartworks.system.material.Werkstoff;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MetaTileEntityIDs;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SubTag;
import gregtech.api.metatileentity.implementations.MTEBasicMachineWithRecipe;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.item.ItemStack;

public class GregtechSimpleWasher {
    public static void run() {
        GregtechSimpleWasher.generateDirtyDustRecipes();
        GregtechSimpleWasher.generateDirtyCrushedRecipes();
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_LV, MetaTileEntityIDs.SimpleDustWasher_LV.ID, "simplewasher.01.tier.06", "Simple Washer I", 1);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_MV, MetaTileEntityIDs.SimpleDustWasher_MV.ID, "simplewasher.01.tier.02", "Simple Washer II", 2);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_HV, MetaTileEntityIDs.SimpleDustWasher_HV.ID, "simplewasher.01.tier.07", "Simple Washer III", 3);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_EV, MetaTileEntityIDs.SimpleDustWasher_EV.ID, "simplewasher.01.tier.03", "Simple Washer IV", 4);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_IV, MetaTileEntityIDs.SimpleDustWasher_IV.ID, "simplewasher.01.tier.08", "Simple Washer V", 5);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_LuV, MetaTileEntityIDs.SimpleDustWasher_LuV.ID, "simplewasher.01.tier.04", "Simple Washer VI", 6);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_ZPM, MetaTileEntityIDs.SimpleDustWasher_ZPM.ID, "simplewasher.01.tier.09", "Simple Washer VII", 7);
        GregtechSimpleWasher.registerSimpleWasher(GregtechItemList.SimpleDustWasher_UV, MetaTileEntityIDs.SimpleDustWasher_UV.ID, "simplewasher.01.tier.05", "Simple Washer VIII", 8);
        GregtechItemList.SimpleDustWasher_ULV.set(new MTEBasicMachineWithRecipe(MetaTileEntityIDs.SimpleDustWasher_ULV.ID, "simplewasher.01.tier.01", "Deprecated ULV Simple Washer", 0, new String[]{"It's like an automatic Cauldron for washing dusts.", "\u00a7cDEPRECATED: No recipe.\u00a7r Make a Simple Washer I.", GTPPCore.GT_Tooltip.get()}, GTPPRecipeMaps.simpleWasherRecipes, 1, 1, true, SoundResource.NONE, MTEBasicMachineWithRecipe.SpecialEffects.NONE, "SIMPLE_WASHER", null).setRecipeCatalystPriority(-11).getStackForm(1L));
    }

    private static void registerSimpleWasher(GregtechItemList washer, int id, String unloc, String loc, int tier) {
        washer.set(new MTEBasicMachineWithRecipe(id, unloc, loc, tier, new String[]{"It's like an automatic Cauldron for washing dusts.", GTPPCore.GT_Tooltip.get()}, GTPPRecipeMaps.simpleWasherRecipes, 1, 1, true, SoundResource.NONE, MTEBasicMachineWithRecipe.SpecialEffects.NONE, "SIMPLE_WASHER", null).setRecipeCatalystPriority(-tier).getStackForm(1L));
    }

    private static boolean generateDirtyDustRecipes() {
        ItemStack dustPure;
        ItemStack dustDirty;
        ItemStack dustClean;
        int mRecipeCount = 0;
        for (Materials v : Materials.values()) {
            if (v.contains(SubTag.NO_ORE_PROCESSING) || v == Materials.Platinum || v == Materials.Osmium || v == Materials.Iridium || v == Materials.Palladium || v == Materials.AnyCopper || v == Materials.AnyIron) continue;
            dustClean = GTOreDictUnificator.get(OrePrefixes.dust, v, 1L);
            dustDirty = GTOreDictUnificator.get(OrePrefixes.dustImpure, v, 1L);
            dustPure = GTOreDictUnificator.get(OrePrefixes.dustPure, v, 1L);
            GregtechSimpleWasher.addSimpleWashRecipe(dustDirty, dustClean);
            GregtechSimpleWasher.addSimpleWashRecipe(dustPure, dustClean);
        }
        for (Werkstoff v : Werkstoff.werkstoffHashSet) {
            dustClean = v.hasItemType(OrePrefixes.dust) ? v.get(OrePrefixes.dust) : null;
            dustDirty = v.hasItemType(OrePrefixes.dustImpure) ? v.get(OrePrefixes.dustImpure) : null;
            dustPure = v.hasItemType(OrePrefixes.dustPure) ? v.get(OrePrefixes.dustPure) : null;
            GregtechSimpleWasher.addSimpleWashRecipe(dustDirty, dustClean);
            GregtechSimpleWasher.addSimpleWashRecipe(dustPure, dustClean);
        }
        return GTPPRecipeMaps.simpleWasherRecipes.getAllRecipes().size() > mRecipeCount;
    }

    private static boolean generateDirtyCrushedRecipes() {
        ItemStack crushedDirty;
        ItemStack crushedClean;
        int mRecipeCount = GTPPRecipeMaps.simpleWasherRecipes.getAllRecipes().size();
        for (Materials v : Materials.values()) {
            if (v.contains(SubTag.NO_ORE_PROCESSING)) continue;
            crushedClean = GTOreDictUnificator.get(OrePrefixes.crushedPurified, v, 1L);
            crushedDirty = GTOreDictUnificator.get(OrePrefixes.crushed, v, 1L);
            GregtechSimpleWasher.addSimpleWashRecipe(crushedDirty, crushedClean);
        }
        for (Werkstoff v : Werkstoff.werkstoffHashSet) {
            crushedClean = v.hasItemType(OrePrefixes.crushedPurified) ? v.get(OrePrefixes.crushedPurified) : null;
            crushedDirty = v.hasItemType(OrePrefixes.crushed) ? v.get(OrePrefixes.crushed) : null;
            GregtechSimpleWasher.addSimpleWashRecipe(crushedDirty, crushedClean);
        }
        return GTPPRecipeMaps.simpleWasherRecipes.getAllRecipes().size() > mRecipeCount;
    }

    private static void addSimpleWashRecipe(ItemStack aInput, ItemStack aOutput) {
        if (aInput != null && aOutput != null) {
            GTValues.RA.stdBuilder().itemInputs(aInput).itemOutputs(aOutput).fluidInputs(Materials.Water.getFluid(100L)).duration(5).eut(8).addTo(GTPPRecipeMaps.simpleWasherRecipes);
        }
    }
}

