/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTELargeSemifluidGenerator
extends GTPPMultiBlockBase<MTELargeSemifluidGenerator>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTELargeSemifluidGenerator> STRUCTURE_DEFINITION = null;
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected boolean boostEu = false;

    public MTELargeSemifluidGenerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeSemifluidGenerator(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Engine Intake Casings must not be obstructed in front (only air blocks)").addInfo("Supply Semifluid Fuels and 2000L of Lubricant per hour to run.").addInfo("Supply 80L of Oxygen per second to boost output (optional).").addInfo("Default: Produces 2048EU/t at 100% efficiency").addInfo("Boosted: Produces 6144EU/t at 150% efficiency").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 4, false).addController("Front Center").addCasingInfoMin("Stable Titanium Machine Casing", 16, false).addCasingInfoMin("Steel Gear Box Machine Casing", 2, false).addCasingInfoMin("Engine Intake Machine Casing", 8, false).addInputHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).addDynamoHatch("Back Center", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_GLOW;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected int getCasingTextureId() {
        return 50;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        long lubricantCost;
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        FluidStack lubricant = Materials.Lubricant.getFluid(0L);
        FluidStack oxygen = Materials.Oxygen.getGas(0L);
        for (FluidStack hatchFluid : tFluids) {
            if (hatchFluid.isFluidEqual(lubricant)) {
                lubricant.amount = Math.max(lubricant.amount, hatchFluid.amount);
                continue;
            }
            if (!hatchFluid.isFluidEqual(oxygen)) continue;
            oxygen.amount = Math.max(oxygen.amount, hatchFluid.amount);
        }
        this.boostEu = (long)oxygen.amount >= 4L;
        long l = lubricantCost = this.boostEu ? 2L : 1L;
        if ((long)lubricant.amount < lubricantCost) {
            return SimpleCheckRecipeResult.ofFailure("no_lubricant");
        }
        for (FluidStack hatchFluid : tFluids) {
            GTRecipe aFuel = GTPPRecipeMaps.semiFluidFuels.getBackend().findFuel(hatchFluid);
            if (aFuel == null) continue;
            int newEUt = this.boostEu ? 4096 : 2048;
            this.fuelConsumption = newEUt / aFuel.mSpecialValue;
            FluidStack tLiquid = new FluidStack(hatchFluid.getFluid(), this.fuelConsumption);
            if (!this.depleteInput(tLiquid)) continue;
            if (this.boostEu && !this.depleteInput(Materials.Oxygen.getGas(4L))) {
                return SimpleCheckRecipeResult.ofFailure("no_oxygen");
            }
            if (!(this.mRuntime % 72 != 0 && this.mRuntime != 0 || this.depleteInput(Materials.Lubricant.getFluid(lubricantCost)))) {
                return SimpleCheckRecipeResult.ofFailure("no_lubricant");
            }
            this.fuelValue = aFuel.mSpecialValue;
            this.fuelRemaining = hatchFluid.amount;
            this.lEUt = this.mEfficiency < 2000 ? 0L : (long)newEUt;
            this.mProgresstime = 1;
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = 15;
            return CheckRecipeResultRegistry.GENERATING;
        }
        this.lEUt = 0L;
        this.mEfficiency = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public IStructureDefinition<MTELargeSemifluidGenerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"III", "CCC", "CCC", "CCC"}, {"I~I", "CGC", "CGC", "CMC"}, {"III", "CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTELargeSemifluidGenerator.class).atLeast(HatchElement.Muffler, HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).addElement('G', StructureUtility.ofBlock((Block)this.getGearboxBlock(), (int)this.getGearboxMeta())).addElement('I', StructureUtility.ofBlock((Block)this.getIntakeBlock(), (int)this.getIntakeMeta())).addElement('M', HatchElement.Dynamo.or(GTPPMultiBlockBase.GTPPHatchElement.TTDynamo).newAny(this.getCasingTextureIndex(), 2)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mDynamoHatches.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 16 && this.checkHatch();
    }

    public final boolean addLargeSemifluidGeneratorList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchMuffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addLargeSemifluidGeneratorBackList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchDynamo || this.isThisHatchMultiDynamo(aTileEntity)) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    public byte getCasingMeta() {
        return 2;
    }

    public Block getIntakeBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    public byte getIntakeMeta() {
        return 13;
    }

    public Block getGearboxBlock() {
        return GregTechAPI.sBlockCasings2;
    }

    public byte getGearboxMeta() {
        return 3;
    }

    public byte getCasingTextureIndex() {
        return 50;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeSemifluidGenerator(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return this.boostEu ? 15000 : 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiLargeSemiFluidGenerator;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Large Semifluid Generator", "Current Output: " + this.lEUt * (long)this.mEfficiency / 10000L + " EU/t", "Fuel Consumption: " + this.fuelConsumption + "L/t", "Fuel Value: " + this.fuelValue + " EU/L", "Fuel Remaining: " + this.fuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 100 + "%", this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance"};
    }

    @Override
    public String getMachineType() {
        return "Semifluid Generator";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 0;
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }
}

