/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.IonParticles;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class MTECyclotron
extends GTPPMultiBlockBase<MTECyclotron>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTECyclotron> STRUCTURE_DEFINITION = null;

    public MTECyclotron(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTECyclotron(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Particle Accelerator";
    }

    @Override
    public long maxEUStore() {
        return 1800000000L;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECyclotron(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public IStructureDefinition<MTECyclotron> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"               ", "      hhh      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " h           h ", " h           h ", " h           h ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      hhh      ", "               "}, {"      hhh      ", "    hhccchh    ", "   hcchhhcch   ", "  hchh   hhch  ", " hch       hch ", " hch       hch ", "hch         hch", "hch         hch", "hch         hch", " hch       hch ", " hch       hch ", "  hchh   hhch  ", "   hcch~hcch   ", "    hhccchh    ", "      hhh      "}, {"               ", "      hhh      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " h           h ", " h           h ", " h           h ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      hhh      ", "               "}})).addElement('h', GTStructureUtility.buildHatchAdder(MTECyclotron.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(44).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).addElement('c', StructureUtility.ofBlock((Block)this.getCyclotronCoil(), (int)this.getCyclotronCoilMeta())).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 7, 1, 12);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 7, 1, 12, elementBudget, env, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 7, 1, 12) && this.mCasing >= 40;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings2Misc;
    }

    public int getCasingMeta() {
        return 10;
    }

    public Block getCyclotronCoil() {
        return ModBlocks.blockCasings2Misc;
    }

    public int getCyclotronCoilMeta() {
        return 9;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Super Magnetic Speed Shooter").addSeparator().addInfo("Particles are accelerated over 186 revolutions to 80% light speed").addInfo("Can produce a continuous beam current of 2.2 mA at 590 MeV").addInfo("Which will be extracted from the Isochronous Cyclotron").addSeparator().addInfo("Similar structure to the Fusion Reactor").addInfo("Any external casing can be a hatch/bus, unlike Fusion").addInfo("Cyclotron Machine Casings around Cyclotron Coil Blocks").addPollutionAmount(this.getPollutionPerSecond(null)).addCasingInfoMin("Cyclotron Machine Casings", 40, false).addCasingInfoMin("Cyclotron Coil", 32, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return this.getIconOverlay();
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return this.getIconGlowOverlay();
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return this.getIconOverlay();
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return this.getIconGlowOverlay();
    }

    @Override
    protected int getCasingTextureId() {
        return 44;
    }

    public IIconContainer getIconOverlay() {
        if (this.getBaseMetaTileEntity().isActive()) {
            return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
        }
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    public IIconContainer getIconGlowOverlay() {
        if (this.getBaseMetaTileEntity().isActive()) {
            return TexturesGtBlock.Overlay_MatterFab_Active_Animated_Glow;
        }
        return TexturesGtBlock.Overlay_MatterFab_Animated_Glow;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.cyclotronRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (result.wasSuccessful()) {
                    for (ItemStack s : this.outputItems) {
                        long aCharge;
                        if (s == null || !(s.func_77973_b() instanceof IonParticles) || (aCharge = IonParticles.getChargeState(s)) != 0L) continue;
                        IonParticles.setChargeState(s, MathUtils.getRandomFromArray(new int[]{-5, -5, -4, -4, -4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6}));
                    }
                }
                return result;
            }
        };
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!this.mOutputBusses.isEmpty()) {
            for (MTEHatchOutputBus g : this.mOutputBusses) {
                if (g == null) continue;
                for (ItemStack s : g.mInventory) {
                    long aCharge;
                    if (s == null || !(s.func_77973_b() instanceof IonParticles) || (aCharge = IonParticles.getChargeState(s)) != 0L) continue;
                    IonParticles.setChargeState(s, MathUtils.getRandomFromArray(new int[]{-5, -5, -4, -4, -4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6}));
                }
            }
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public String[] getExtraInfoData() {
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
        }
        return new String[]{"COMET - Compact Cyclotron MK I", "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.getEUVar() + " / " + this.maxEUStore()};
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

