/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.METHatchAirIntake;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchInputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchOutputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;

public abstract class GTPPMultiBlockBase<T extends MTEExtendedPowerMultiBlockBase<T>>
extends MTEExtendedPowerMultiBlockBase<T> {
    public static final boolean DEBUG_DISABLE_CORES_TEMPORARILY = true;
    public GTRecipe mLastRecipe;
    public ArrayList<METHatchAirIntake> mAirIntakes = new ArrayList();
    public ArrayList<MTEHatchInputBattery> mChargeHatches = new ArrayList();
    public ArrayList<MTEHatchOutputBattery> mDischargeHatches = new ArrayList();
    public ArrayList<MTEHatch> mAllEnergyHatches = new ArrayList();
    public ArrayList<MTEHatch> mAllDynamoHatches = new ArrayList();
    private String[] aCachedToolTip;
    public static final String TAG_HIDE_HATCHES = "TAG_HIDE_HATCHES";
    public static final String TAG_HIDE_MAINT = "TAG_HIDE_MAINT";
    public static final String TAG_HIDE_POLLUTION = "TAG_HIDE_POLLUTION";
    public static final String TAG_HIDE_MACHINE_TYPE = "TAG_HIDE_MACHINE_TYPE";
    public static Method aLogger = null;
    public ArrayList<MTEHatch> mTecTechDynamoHatches = new ArrayList();
    public ArrayList<MTEHatch> mTecTechEnergyHatches = new ArrayList();
    private static final Materials GOOD = Materials.Uranium;
    private static final Materials BAD = Materials.Plutonium;
    private static final ConcurrentHashMap<String, ItemStack> mToolStacks = new ConcurrentHashMap();

    public GTPPMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTPPMultiBlockBase(String aName) {
        super(aName);
    }

    private static int toStackCount(Map.Entry<ItemStack, Integer> e) {
        int tMaxStackSize = e.getKey().func_77976_d();
        int tStackSize = e.getValue();
        return (tStackSize + tMaxStackSize - 1) / tMaxStackSize;
    }

    public abstract String getMachineType();

    public String getMachineTooltip() {
        return "Machine Type: " + EnumChatFormatting.YELLOW + this.getMachineType() + EnumChatFormatting.RESET;
    }

    public String[] getExtraInfoData() {
        return GTValues.emptyStringArray;
    }

    @Override
    public String[] getInfoData() {
        long maxEnergy;
        long storedEnergy;
        String[] extra;
        ArrayList<String> mInfo = new ArrayList<String>();
        if (!this.getMetaName().isEmpty()) {
            mInfo.add(this.getMetaName());
        }
        if ((extra = this.getExtraInfoData()) == null) {
            extra = GTValues.emptyStringArray;
        }
        mInfo.addAll(Arrays.asList(extra));
        long seconds = this.mTotalRunTime / 20L;
        int weeks = (int)(TimeUnit.SECONDS.toDays(seconds) / 7L);
        int days = (int)(TimeUnit.SECONDS.toDays(seconds) - (long)(7 * weeks));
        long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days) - TimeUnit.DAYS.toHours(7L * (long)weeks);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        mInfo.add(this.getMachineTooltip());
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s");
        if (!this.mAllEnergyHatches.isEmpty()) {
            storedEnergy = this.getStoredEnergyInAllEnergyHatches();
            maxEnergy = this.getMaxEnergyStorageOfAllEnergyHatches();
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":");
            mInfo.add(StatCollector.func_74838_a((String)(EnumChatFormatting.GREEN.toString() + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU")));
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":");
            mInfo.add(StatCollector.func_74838_a((String)(EnumChatFormatting.YELLOW.toString() + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET)));
        }
        if (!this.mAllDynamoHatches.isEmpty()) {
            storedEnergy = this.getStoredEnergyInAllDynamoHatches();
            maxEnergy = this.getMaxEnergyStorageOfAllDynamoHatches();
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + " In Dynamos:");
            mInfo.add(StatCollector.func_74838_a((String)(EnumChatFormatting.GREEN.toString() + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU")));
        }
        if (-this.lEUt > 0L) {
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.RED + -this.lEUt + EnumChatFormatting.RESET + " EU/t")));
        } else {
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + this.lEUt + EnumChatFormatting.RESET + " EU/t")));
        }
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %");
        if (this.getPollutionPerSecond(null) > 0) {
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollution") + ": " + EnumChatFormatting.RED + this.getPollutionPerSecond(null) + EnumChatFormatting.RESET + "/sec");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %");
        }
        mInfo.add(StatCollector.func_74838_a((String)"GTPP.CC.parallel") + ": " + EnumChatFormatting.GREEN + this.getMaxParallelRecipes() + EnumChatFormatting.RESET);
        mInfo.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi_block.total_time", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + weeks + EnumChatFormatting.RESET, "" + EnumChatFormatting.DARK_GREEN + days + EnumChatFormatting.RESET}));
        mInfo.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi_block.total_time.0", (Object[])new Object[]{EnumChatFormatting.DARK_GREEN + Long.toString(hours) + EnumChatFormatting.RESET, EnumChatFormatting.DARK_GREEN + Long.toString(minutes) + EnumChatFormatting.RESET, EnumChatFormatting.DARK_GREEN + Long.toString(second) + EnumChatFormatting.RESET}));
        mInfo.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi_block.total_time.in_ticks", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.mTotalRunTime}));
        return mInfo.toArray(new String[0]);
    }

    public long getStoredEnergyInAllEnergyHatches() {
        long storedEnergy = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mAllEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllEnergyHatches() {
        long maxEnergy = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mAllEnergyHatches)) {
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public long getStoredEnergyInAllDynamoHatches() {
        long storedEnergy = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllDynamoHatches() {
        long maxEnergy = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public void log(String s) {
        if (!ASMConfiguration.debug.disableAllLogging) {
            if (ASMConfiguration.debug.debugMode) {
                Logger.INFO(s);
            } else {
                Logger.MACHINE_INFO(s, new Object[0]);
            }
        }
    }

    public long getMaxInputEnergy() {
        long rEnergy = 0L;
        if (this.mEnergyHatches.size() == 1) {
            return ((MTEHatchEnergy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage();
        }
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            rEnergy += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rEnergy;
    }

    public boolean isMachineRunning() {
        return this.getBaseMetaTileEntity().isActive();
    }

    @Override
    public void explodeMultiblock() {
        for (MetaTileEntity metaTileEntity : this.mChargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mDischargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mTecTechDynamoHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mTecTechEnergyHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
        super.explodeMultiblock();
    }

    protected boolean setGUIItemStack(ItemStack aNewGuiSlotContents) {
        boolean result = false;
        if (this.mInventory[1] == null) {
            this.mInventory[1] = aNewGuiSlotContents != null ? aNewGuiSlotContents.func_77946_l() : null;
            this.depleteInput(aNewGuiSlotContents);
            this.updateSlots();
            result = true;
        }
        return result;
    }

    protected boolean depleteInputFromRestrictedHatches(Collection<MTEHatchCustomFluidBase> aHatches, int aAmount) {
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(aHatches)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || tLiquid.amount < aAmount || (tLiquid = tHatch.drain(aAmount, false)) == null || tLiquid.amount < aAmount) continue;
            tLiquid = tHatch.drain(aAmount, true);
            return tLiquid != null && tLiquid.amount >= aAmount;
        }
        return false;
    }

    @Override
    public void updateSlots() {
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mChargeHatches)) {
            ((MTEHatchInputBattery)tHatch).updateSlots();
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mDischargeHatches)) {
            ((MTEHatchOutputBattery)tHatch).updateSlots();
        }
        super.updateSlots();
    }

    @Override
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        if (errors.contains((Object)StructureError.MISSING_MAINTENANCE)) {
            lines.add(StatCollector.func_74838_a((String)"GT5U.gui.text.no_maintenance"));
        }
        if (errors.contains((Object)StructureError.MISSING_MUFFLER)) {
            lines.add(StatCollector.func_74838_a((String)"GT5U.gui.text.no_muffler"));
        }
        if (errors.contains((Object)StructureError.UNNEEDED_MUFFLER)) {
            lines.add(StatCollector.func_74838_a((String)"GT5U.gui.text.unneeded_muffler"));
        }
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        if (this.shouldCheckMaintenance() && this.mMaintenanceHatches.isEmpty()) {
            errors.add(StructureError.MISSING_MAINTENANCE);
        }
        if (this.getPollutionPerSecond(null) > 0 && this.mMufflerHatches.isEmpty()) {
            errors.add(StructureError.MISSING_MUFFLER);
        }
        if (this.getPollutionPerSecond(null) == 0 && !this.mMufflerHatches.isEmpty()) {
            errors.add(StructureError.UNNEEDED_MUFFLER);
        }
    }

    public boolean checkHatch() {
        return true;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mChargeHatches.clear();
        this.mDischargeHatches.clear();
        this.mAirIntakes.clear();
        this.mTecTechEnergyHatches.clear();
        this.mTecTechDynamoHatches.clear();
        this.mAllEnergyHatches.clear();
        this.mAllDynamoHatches.clear();
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineListInternal(aList, this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IMetaTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        try {
            if (aTileEntity instanceof MTEHatchInput) {
                this.resetRecipeMapForHatch((MTEHatch)aTileEntity, this.getRecipeMap());
            }
            if (aTileEntity instanceof MTEHatchInputBus) {
                this.resetRecipeMapForHatch((MTEHatch)aTileEntity, this.getRecipeMap());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (aList.isEmpty()) {
            if (aTileEntity instanceof MTEHatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aTileEntity.func_145825_b() + " at " + new BlockPos(aTileEntity.getBaseMetaTileEntity()).getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        } else {
            IGregTechTileEntity aCur = aTileEntity.getBaseMetaTileEntity();
            if (aList.contains(aTileEntity)) {
                this.log("Found Duplicate " + aTileEntity.func_145825_b() + " @ " + new BlockPos(aCur).getLocationString());
                return false;
            }
            BlockPos aCurPos = new BlockPos(aCur);
            boolean aExists = false;
            for (IMetaTileEntity iMetaTileEntity : aList) {
                BlockPos aPos;
                IGregTechTileEntity b = iMetaTileEntity.getBaseMetaTileEntity();
                if (b == null || !aCurPos.equals(aPos = new BlockPos(b))) continue;
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Found Duplicate " + b.func_145825_b() + " at " + aPos.getLocationString());
                }
                return false;
            }
            if (aTileEntity instanceof MTEHatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aCur.func_145825_b() + " at " + aCurPos.getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        }
        return false;
    }

    private IMetaTileEntity getMetaTileEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity == null) {
            return null;
        }
        return aTileEntity.getMetaTileEntity();
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity == null) {
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof MTEHatchInputBattery) {
            this.log("Found MTEHatchInputBattery");
            aDidAdd = this.addToMachineListInternal(this.mChargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchOutputBattery) {
            this.log("Found MTEHatchOutputBattery");
            aDidAdd = this.addToMachineListInternal(this.mDischargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof METHatchAirIntake) {
            aDidAdd = this.addToMachineListInternal(this.mAirIntakes, aMetaTileEntity, aBaseCasingIndex) && this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiEnergy");
            aDidAdd = this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiDynamo");
            aDidAdd = this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof MTEHatchInput) {
            aDidAdd = this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchOutput) {
            aDidAdd = this.addToMachineListInternal(this.mOutputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof IDualInputHatch) {
            IDualInputHatch hatch = (IDualInputHatch)((Object)aMetaTileEntity);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            aDidAdd = this.addToMachineListInternal(this.mDualInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchInputBus) {
            aDidAdd = this.addToMachineListInternal(this.mInputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchOutputBus) {
            aDidAdd = this.addToMachineListInternal(this.mOutputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchEnergy) {
            aDidAdd = this.addToMachineListInternal(this.mEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof MTEHatchDynamo) {
            aDidAdd = this.addToMachineListInternal(this.mDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            aDidAdd = this.addToMachineListInternal(this.mMaintenanceHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchMuffler) {
            aDidAdd = this.addToMachineListInternal(this.mMufflerHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    @Override
    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchMuffler) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchInput || aMetaTileEntity instanceof MTEHatchInputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchOutput || aMetaTileEntity instanceof MTEHatchOutputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addAirIntakeToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof METHatchAirIntake) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addFluidInputToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addFluidInputToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity instanceof MTEHatchInput) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean clearRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(null);
    }

    public boolean resetRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
    }

    public boolean resetRecipeMapForAllInputHatches(RecipeMap<?> aMap) {
        int cleared = 0;
        for (MTEHatch g : this.mInputHatches) {
            if (!this.resetRecipeMapForHatch(g, aMap)) continue;
            ++cleared;
        }
        for (MTEHatch g : this.mInputBusses) {
            if (!this.resetRecipeMapForHatch(g, aMap)) continue;
            ++cleared;
        }
        return cleared > 0;
    }

    public boolean resetRecipeMapForHatch(IGregTechTileEntity aTileEntity, RecipeMap<?> aMap) {
        try {
            IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
            if (aMetaTileEntity == null) {
                return false;
            }
            if (aMetaTileEntity instanceof MTEHatchInput || aMetaTileEntity instanceof MTEHatchInputBus) {
                return this.resetRecipeMapForHatch((MTEHatch)aMetaTileEntity, aMap);
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public boolean resetRecipeMapForHatch(MTEHatch aTileEntity, RecipeMap<?> aMap) {
        if (aTileEntity == null) {
            return false;
        }
        if (aTileEntity instanceof MTEHatchInput || aTileEntity instanceof MTEHatchInputBus) {
            if (aTileEntity instanceof MTEHatchInput) {
                ((MTEHatchInput)aTileEntity).mRecipeMap = null;
                ((MTEHatchInput)aTileEntity).mRecipeMap = aMap;
                if (aMap != null) {
                    this.log("Remapped Input Hatch to " + aMap.unlocalizedName + ".");
                } else {
                    this.log("Cleared Input Hatch.");
                }
            } else {
                ((MTEHatchInputBus)aTileEntity).mRecipeMap = null;
                ((MTEHatchInputBus)aTileEntity).mRecipeMap = aMap;
                if (aMap != null) {
                    this.log("Remapped Input Bus to " + aMap.unlocalizedName + ".");
                } else {
                    this.log("Cleared Input Bus.");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        this.clearRecipeMapForAllInputHatches();
        this.onModeChangeByScrewdriver(side, aPlayer, aX, aY, aZ);
        this.mLastRecipe = null;
        this.resetRecipeMapForAllInputHatches();
    }

    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    public boolean updateTexture(IGregTechTileEntity aTileEntity, int aCasingID) {
        return this.updateTexture(this.getMetaTileEntity(aTileEntity), aCasingID);
    }

    public boolean updateTexture(IMetaTileEntity aTileEntity, int aCasingID) {
        if (aTileEntity instanceof MTEHatch) {
            MTEHatch mteHatch = (MTEHatch)aTileEntity;
            mteHatch.updateTexture(aCasingID);
            return true;
        }
        return false;
    }

    public boolean addMultiAmpDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiDynamo(aTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiDynamo(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiDynamo(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiDynamo(IMetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity instanceof MTEHatchDynamoMulti;
    }

    @Override
    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchDynamo || this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterDynamoHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch aHatch = (MTEHatch)aMetaTileEntity;
            return this.mAllDynamoHatches.add(aHatch);
        }
        return false;
    }

    public boolean addMultiAmpEnergyToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiEnergy(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiEnergy(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiEnergy(IMetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity instanceof MTEHatchEnergyMulti;
    }

    @Override
    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof MTEHatchEnergy || this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterEnergyHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch aHatch = (MTEHatch)aMetaTileEntity;
            return this.mAllEnergyHatches.add(aHatch);
        }
        return false;
    }

    public int calculatePollutionReductionForHatch(MTEHatchMuffler hatch, int poll) {
        return hatch.calculatePollutionReduction(poll);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mVoidExcess")) {
            VoidingMode voidingMode = this.voidingMode = aNBT.func_74767_n("mVoidExcess") ? VoidingMode.VOID_ALL : VoidingMode.VOID_NONE;
        }
        if (aNBT.func_74764_b("mUseMultiparallelMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof MetaGeneratedTool) {
            int[] aOreID;
            for (int id : aOreID = OreDictionary.getOreIDs((ItemStack)tCurrentItem)) {
                if (!OreDictionary.getOreName((int)id).equals("craftingToolPlunger")) continue;
                return this.onPlungerRightClick(aPlayer, side, aX, aY, aZ);
            }
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    public boolean onPlungerRightClick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        int aHatchIndex = 0;
        GTUtility.sendChatToPlayer(aPlayer, "Trying to clear " + this.mOutputHatches.size() + " output hatches.");
        for (MTEHatchOutput hatch : this.mOutputHatches) {
            if (hatch.mFluid != null) {
                GTUtility.sendChatToPlayer(aPlayer, "Clearing " + hatch.mFluid.amount + "L of " + hatch.mFluid.getLocalizedName() + " from hatch " + aHatchIndex + ".");
                hatch.mFluid = null;
            }
            ++aHatchIndex;
        }
        return aHatchIndex > 0;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.supportsVoidProtection() && wrenchingSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            Set allowed = this.getAllowedVoidingModes();
            this.setVoidingMode(this.getVoidingMode().nextInCollection(allowed));
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode") + " " + StatCollector.func_74838_a((String)this.getVoidingMode().getTransKey()));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, aTool);
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheMeta, Function<T, Integer> aGetTheMeta, int maxMeta) {
        return GTPPMultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheMeta, 0, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheMeta, Function<T, Integer> aGetTheMeta, int minMeta, int maxMeta) {
        return GTPPMultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheMeta, minMeta, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(final Block aBlock, final BiPredicate<T, Integer> aSetTheMeta, final Function<T, Integer> aGetTheMeta, final int minMeta, final int maxMeta) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block tBlock = world.func_147439_a(x, y, z);
                if (aBlock == tBlock) {
                    Integer currentMeta = (Integer)aGetTheMeta.apply(t);
                    int newMeta = tBlock.func_149643_k(world, x, y, z) + 1;
                    if (newMeta > maxMeta || newMeta < minMeta + 1) {
                        return false;
                    }
                    if (currentMeta == 0) {
                        return aSetTheMeta.test(t, newMeta);
                    }
                    return currentMeta == newMeta;
                }
                return false;
            }

            public boolean couldBeValid(T t, World world, int x, int y, int z, ItemStack trigger) {
                Block tBlock = world.func_147439_a(x, y, z);
                if (aBlock == tBlock) {
                    int expectedMeta = this.getMeta(trigger);
                    int blockMeta = tBlock.func_149643_k(world, x, y, z) + 1;
                    if (blockMeta > maxMeta || blockMeta < minMeta + 1) {
                        return false;
                    }
                    return expectedMeta == blockMeta;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aBlock, (int)this.getMeta(trigger));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, aBlock, this.getMeta(trigger), 3);
            }

            private int getMeta(ItemStack trigger) {
                int meta = trigger.field_77994_a;
                if (meta <= 0) {
                    meta = minMeta;
                }
                if (meta + minMeta >= maxMeta) {
                    meta = maxMeta - 1 - minMeta;
                }
                return meta + minMeta;
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)aBlock, (int)this.getMeta(trigger));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (world.func_147439_a(x, y, z) == aBlock) {
                    if (world.func_72805_g(x, y, z) == this.getMeta(trigger)) {
                        return IStructureElement.PlaceResult.SKIP;
                    }
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock((Block)aBlock, (int)this.getMeta(trigger), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture casingTexture = this.getCasingTexture();
        if (side != facing) {
            return new ITexture[]{casingTexture};
        }
        int textures = 1;
        IIconContainer container = aActive ? this.getActiveOverlay() : this.getInactiveOverlay();
        ITexture overlay = null;
        if (container != null) {
            ++textures;
            overlay = TextureFactory.builder().addIcon(container).extFacing().build();
        }
        IIconContainer glowContainer = aActive ? this.getActiveGlowOverlay() : this.getInactiveGlowOverlay();
        ITexture glowOverlay = null;
        if (glowContainer != null) {
            ++textures;
            glowOverlay = TextureFactory.builder().addIcon(glowContainer).extFacing().glow().build();
        }
        ITexture[] retVal = new ITexture[textures];
        retVal[0] = this.getCasingTexture();
        if (overlay != null) {
            retVal[1] = overlay;
        }
        if (glowOverlay != null) {
            retVal[2] = glowOverlay;
        }
        return retVal;
    }

    protected IIconContainer getActiveOverlay() {
        return null;
    }

    protected IIconContainer getActiveGlowOverlay() {
        return null;
    }

    protected IIconContainer getInactiveOverlay() {
        return null;
    }

    protected IIconContainer getInactiveGlowOverlay() {
        return null;
    }

    protected ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureId());
    }

    protected int getCasingTextureId() {
        return 0;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.doesBindPlayerInventory()) {
            super.addUIWidgets(builder, buildContext);
        } else {
            this.addNoPlayerInventoryUI(builder, buildContext);
        }
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    protected void addNoPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(3, 4).setSize(152, 159));
        for (int i = 0; i < 9; ++i) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.BUTTON_STANDARD).setPos(155, 3 + i * 18).setSize(18, 18));
        }
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTextsNoPlayerInventory(screenElements);
        builder.widget((Widget)screenElements);
        this.setupToolDisplay();
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mWrench + "WRENCH")).asWidget().setPos(156, 58))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mCrowbar + "CROWBAR")).asWidget().setPos(156, 76))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mHardHammer + "HARDHAMMER")).asWidget().setPos(156, 94))).widget(new TextWidget("H").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(167, 103))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mSoftMallet + "SOFTMALLET")).asWidget().setPos(156, 112))).widget(new TextWidget("M").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(167, 121))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftMallet, val -> {
            this.mSoftMallet = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mScrewdriver + "SCREWDRIVER")).asWidget().setPos(156, 130))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.mSolderingTool + "SOLDERING_IRON_LV")).asWidget().setPos(156, 148))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemDrawable(() -> mToolStacks.get(this.getBaseMetaTileEntity().isActive() + "GLASS")).asWidget().setPos(156, 22))).widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().isActive() ? StatCollector.func_74838_a((String)"gtpp.gui.text.on") : StatCollector.func_74838_a((String)"gtpp.gui.text.off")).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(157, 31))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
    }

    protected void drawTextsNoPlayerInventory(DynamicPositionedColumn screenElements) {
        screenElements.setSynced(false).setSpace(0).setPos(6, 7);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.machines.input") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GTValues.VOLTAGE_NAMES[(int)this.getInputTier()]).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getInputTier() > 0L))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.machines.output") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GTValues.VOLTAGE_NAMES[(int)this.getOutputTier()]).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getOutputTier() > 0L))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.progress.text", (Object[])new Object[]{"" + EnumChatFormatting.GREEN + this.getBaseMetaTileEntity().getProgress() / 20 + EnumChatFormatting.RESET, "" + EnumChatFormatting.YELLOW + this.getBaseMetaTileEntity().getMaxProgress() / 20 + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> "" + EnumChatFormatting.GREEN + this.getStoredEnergyInAllEnergyHatches() + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + this.getMaxEnergyStorageOfAllEnergyHatches() + EnumChatFormatting.RESET + " EU").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() > 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.eu_t_p.text", (Object[])new Object[]{"" + EnumChatFormatting.RED + -this.getLastRecipeEU() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() > 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() < 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.eu_t_p.text", (Object[])new Object[]{"" + EnumChatFormatting.GREEN + this.getLastRecipeEU() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() < 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.duration.text", (Object[])new Object[]{"" + EnumChatFormatting.RED + this.getLastRecipeDuration() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() != 0 && this.getLastRecipeDuration() > 0))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.specialvalue") + ": " + EnumChatFormatting.RED + this.getLastRecipeEU() + EnumChatFormatting.RESET).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getLastRecipeEU() != 0 && this.getLastRecipeDuration() > 0 && (this.mLastRecipe != null ? this.mLastRecipe.mSpecialValue : 0) > 0))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.max_voltage.txt", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.multiblock.pollution.txt", (Object[])new Object[]{"" + EnumChatFormatting.RED + this.getPollutionPerSecond(null) + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(new TextWidget(StatCollector.func_74838_a((String)"gtpp.gui.text.time_since_built") + ": ").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.text.time.week", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.getRuntimeWeeksDisplay() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.text.time.days", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.getRuntimeDaysDisplay() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.text.time.hours", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.getRuntimeHoursDisplay() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.text.time.minutes", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.getRuntimeMinutesDisplay() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"gtpp.gui.text.time.seconds", (Object[])new Object[]{"" + EnumChatFormatting.DARK_GREEN + this.getRuntimeSecondsDisplay() + EnumChatFormatting.RESET})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
    }

    protected int getLastRecipeEU() {
        return this.mLastRecipe != null ? this.mLastRecipe.mEUt : 0;
    }

    protected int getLastRecipeDuration() {
        return this.mLastRecipe != null ? this.mLastRecipe.mDuration : 0;
    }

    protected long getRuntimeSeconds() {
        return this.getTotalRuntimeInTicks() / 20L;
    }

    protected long getRuntimeWeeksDisplay() {
        return TimeUnit.SECONDS.toDays(this.getRuntimeSeconds()) / 7L;
    }

    protected long getRuntimeDaysDisplay() {
        return TimeUnit.SECONDS.toDays(this.getRuntimeSeconds()) - 7L * this.getRuntimeWeeksDisplay();
    }

    protected long getRuntimeHoursDisplay() {
        return TimeUnit.SECONDS.toHours(this.getRuntimeSeconds()) - TimeUnit.DAYS.toHours(this.getRuntimeDaysDisplay()) - TimeUnit.DAYS.toHours(7L * this.getRuntimeWeeksDisplay());
    }

    protected long getRuntimeMinutesDisplay() {
        return TimeUnit.SECONDS.toMinutes(this.getRuntimeSeconds()) - TimeUnit.SECONDS.toHours(this.getRuntimeSeconds()) * 60L;
    }

    protected long getRuntimeSecondsDisplay() {
        return TimeUnit.SECONDS.toSeconds(this.getRuntimeSeconds()) - TimeUnit.SECONDS.toMinutes(this.getRuntimeSeconds()) * 60L;
    }

    protected void setupToolDisplay() {
        if (!mToolStacks.isEmpty()) {
            return;
        }
        mToolStacks.put("trueWRENCH", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueCROWBAR", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CROWBAR.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueHARDHAMMER", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSOFTMALLET", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOFTMALLET.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSCREWDRIVER", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("trueSOLDERING_IRON_LV", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOLDERING_IRON_LV.ID, 1, GOOD, Materials.Tungsten, null));
        mToolStacks.put("falseWRENCH", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH.ID, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseCROWBAR", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CROWBAR.ID, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseHARDHAMMER", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSOFTMALLET", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOFTMALLET.ID, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSCREWDRIVER", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER.ID, 1, BAD, Materials.Tungsten, null));
        mToolStacks.put("falseSOLDERING_IRON_LV", MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOLDERING_IRON_LV.ID, 1, BAD, Materials.Tungsten, null));
        ItemStack aGlassPane1 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassRed", 1);
        ItemStack aGlassPane2 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassLime", 1);
        mToolStacks.put("falseGLASS", aGlassPane1);
        mToolStacks.put("trueGLASS", aGlassPane2);
    }

    public static enum GTPPHatchElement implements IHatchElement<GTPPMultiBlockBase<?>>
    {
        AirIntake(GTPPMultiBlockBase::addAirIntakeToMachineList, new Class[]{METHatchAirIntake.class}){

            @Override
            public long count(GTPPMultiBlockBase<?> t) {
                return t.mAirIntakes.size();
            }
        }
        ,
        TTDynamo(GTPPMultiBlockBase::addMultiAmpDynamoToMachineList, new Class[]{MTEHatchDynamoMulti.class}){

            @Override
            public long count(GTPPMultiBlockBase<?> t) {
                return t.mTecTechDynamoHatches.size();
            }
        }
        ,
        TTEnergy(GTPPMultiBlockBase::addMultiAmpEnergyToMachineList, new Class[]{MTEHatchEnergyMulti.class}){

            @Override
            public long count(GTPPMultiBlockBase<?> t) {
                return t.mTecTechEnergyHatches.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mMteClasses;
        private final IGTHatchAdder<? super GTPPMultiBlockBase<?>> mAdder;

        @SafeVarargs
        private GTPPHatchElement(IGTHatchAdder<? super GTPPMultiBlockBase<?>> aAdder, Class<? extends IMetaTileEntity> ... aMteClasses) {
            this.mMteClasses = Arrays.asList(aMteClasses);
            this.mAdder = aAdder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mMteClasses;
        }

        @Override
        public IGTHatchAdder<? super GTPPMultiBlockBase<?>> adder() {
            return this.mAdder;
        }
    }
}

