/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.METHatchAirIntake;

public class MTEHatchAirIntakeAtmosphere
extends METHatchAirIntake {
    public MTEHatchAirIntakeAtmosphere(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchAirIntakeAtmosphere(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public String[] getCustomTooltip() {
        String[] aTooltip = new String[]{"DO NOT OBSTRUCT THE INPUT!", "Draws in Air from the surrounding environment", "Completelly fills up every " + this.getMaxTickTime() + " ticks"};
        return aTooltip;
    }

    @Override
    public synchronized String[] getDescription() {
        this.mDescriptionArray[1] = "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L";
        String[] hatchTierString = new String[]{"Hatch Tier: " + GTUtility.getColoredTierNameFromTier(this.mTier)};
        String[] aCustomTips = this.getCustomTooltip();
        String[] desc = new String[this.mDescriptionArray.length + aCustomTips.length + 2];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        System.arraycopy(hatchTierString, 0, desc, this.mDescriptionArray.length, 1);
        System.arraycopy(aCustomTips, 0, desc, this.mDescriptionArray.length + 1, aCustomTips.length);
        return desc;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchAirIntakeAtmosphere(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int getAmountOfFluidToGenerate() {
        return 2000000000;
    }

    @Override
    public int getCapacity() {
        return 2000000000;
    }
}

