/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import cpw.mods.fml.common.Optional;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.plugin.agrichem.BioRecipes;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeLoaderAgriculturalChem {
    private static final ArrayList<ItemStack> mMeats = new ArrayList();
    private static final ArrayList<ItemStack> mFish = new ArrayList();
    private static final ArrayList<ItemStack> mFruits = new ArrayList();
    private static final ArrayList<ItemStack> mVege = new ArrayList();
    private static final ArrayList<ItemStack> mNuts = new ArrayList();
    private static final ArrayList<ItemStack> mSeeds = new ArrayList();
    private static final ArrayList<ItemStack> mPeat = new ArrayList();
    private static final ArrayList<ItemStack> mBones = new ArrayList();
    private static final ArrayList<ItemStack> mBoneMeal = new ArrayList();
    private static final ArrayList<ItemStack> mList_Master_Meats = new ArrayList();
    private static final ArrayList<ItemStack> mList_Master_FruitVege = new ArrayList();
    private static final ArrayList<ItemStack> mList_Master_Bones = new ArrayList();
    private static final ArrayList<ItemStack> mList_Master_Seeds = new ArrayList();

    public static void generate() {
        RecipeLoaderAgriculturalChem.processAllOreDict();
        RecipeLoaderAgriculturalChem.addBasicSlurryRecipes();
        RecipeLoaderAgriculturalChem.addAdvancedSlurryRecipes();
        RecipeLoaderAgriculturalChem.addBasicOrganiseFertRecipes();
        RecipeLoaderAgriculturalChem.addAdvancedOrganiseFertRecipes();
        RecipeLoaderAgriculturalChem.recipeFermentationBase();
        RecipeLoaderAgriculturalChem.addMiscRecipes();
        BioRecipes.init();
    }

    private static void processAllOreDict() {
        boolean foundDupe;
        RecipeLoaderAgriculturalChem.processOreDict("listAllmeatraw", mMeats);
        RecipeLoaderAgriculturalChem.processOreDict("listAllfishraw", mFish);
        RecipeLoaderAgriculturalChem.processOreDict("listAllfruit", mFruits);
        RecipeLoaderAgriculturalChem.processOreDict("listAllVeggie", mVege);
        RecipeLoaderAgriculturalChem.processOreDict("listAllnut", mNuts);
        RecipeLoaderAgriculturalChem.processOreDict("listAllSeed", mSeeds);
        RecipeLoaderAgriculturalChem.processOreDict("brickPeat", mPeat);
        RecipeLoaderAgriculturalChem.processOreDict("bone", mBones);
        RecipeLoaderAgriculturalChem.processOreDict("dustBone", mBoneMeal);
        if (!mMeats.isEmpty()) {
            mList_Master_Meats.addAll(mMeats);
        }
        if (!mFish.isEmpty()) {
            for (ItemStack g : mFish) {
                foundDupe = false;
                for (ItemStack old : mList_Master_Meats) {
                    if (!GTUtility.areStacksEqual(g, old)) continue;
                    foundDupe = true;
                    break;
                }
                if (foundDupe) continue;
                mList_Master_Meats.add(g);
            }
        }
        if (!mFruits.isEmpty()) {
            mList_Master_FruitVege.addAll(mFruits);
        }
        if (!mVege.isEmpty()) {
            mList_Master_FruitVege.addAll(mVege);
        }
        if (!mNuts.isEmpty()) {
            mList_Master_FruitVege.addAll(mNuts);
        }
        if (!mBoneMeal.isEmpty()) {
            mList_Master_Bones.addAll(mBoneMeal);
        }
        if (!mSeeds.isEmpty()) {
            mList_Master_Seeds.addAll(mSeeds);
        }
        if (!mBones.isEmpty()) {
            for (ItemStack g : mBones) {
                foundDupe = false;
                for (ItemStack old : mList_Master_Bones) {
                    if (!GTUtility.areStacksEqual(g, old)) continue;
                    foundDupe = true;
                    break;
                }
                if (foundDupe) continue;
                mList_Master_Bones.add(g);
            }
        }
    }

    private static void processOreDict(String aOreName, ArrayList<ItemStack> aMap) {
        ArrayList aTemp = OreDictionary.getOres((String)aOreName);
        if (!aTemp.isEmpty()) {
            aMap.addAll(aTemp);
        }
    }

    private static void addBasicSlurryRecipes() {
        ItemStack aManureByprod1 = GregtechItemList.TinyManureByproductsDust.get(1L, new Object[0]);
        ItemStack aManureByprod2 = GregtechItemList.SmallManureByproductsDust.get(1L, new Object[0]);
        ItemStack aDirtDust = GregtechItemList.DriedEarthDust.get(1L, new Object[0]);
        GTValues.RA.stdBuilder().itemOutputs(aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod1, aManureByprod1).outputChances(2000, 2000, 500, 500, 250, 250).fluidInputs(new FluidStack(GTPPFluids.PoopJuice, 1000)).fluidOutputs(new FluidStack(GTPPFluids.ManureSlurry, 250)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20)).itemOutputs(aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod2, aManureByprod2).outputChances(4000, 3000, 1250, 1250, 675, 675).fluidInputs(new FluidStack(GTPPFluids.PoopJuice, 1000)).fluidOutputs(new FluidStack(GTPPFluids.ManureSlurry, 50)).duration(400).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.centrifugeRecipes);
    }

    private static void addAdvancedSlurryRecipes() {
        ItemStack aCircuit = GTUtility.getIntegratedCircuit(10);
        ItemStack aEmptyCells = Materials.Empty.getCells(2);
        ItemStack aInputCells = ItemUtils.getItemStackOfAmountFromOreDict("cellRawAnimalWaste", 2);
        FluidStack aOutput = new FluidStack(GTPPFluids.FertileManureSlurry, 1000);
        for (FluidStack aBloodStack : GTPPFluids.getBloodFluids()) {
            for (ItemStack aBoneStack : mList_Master_Bones) {
                ItemStack aBone = GTUtility.copyAmount(2, aBoneStack);
                for (ItemStack aMeatStack : mList_Master_Meats) {
                    ItemStack aMeat = GTUtility.copyAmount(5, aMeatStack);
                    GTValues.RA.stdBuilder().itemInputs(aCircuit, aBone, aMeat, aInputCells).itemOutputs(aEmptyCells).fluidInputs(aBloodStack).fluidOutputs(aOutput).duration(160).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.mixerRecipes);
                }
            }
        }
    }

    private static void addBasicOrganiseFertRecipes() {
        FluidStack aInputFluid = new FluidStack(GTPPFluids.ManureSlurry, 1000);
        ItemStack aOutputDust = GregtechItemList.OrganicFertilizerDust.get(3L, new Object[0]);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = GTUtility.copyAmount(3, aPeatStack);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = GTUtility.copyAmount(5, aMeatStack);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(400).eut(TierEU.RECIPE_MV).addTo(GTRecipeConstants.UniversalChemical);
            }
            aPeat = GTUtility.copyAmount(2, aPeatStack);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = GTUtility.copyAmount(9, aMeatStack);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(200).eut(TierEU.RECIPE_MV).addTo(GTRecipeConstants.UniversalChemical);
            }
        }
    }

    private static void addAdvancedOrganiseFertRecipes() {
        FluidStack aInputFluid = new FluidStack(GTPPFluids.FertileManureSlurry, 1000);
        ItemStack aOutputDust = GregtechItemList.OrganicFertilizerDust.get(7L, new Object[0]);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = GTUtility.copyAmount(5, aPeatStack);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = GTUtility.copyAmount(7, aMeatStack);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(200).eut(140).addTo(GTRecipeConstants.UniversalChemical);
            }
            aPeat = GTUtility.copyAmount(3, aPeatStack);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = GTUtility.copyAmount(12, aMeatStack);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(100).eut(140).addTo(GTRecipeConstants.UniversalChemical);
            }
        }
    }

    private static void recipeFermentationBase() {
        ArrayList aMap = OreDictionary.getOres((String)"cropSugarbeet");
        for (ItemStack a : mList_Master_FruitVege) {
            if (aMap.contains(a) || a == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2), GTUtility.copyAmount(10, a)).fluidInputs(GTModHandler.getDistilledWater(1000L)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 1000)).duration(600).eut(2).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        for (ItemStack a : mList_Master_Seeds) {
            if (a == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), GTUtility.copyAmount(20, a)).fluidInputs(GTModHandler.getDistilledWater(1000L)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 1000)).duration(600).eut(2).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4), new ItemStack(Items.field_151120_aE, 32)).fluidInputs(GTModHandler.getDistilledWater(1000L)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 1000)).duration(600).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(5), new ItemStack(Items.field_151120_aE, 32), new ItemStack(ModItems.dustCalciumCarbonate, 2)).fluidInputs(FluidUtils.getHotWater(2000)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 2000)).duration(200).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        if (!GTOreDictUnificator.getOres("cropSugarbeet").isEmpty()) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4), GTOreDictUnificator.get("cropSugarbeet", 4L)).fluidInputs(GTModHandler.getDistilledWater(1000L)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 1000)).duration(600).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(5), GTOreDictUnificator.get("cropSugarbeet", 4L), new ItemStack(ModItems.dustCalciumCarbonate, 2)).fluidInputs(FluidUtils.getHotWater(2000)).fluidOutputs(new FluidStack(GTPPFluids.FermentationBase, 2000)).duration(200).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(5), GregtechItemList.GoldenBrownCelluloseFiber.get(6L, new Object[0]), GregtechItemList.RedCelluloseFiber.get(16L, new Object[0])).fluidInputs(new FluidStack(GTPPFluids.FermentationBase, 48000)).fluidOutputs(new FluidStack(GTPPFluids.Butanol, 18000), Materials.Acetone.getFluid(9000L), Materials.Ethanol.getFluid(3000L)).duration(2000).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void addMiscRecipes() {
        if (Mods.Forestry.isModLoaded()) {
            RecipeLoaderAgriculturalChem.addMiscForestryRecipes();
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(12), GregtechItemList.OrganicFertilizerDust.get(4L, new Object[0])).itemOutputs(ItemList.IC2_Fertilizer.get(3L, new Object[0]), GregtechItemList.ManureByproductsDust.get(1L, new Object[0]), GregtechItemList.ManureByproductsDust.get(1L, new Object[0])).outputChances(10000, 2000, 2000).eut(240).duration(400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.DriedEarthDust.get(9L, new Object[0])).itemOutputs(new ItemStack(Blocks.field_150346_d)).duration(40).eut(8).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GregtechItemList.ManureByproductsDust.get(4L, new Object[0]), GTUtility.getIntegratedCircuit(20)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Phosphorus, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Calcium, 2L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Copper, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Carbon, 1L), GregtechItemList.DriedEarthDust.get(1L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAmmoniumNitrate", 1)).outputChances(2500, 2500, 750, 1000, 5000, 250).fluidInputs(Materials.SulfuricAcid.getFluid(250L)).fluidOutputs(FluidUtils.getFluidStack("sulfuricapatite", 50)).duration(400).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.PoopJuice, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 12).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.ManureSlurry, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 24).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(GTPPFluids.FertileManureSlurry, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 32).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Iron, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Copper, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Tin, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Sulfur, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Nickel, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lead, 1L)).outputChances(3000, 3000, 2000, 2000, 1000, 1000).fluidInputs(new FluidStack(GTPPFluids.RedMud, 1000)).fluidOutputs(Materials.Water.getFluid(500L)).duration(600).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
    }

    @Optional.Method(modid="Forestry")
    private static void addMiscForestryRecipes() {
        if (ItemList.FR_Fertilizer.hasBeenSet()) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), GregtechItemList.OrganicFertilizerDust.get(4L, new Object[0])).itemOutputs(ItemList.FR_Fertilizer.get(3L, new Object[0]), GregtechItemList.ManureByproductsDust.get(1L, new Object[0]), GregtechItemList.ManureByproductsDust.get(1L, new Object[0])).outputChances(10000, 2000, 2000).eut(240).duration(400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
    }
}

