/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.FishPondRecipes;
import gregtech.api.util.SemiFluidFuelHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.common.CommonProxy;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.handler.BookHandler;
import gtPlusPlus.core.handler.PacketHandler;
import gtPlusPlus.core.handler.Recipes.RegistrationHandler;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.data.LocaleUtils;
import gtPlusPlus.plugin.fixes.vanilla.VanillaBedHeightFix;
import gtPlusPlus.xmod.gregtech.common.MetaGTProxy;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtTools;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBlastSmelterGTNH;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenMultisUsingFluidInsteadOfCells;
import gtPlusPlus.xmod.thaumcraft.commands.CommandDumpAspects;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="miscutils", name="GT++", version="5.09.51.389", guiFactory="gtPlusPlus.core.gui.config.GTPPGuiFactory", dependencies="required-after:Forge; after:TConstruct; after:dreamcraft; after:IC2; required-after:gregtech; after:Forestry; after:MagicBees; after:CoFHCore; after:Railcraft; after:CompactWindmills; after:ForbiddenMagic; after:ExtraUtilities; after:Thaumcraft; after:EnderIO; after:tectech; after:OpenBlocks; after:IC2NuclearControl; after:TGregworks; after:StevesCarts; required-after:gtnhlib@[0.0.10,);")
public class GTplusplus {
    public static INIT_PHASE CURRENT_LOAD_PHASE;
    @Mod.Instance(value="miscutils")
    public static GTplusplus instance;
    @SidedProxy(clientSide="gtPlusPlus.core.proxy.ClientProxy", serverSide="gtPlusPlus.core.common.CommonProxy")
    public static CommonProxy proxy;

    @SideOnly(value=Side.CLIENT)
    public static void loadTextures() {
        Logger.INFO("Loading some textures on the client.");
        Logger.WARNING("Processing texture: " + TexturesGtTools.ANGLE_GRINDER.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtTools.ELECTRIC_SNIPS.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtBlock.Casing_Machine_Dimensional.getTextureFile().func_110623_a());
    }

    public GTplusplus() {
        INIT_PHASE.SUPER.setPhaseActive(true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INIT_PHASE.PRE_INIT.setPhaseActive(true);
        PacketHandler.init();
        GTplusplus.setupMaterialBlacklist();
        GTPPCore.DEVENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        proxy.preInit(event);
        Logger.INFO("Setting up our own GTProxy.");
        MetaGTProxy.preInit();
        GTplusplus.fixVanillaOreDict();
        new VanillaBedHeightFix();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        INIT_PHASE.INIT.setPhaseActive(true);
        proxy.init(event);
        proxy.registerNetworkStuff();
        MetaGTProxy.init();
        if (Configuration.debug.dumpItemAndBlockData) {
            LocaleUtils.generateFakeLocaleFile();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        INIT_PHASE.POST_INIT.setPhaseActive(true);
        proxy.postInit(event);
        BookHandler.runLater();
        MetaGTProxy.postInit();
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("| Recipes succesfully Loaded: " + RegistrationHandler.recipesSuccess + " | Failed: " + RegistrationHandler.recipesFailed + " |");
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("Finally, we are finished. Have some cripsy bacon as a reward.");
        if (GTPPCore.DEVENV) {
            int i;
            for (i = 750; i < 1000; ++i) {
                if (GregTechAPI.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
            for (i = 30000; i < 32000; ++i) {
                if (GregTechAPI.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
        }
    }

    @Mod.EventHandler
    public synchronized void serverStarting(FMLServerStartingEvent event) {
        INIT_PHASE.SERVER_START.setPhaseActive(true);
        if (Mods.Thaumcraft.isModLoaded()) {
            event.registerServerCommand((ICommand)new CommandDumpAspects());
        }
        INIT_PHASE.STARTED.setPhaseActive(true);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        proxy.onLoadComplete(event);
        this.generateGregtechRecipeMaps();
    }

    protected void generateGregtechRecipeMaps() {
        RecipeGenBlastSmelterGTNH.generateGTNHBlastSmelterRecipesFromEBFList();
        FishPondRecipes.generateFishPondRecipes();
        SemiFluidFuelHandler.generateFuels();
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.centrifugeRecipes, GTPPRecipeMaps.centrifugeNonCellRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.electrolyzerRecipes, GTPPRecipeMaps.electrolyzerNonCellRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.vacuumFreezerRecipes, GTPPRecipeMaps.advancedFreezerRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.mixerRecipes, GTPPRecipeMaps.mixerNonCellRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.chemicalDehydratorRecipes, GTPPRecipeMaps.chemicalDehydratorNonCellRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.coldTrapRecipes, GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes);
        RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.reactorProcessingUnitRecipes, GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes);
    }

    private static void setupMaterialBlacklist() {
        Material.invalidMaterials.add(Materials._NULL);
        Material.invalidMaterials.add(Materials.Clay);
        Material.invalidMaterials.add(Materials.Phosphorus);
        Material.invalidMaterials.add(Materials.Steel);
        Material.invalidMaterials.add(Materials.Bronze);
        Material.invalidMaterials.add(Materials.Hydrogen);
        Material.invalidMaterials.add(Materials.InfusedAir);
        Material.invalidMaterials.add(Materials.InfusedEarth);
        Material.invalidMaterials.add(Materials.InfusedFire);
        Material.invalidMaterials.add(Materials.InfusedWater);
        Material.invalidMaterials.add(Materials.SoulSand);
        Material.invalidMaterials.add(Materials.EnderPearl);
        Material.invalidMaterials.add(Materials.EnderEye);
        Material.invalidMaterials.add(Materials.Redstone);
        Material.invalidMaterials.add(Materials.Glowstone);
        Material.invalidMaterials.add(Materials.Soularium);
        Material.invalidMaterials.add(Materials.PhasedIron);
    }

    private static void fixVanillaOreDict() {
        OreDictionary.registerOre((String)"rodBlaze", (ItemStack)new ItemStack(Items.field_151072_bj));
        OreDictionary.registerOre((String)"cropNetherWart", (ItemStack)new ItemStack(Items.field_151075_bm));
        OreDictionary.registerOre((String)"sugarcane", (ItemStack)new ItemStack(Items.field_151120_aE));
        OreDictionary.registerOre((String)"paper", (ItemStack)new ItemStack(Items.field_151121_aF));
        OreDictionary.registerOre((String)"enderpearl", (ItemStack)new ItemStack(Items.field_151079_bi));
        OreDictionary.registerOre((String)"bone", (ItemStack)new ItemStack(Items.field_151103_aS));
        OreDictionary.registerOre((String)"gunpowder", (ItemStack)new ItemStack(Items.field_151016_H));
        OreDictionary.registerOre((String)"string", (ItemStack)new ItemStack(Items.field_151007_F));
        OreDictionary.registerOre((String)"netherStar", (ItemStack)new ItemStack(Items.field_151156_bN));
        OreDictionary.registerOre((String)"leather", (ItemStack)new ItemStack(Items.field_151116_aA));
        OreDictionary.registerOre((String)"feather", (ItemStack)new ItemStack(Items.field_151008_G));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(Items.field_151110_aK));
        OreDictionary.registerOre((String)"endstone", (ItemStack)new ItemStack(Blocks.field_150377_bs));
        OreDictionary.registerOre((String)"vine", (ItemStack)new ItemStack(Blocks.field_150395_bd));
        OreDictionary.registerOre((String)"blockCactus", (ItemStack)new ItemStack(Blocks.field_150434_aF));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack((Block)Blocks.field_150349_c));
        OreDictionary.registerOre((String)"obsidian", (ItemStack)new ItemStack(Blocks.field_150343_Z));
        OreDictionary.registerOre((String)"workbench", (ItemStack)new ItemStack(Blocks.field_150462_ai));
    }

    static {
        try {
            ConfigurationManager.registerConfig(Configuration.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        CURRENT_LOAD_PHASE = INIT_PHASE.SUPER;
    }

    public static enum INIT_PHASE {
        SUPER(null),
        PRE_INIT(SUPER),
        INIT(PRE_INIT),
        POST_INIT(INIT),
        SERVER_START(POST_INIT),
        STARTED(SERVER_START);

        private boolean mIsPhaseActive = false;
        private final INIT_PHASE mPrev;

        private INIT_PHASE(INIT_PHASE aPreviousPhase) {
            this.mPrev = aPreviousPhase;
        }

        public final synchronized boolean isPhaseActive() {
            return this.mIsPhaseActive;
        }

        public final synchronized void setPhaseActive(boolean aIsPhaseActive) {
            if (this.mPrev != null && this.mPrev.isPhaseActive()) {
                this.mPrev.setPhaseActive(false);
            }
            this.mIsPhaseActive = aIsPhaseActive;
            if (CURRENT_LOAD_PHASE != this) {
                CURRENT_LOAD_PHASE = this;
            }
        }
    }
}

