/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEPurificationUnitClarifier
extends MTEPurificationUnitBase<MTEPurificationUnitClarifier>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "main_survival";
    private static final int STRUCTURE_X_OFFSET = 5;
    private static final int STRUCTURE_Y_OFFSET = 2;
    private static final int STRUCTURE_Z_OFFSET = 1;
    public static final float FILTER_DAMAGE_RATE = 20.0f;
    private static final int CASING_TEXTURE_INDEX = MTEPurificationUnitClarifier.getTextureIndex(GregTechAPI.sBlockCasings9, 5);
    private static final String[][] structure = new String[][]{{"           ", "           ", "           ", "           "}, {"           ", "   AAAAA   ", "   AH~HA   ", "   AAAAA   "}, {"           ", "  A     A  ", "  AWWWWWA  ", "  AAAAAAA  "}, {"           ", " A       A ", " AWWWWWWWA ", " AAAAAAAAA "}, {"           ", "A         A", "AWWWCCCWWWA", "AAAAFFFAAAA"}, {"    DDD    ", "A         A", "HWWCWWWCWWH", "AAAFFFFFAAA"}, {"DDDDDBD    ", "A    B    A", "AWWCWBWCWWA", "AAAFFFFFAAA"}, {"    DDD    ", "A         A", "HWWCWWWCWWH", "AAAFFFFFAAA"}, {"           ", "A         A", "AWWWCCCWWWA", "AAAAFFFAAAA"}, {"           ", " A       A ", " AWWWWWWWA ", " AAAAAAAAA "}, {"           ", "  A     A  ", "  AWWWWWA  ", "  AAAAAAA  "}, {"           ", "   AAAAA   ", "   AHAHA   ", "   AAAAA   "}};
    private static final IStructureDefinition<MTEPurificationUnitClarifier> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addShape("main_survival", (String[][])Arrays.stream(structure).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("W", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).casingIndex(CASING_TEXTURE_INDEX).dot(1).build()), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('C', GTStructureUtility.ofFrame(Materials.Iridium)).addElement('D', GTStructureUtility.ofFrame(Materials.DamascusSteel)).addElement('W', GTStructureUtility.ofAnyWater(false)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)11)).build();

    public MTEPurificationUnitClarifier(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitClarifier(String aName) {
        super(aName);
    }

    @Override
    public int getWaterTier() {
        return 1;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_LuV;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationClarifierRecipes;
    }

    @Override
    @NotNull
    public CheckRecipeResult overrideRecipeCheck() {
        return this.findRecipeForInputs(this.storedFluids.toArray(new FluidStack[0]), this.getStoredInputs().toArray(new ItemStack[0]));
    }

    @Override
    public void depleteRecipeInputs() {
        super.depleteRecipeInputs();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int roll = random.nextInt(1, 101);
        if ((float)roll < 20.0f) {
            this.depleteInput(this.currentRecipe.mInputs[0]);
        }
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitClarifier> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("Requires a filter made of Activated Carbon to work.").addInfo("Every cycle, has a " + EnumChatFormatting.RED + GTUtility.formatNumbers(20.0) + "%" + EnumChatFormatting.GRAY + " chance to destroy the filter.").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The first step to acquiring purified water is to filter out macroscopic contaminants through the").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "use of large physical filters. As more contaminants are captured, the efficacy of the filter").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "decreases so continual replacements must be supplied to maintain full function of the Clarifier.").beginStructureBlock(11, 4, 11, false).addController("Front center").addCasingInfoRangeColored("Reinforced Sterile Water Plant Casing", EnumChatFormatting.GRAY, 123, 131, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Filter Machine Casing", EnumChatFormatting.GRAY, 21, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Iridium Frame Box", EnumChatFormatting.GRAY, 12, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Damascus Steel Frame Box", EnumChatFormatting.GRAY, 12, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("PTFE Pipe Casing", EnumChatFormatting.GRAY, 3, EnumChatFormatting.GOLD, false).addInputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addStructureInfo("Requires water to be placed in the structure.").toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 2, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 5, 2, 1, elementBudget, env, true);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GREEN + "Auto placing done ! Now go place the water yourself !");
            return 0;
        }
        return built;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitClarifier(this.mName);
    }

    private List<IHatchElement<? super MTEPurificationUnitClarifier>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputBus, (Object)HatchElement.InputHatch, (Object)HatchElement.OutputBus, (Object)HatchElement.OutputHatch);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_TEXTURE_INDEX), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_TEXTURE_INDEX), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_TEXTURE_INDEX)};
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 2, 1)) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_PURIFICATIONPLANT_LOOP;
    }
}

