/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.metadata.SolarFactoryRecipeDataKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.recipe.SolarFactoryRecipeData;
import gregtech.common.misc.GTStructureChannels;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESolarFactory
extends MTEExtendedPowerMultiBlockBase<MTESolarFactory>
implements IConstructable,
ISurvivalConstructable {
    private static final int CASING_T1_INDEX = 49;
    private static final int CASING_T2_INDEX = 48;
    private static final int CASING_T3_INDEX = 183;
    int mTier;
    int casingAmount;
    int casingTier;
    boolean hasEnoughCasings;
    int outputMultiplierCap = 2;
    double outputMultiplierSlope;
    public static ImmutableList<Pair<ItemStack, Integer>> validWafers = ImmutableList.of((Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer.get(1L, new Object[0]), (Object)1), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer2.get(1L, new Object[0]), (Object)2), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer3.get(1L, new Object[0]), (Object)3), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer4.get(1L, new Object[0]), (Object)4), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer5.get(1L, new Object[0]), (Object)5), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer6.get(1L, new Object[0]), (Object)6), (Object)Pair.of((Object)ItemList.Circuit_Silicon_Wafer7.get(1L, new Object[0]), (Object)7));
    private static final String STRUCTURE_TIER_1 = "t1";
    private static final String STRUCTURE_TIER_2 = "t2";
    private static final String STRUCTURE_TIER_3 = "t3";
    private static final IStructureDefinition<MTESolarFactory> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("t1", StructureUtility.transpose((String[][])new String[][]{{"EAAAE", "AAAAA", "AAAAA", "AAAAA", "EAAAE"}, {"E   E", " GGG ", " G G ", " GGG ", "E   E"}, {"E   E", " GGG ", " G G ", " GGG ", "E   E"}, {"E   E", " GGG ", " G G ", " GGG ", "E   E"}, {"EA~AE", "AAAAA", "AAAAA", "AAAAA", "EAAAE"}})).addShape("t2", StructureUtility.transpose((String[][])new String[][]{{" F     F ", "FFF   FFF", " FFF FFF ", "  FBBBF  ", "  FBBBF  ", " FFFFFFF ", "FFF   FFF", " F     F "}, {"BBB   BBB", "BBB   BBB", "BB     BB", "   BBB   ", "   BBB   ", "BB     BB", "BBB   BBB", "BBB   BBB"}, {"BF     FB", "FBGGGGGBF", " GGGGGGG ", " GGGGGGG ", " GGGGGGG ", " GGGGGGG ", "FBGGGGGBF", "BF     FB"}, {"BF     FB", "FBGGGGGBF", " G     G ", " G     G ", " G     G ", " G     G ", "FBGGGGGBF", "BF     FB"}, {"BF     FB", "FBGGGGGBF", " G     G ", " G     G ", " G     G ", " G     G ", "FBGGGGGBF", "BF     FB"}, {"BBBB~BBBB", "BBFFFFFBB", "BFPPPPPFB", "BFPPPPPFB", "BFPPPPPFB", "BFPPPPPFB", "BBFFFFFBB", "BBBBBBBBB"}})).addShape("t3", StructureUtility.transpose((String[][])new String[][]{{"   CCC   ", "  CCPCC  ", " CCPPPCC ", "CCPPPPPCC", " CCPPPCC ", "  CCPCC  ", "   CCC   "}, {"   GGG   ", "  C   C  ", " G     G ", "C       C", " G     G ", "  C   C  ", "   GGG   "}, {"   CCC   ", "  CCCCC  ", " CCCCCCC ", "CCCCHCCCC", " CCCCCCC ", "  CCCCC  ", "   CCC   "}, {"         ", "  FGGGF  ", "  G   G  ", "F G H G F", "  G   G  ", "  FGGGF  ", "         "}, {"         ", "  FGGGF  ", "  G   G  ", "F G H G F", "  G   G  ", "  FGGGF  ", "         "}, {"         ", "  FGGGF  ", "  G   G  ", "F G H G F", "  G   G  ", "  FGGGF  ", "         "}, {"         ", "  FGGGF  ", "  G   G  ", "F G H G F", "  G   G  ", "  FGGGF  ", "         "}, {"   CCC   ", "  CCCCC  ", " CCCCCCC ", "CCCCHCCCC", " CCCCCCC ", "  CCCCC  ", "   CCC   "}, {"   G~G   ", "  C   C  ", " G     G ", "C       C", " G     G ", "  C   C  ", "   GGG   "}, {"   CCC   ", "  CCPCC  ", " CCPPPCC ", "CCPPPPPCC", " CCPPPCC ", "  CCPCC  ", "   CCC   "}})).addElement('A', GTStructureUtility.buildHatchAdder(MTESolarFactory.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(49).dot(1).buildAndChain(StructureUtility.onElementPass(MTESolarFactory::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)))).addElement('B', GTStructureUtility.buildHatchAdder(MTESolarFactory.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.MultiAmpEnergy).casingIndex(48).dot(1).buildAndChain(StructureUtility.onElementPass(MTESolarFactory::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0)))).addElement('C', GTStructureUtility.buildHatchAdder(MTESolarFactory.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.MultiAmpEnergy, HatchElement.ExoticEnergy).casingIndex(183).dot(1).buildAndChain(StructureUtility.onElementPass(MTESolarFactory::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)))).addElement('E', GTStructureUtility.ofFrame(Materials.DamascusSteel)).addElement('F', GTStructureUtility.ofFrame(Materials.Tungsten)).addElement('G', GTStructureUtility.chainAllGlasses()).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings11, (int)7)).addElement('P', GTStructureChannels.PRASS_UNIT_CASING.use(StructureUtility.ofBlocksTiered((block, meta) -> block == Loaders.preciseUnitCasing ? Integer.valueOf(meta) : null, (List)ImmutableList.of((Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)0), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)1), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)2), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)3)), (Object)-3, MTESolarFactory::setCasingTier, MTESolarFactory::getCasingTier))).build();

    public MTESolarFactory(String aName) {
        super(aName);
    }

    public MTESolarFactory(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESolarFactory(this.mName);
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    private void onCasingAdded() {
        ++this.casingAmount;
    }

    @Override
    public IStructureDefinition<MTESolarFactory> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.casingTier = aNBT.func_74762_e("casingTier");
        this.mTier = aNBT.func_74762_e("multiTier");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("casingTier", this.casingTier);
        aNBT.func_74768_a("multiTier", this.mTier);
        super.saveNBTData(aNBT);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        this.hasEnoughCasings = false;
        this.casingTier = -3;
        this.mTier = 0;
        if (this.checkPiece(STRUCTURE_TIER_1, 2, 4, 0)) {
            this.mTier = 1;
            this.hasEnoughCasings = this.casingAmount >= 15;
        } else if (this.checkPiece(STRUCTURE_TIER_2, 4, 5, 0)) {
            this.mTier = 2;
            this.hasEnoughCasings = this.casingAmount >= 35;
        } else if (this.checkPiece(STRUCTURE_TIER_3, 4, 8, 0)) {
            this.mTier = 3;
            this.hasEnoughCasings = this.casingAmount >= 50;
        }
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
        return this.mTier > 0 && this.hasEnoughCasings && (this.mTier == 1 || this.casingTier >= -1);
    }

    public void construct(ItemStack holoStack, boolean hintsOnly) {
        if (holoStack.field_77994_a == 1) {
            this.buildPiece(STRUCTURE_TIER_1, holoStack, hintsOnly, 2, 4, 0);
        }
        if (holoStack.field_77994_a == 2) {
            this.buildPiece(STRUCTURE_TIER_2, holoStack, hintsOnly, 4, 5, 0);
        }
        if (holoStack.field_77994_a >= 3) {
            this.buildPiece(STRUCTURE_TIER_3, holoStack, hintsOnly, 4, 8, 0);
        }
    }

    public int survivalConstruct(ItemStack holoStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        if (holoStack.field_77994_a == 1) {
            return this.survivalBuildPiece(STRUCTURE_TIER_1, holoStack, 2, 4, 0, elementBudget, env, false, true);
        }
        if (holoStack.field_77994_a == 2) {
            return this.survivalBuildPiece(STRUCTURE_TIER_2, holoStack, 4, 5, 0, elementBudget, env, false, true);
        }
        if (holoStack.field_77994_a >= 3) {
            return this.survivalBuildPiece(STRUCTURE_TIER_3, holoStack, 4, 8, 0, elementBudget, env, false, true);
        }
        return 0;
    }

    protected ItemStack[] calculateNewOutput(ItemStack currentOutput, int seed) {
        this.outputMultiplierSlope = this.mTier >= 3 ? 0.5 : 0.25;
        double calculatedMultiplier = Math.min(this.outputMultiplierSlope * (double)seed + 1.0, (double)this.outputMultiplierCap);
        int outputSize = (int)Math.floor((double)currentOutput.field_77994_a * calculatedMultiplier);
        return new ItemStack[]{GTUtility.copyAmountUnsafe(outputSize, currentOutput)};
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            ItemStack foundWaferStack;
            int waferAmountInRecipe;
            int foundWaferTier;
            int minimumTierForRecipe;
            boolean shouldMultiplyOutputs = true;

            private void findWaferStack() {
                block0: for (ItemStack items : this.inputItems) {
                    for (Pair pair : validWafers) {
                        if (!items.func_77969_a((ItemStack)pair.getLeft())) continue;
                        this.foundWaferStack = items;
                        this.foundWaferTier = (Integer)pair.getRight();
                        continue block0;
                    }
                }
            }

            private void clearVars() {
                this.foundWaferStack = null;
                this.waferAmountInRecipe = 0;
                this.foundWaferTier = 0;
                this.minimumTierForRecipe = 0;
                this.shouldMultiplyOutputs = true;
            }

            @Override
            @NotNull
            protected CheckRecipeResult applyRecipe(@NotNull GTRecipe recipe, @NotNull ParallelHelper helper, @NotNull OverclockCalculator calculator, @NotNull CheckRecipeResult result) {
                result = super.applyRecipe(recipe, helper, calculator, result);
                if (this.shouldMultiplyOutputs) {
                    this.outputItems = MTESolarFactory.this.calculateNewOutput(this.outputItems[0], this.foundWaferTier - this.minimumTierForRecipe);
                }
                this.clearVars();
                return result;
            }

            @Override
            @NotNull
            public CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                SolarFactoryRecipeData data = recipe.getMetadata(SolarFactoryRecipeDataKey.INSTANCE);
                if (data == null || data.minimumWaferTier == 0) {
                    this.shouldMultiplyOutputs = false;
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                if (MTESolarFactory.this.mTier < data.tierRequired) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(data.tierRequired);
                }
                if (MTESolarFactory.this.mTier < 2) {
                    this.shouldMultiplyOutputs = false;
                }
                this.minimumTierForRecipe = data.minimumWaferTier;
                this.waferAmountInRecipe = data.minimumWaferCount;
                this.findWaferStack();
                if (this.foundWaferStack == null) {
                    this.clearVars();
                    return SimpleCheckRecipeResult.ofFailure("no_wafer");
                }
                if (this.minimumTierForRecipe > this.foundWaferTier) {
                    this.clearVars();
                    return SimpleCheckRecipeResult.ofFailure("low_wafer_tier");
                }
                if (this.waferAmountInRecipe > this.foundWaferStack.field_77994_a) {
                    this.clearVars();
                    return SimpleCheckRecipeResult.ofFailure("not_enough_wafer");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            private GTRecipe adjustRecipe(@Nonnull GTRecipe recipe) {
                GTRecipe tRecipe = recipe.copy();
                if (this.foundWaferStack != null) {
                    tRecipe.mInputs = (ItemStack[])ArrayUtils.add((Object[])tRecipe.mInputs, (Object)GTUtility.copyAmount(this.waferAmountInRecipe, this.foundWaferStack));
                }
                return tRecipe;
            }

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@Nonnull GTRecipe recipe) {
                return super.createParallelHelper(this.adjustRecipe(recipe));
            }
        }.setMaxParallelSupplier(this::getMaxParallel);
    }

    protected int getMaxParallel() {
        if (this.mTier <= 1) {
            return 1;
        }
        return (int)GTUtility.powInt(2.0, 1 + (this.casingTier + 2));
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.solarFactoryRecipes;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Solar Factory").addInfo("Controller block for the Solar Factory").addInfo("Produces solar panels in bulk").addInfo("The structure has 3 tiers, each allowing greater production than the last").addInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Tier " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "2" + EnumChatFormatting.WHITE + EnumChatFormatting.BOLD + " and above:").addInfo(EnumChatFormatting.GREEN + "  Supports Multi-Amp energy hatches").addInfo("  25% more outputs for every Wafer tier used above the minimum required").addInfo("  The bonus to output occurs after parallels, and cannot be greater than 100%").addInfo("  The recipes shown in NEI display the minimum wafer tier required").addInfo("  LV-LuV Solar Panels can be made without the previous panel, but at a higher cost").addInfo("  Parallels are based on Precise Casing Tier").addInfo("  MK-I = 8x, MK-II = 16x, MK-III = 32x, MK-IV = 64x").addInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Tier " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "3").addInfo(EnumChatFormatting.GREEN + "  Supports Laser energy hatches").addInfo("  ZPM-UV Solar Panels can be made without the previous panel, but at a higher cost").addInfo("  Bonus per increased wafer tier is raised to 50%").beginStructureBlock(7, 10, 9, false).addStructureInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Tier " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "1:").addCasingInfoRange("Clean Stainless Steel Machine Casing", 15, 41, false).addCasingInfoExactly("Any Tiered Glass", 24, false).addCasingInfoExactly("Damascus Steel Frame Box", 20, false).addStructureInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Tier " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "2:").addCasingInfoRange("Tungstensteel Machine Casing", 35, 101, false).addCasingInfoExactly("Any Tiered Glass", 74, false).addCasingInfoExactly("Tungsten Frame Box", 75, false).addCasingInfoExactly("Precise Electronic Unit Casing", 20, true).addStructureInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Tier " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "3:").addCasingInfoRange("Advanced Iridium Machine Casing", 50, 140, false).addCasingInfoExactly("Any Tiered Glass", 67, false).addCasingInfoExactly("Tungsten Frame Box", 24, false).addCasingInfoExactly("Precise Electronic Unit Casing", 26, true).addCasingInfoExactly("Black Plutonium Item Pipe", 6, false).addStructureInfo(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "All Tiers: ").addStructureInfo(EnumChatFormatting.WHITE + "Imprecise Unit Casings cannot be used").addInputHatch("Any Machine Casing").addInputBus("Any Machine Casing").addOutputBus("Any Machine Casing").addEnergyHatch("Any Machine Casing").addMaintenanceHatch("Any Machine Casing").addSubChannelUsage(GTStructureChannels.PRASS_UNIT_CASING).toolTipFinisher(GTValues.AuthorPureBluez);
        return tt;
    }

    private int getIndex(int tier) {
        if (tier <= 1) {
            return 49;
        }
        if (tier == 2) {
            return 48;
        }
        return 183;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.mTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && ((aValue & 0x80) == 0 || aValue == -1)) {
            this.mTier = aValue;
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex(this.mTier)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SOLAR_FACTORY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SOLAR_FACTORY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex(this.mTier)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SOLAR_FACTORY_INACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SOLAR_FACTORY_INACTIVE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getIndex(this.mTier))};
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }
}

