/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTELargeTurbinePlasma
extends MTELargeTurbine {
    public MTELargeTurbinePlasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbinePlasma(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][60];
        return iTextureArray;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Plasma Turbine, LPT").addInfo("Needs a Turbine, place inside controller").addInfo("Use your Fusion Reactor to produce the Plasma").beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Tungstensteel Turbine Casing", 8, 31, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Plasma Fluid, Side centered", 2).addOutputHatch("Molten Fluid, optional, Side centered", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GTRecipe tFuel = RecipeMaps.plasmaFuels.getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbinePlasma(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.plasmaFuels;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -1;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 12;
    }

    @Override
    public int getCasingTextureIndex() {
        return 60;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        if (!aFluids.isEmpty()) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (fuelValue <= 0) {
                return 0;
            }
            actualOptimalFlow = GTUtility.safeInt((long)Math.ceil((double)(this.looseFit ? turbine.getOptimalLoosePlasmaFlow() : turbine.getOptimalPlasmaFlow()) * 20.0 / (double)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GTUtility.safeInt((long)((float)actualOptimalFlow * (1.5f * (float)turbine.getOverflowEfficiency() + 1.0f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            String fn = FluidRegistry.getFluidName((FluidStack)firstFuelType);
            String[] nameSegments = fn.split("\\.", 2);
            if (nameSegments.length == 2) {
                String outputName = nameSegments[1];
                FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)totalFlow);
                if (output == null) {
                    output = FluidRegistry.getFluidStack((String)("molten." + outputName), (int)totalFlow);
                }
                if (output != null) {
                    this.addOutput(output);
                }
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GTUtility.safeInt((long)((double)fuelValue / 20.0 * (double)totalFlow));
            if (totalFlow != actualOptimalFlow) {
                float efficiency = this.getOverflowEfficiency(totalFlow, actualOptimalFlow, turbine.getOverflowEfficiency());
                tEU = (int)((float)tEU * efficiency);
            }
            if ((long)(tEU = GTUtility.safeInt((long)((this.looseFit ? turbine.getLoosePlasmaEfficiency() : turbine.getPlasmaEfficiency()) * (float)tEU))) > this.getMaximumOutput()) {
                tEU = GTUtility.safeInt(this.getMaximumOutput());
            }
            return tEU;
        }
        return 0;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier * 3 + 1)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        CheckRecipeResult status = super.checkProcessing();
        if (status == CheckRecipeResultRegistry.GENERATING) {
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 200;
            return CheckRecipeResultRegistry.GENERATING;
        }
        return status;
    }
}

