/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.common.items.ItemIntegratedCircuit;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class MTENameRemover
extends MTEBasicMachine {
    public MTENameRemover(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Can fix GT items with broken NBT data, will erase everything!", 2, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_GLOW).glow().build()));
    }

    public MTENameRemover(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENameRemover(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int checkRecipe() {
        if (this.getInputAt(0) == null) {
            return 0;
        }
        ItemStack output = this.getInputAt(0).func_77946_l();
        NBTTagCompound nbt = output.func_77978_p();
        if (nbt != null) {
            int circuitSetting = 0;
            ItemStack circuit = this.getInputAt(1);
            if (circuit != null && circuit.func_77973_b() instanceof ItemIntegratedCircuit) {
                circuitSetting = circuit.func_77960_j();
            }
            boolean removeName = false;
            boolean removeDisassembly = false;
            boolean removeColor = false;
            boolean removeRepair = false;
            boolean removeDye = false;
            boolean removeSpray = false;
            boolean removeMuffler = false;
            boolean removeCovers = false;
            switch (circuitSetting) {
                case 1: {
                    removeName = true;
                    break;
                }
                case 2: {
                    removeDisassembly = true;
                    break;
                }
                case 3: {
                    removeColor = true;
                    break;
                }
                case 4: {
                    removeRepair = true;
                    break;
                }
                case 5: {
                    removeDye = true;
                    break;
                }
                case 6: {
                    removeSpray = true;
                    break;
                }
                case 7: {
                    removeMuffler = true;
                    break;
                }
                case 24: {
                    removeCovers = true;
                }
                default: {
                    removeName = true;
                    removeDisassembly = true;
                    removeColor = true;
                    removeRepair = true;
                    removeDye = true;
                    removeSpray = true;
                    removeMuffler = true;
                }
            }
            if (removeName && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("Name");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeDisassembly) {
                MTENameRemover.removeTag(nbt, "GT.CraftingComponents");
            }
            if (removeColor) {
                MTENameRemover.removeTag(nbt, "color");
            }
            if (removeRepair) {
                MTENameRemover.removeTag(nbt, "RepairCost");
            }
            if (removeDye && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("color");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeSpray) {
                MTENameRemover.removeTag(nbt, "mColor");
            }
            if (removeMuffler) {
                MTENameRemover.removeTag(nbt, "mMuffler");
            }
            MTENameRemover.removeTag(nbt, "mTargetStackSize");
            MTENameRemover.removeTag(nbt, "mOutputFluid");
            MTENameRemover.removeTag(nbt, "mVoidOverflow");
            MTENameRemover.removeTag(nbt, "mVoidFluidFull");
            MTENameRemover.removeTag(nbt, "mLockFluid");
            MTENameRemover.removeTag(nbt, "lockedFluidName");
            MTENameRemover.removeTag(nbt, "mAllowInputFromOutputSide");
            MTENameRemover.removeTag(nbt, "mItemsPerSide");
            MTENameRemover.removeTag(nbt, "radiusConfig");
            MTENameRemover.removeTag(nbt, "mDisallowRetract");
            MTENameRemover.removeTag(nbt, "mStrongRedstone");
            MTENameRemover.removeTag(nbt, "mCoverSides");
            if (removeCovers) {
                MTENameRemover.removeTag(nbt, "mMuffler");
                MTENameRemover.removeTag(nbt, "mLockUpgrade");
                MTENameRemover.removeTag(nbt, "gt.covers");
                for (String key : CoverableTileEntity.COVER_DATA_NBT_KEYS) {
                    MTENameRemover.removeTag(nbt, key);
                }
            }
            if (nbt.func_82582_d()) {
                output.func_77982_d(null);
            }
        }
        if (this.canOutput(output)) {
            this.getInputAt((int)0).field_77994_a = 0;
            this.mEUt = 0;
            this.mMaxProgresstime = 20;
            this.mOutputItems[0] = output;
            return 2;
        }
        return 0;
    }

    private static void removeTag(NBTTagCompound nbt, String key) {
        if (nbt.func_74764_b(key)) {
            nbt.func_82580_o(key);
        }
    }

    @Override
    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Removes various NBT tags as well as covers.");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "First Slot" + EnumChatFormatting.RESET);
        description.add("The item you want to strip of NBT");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Second Slot" + EnumChatFormatting.RESET);
        description.add("One of the following circuits:");
        description.add(EnumChatFormatting.BOLD + "Circuit 1:" + EnumChatFormatting.RESET + "  Attempt to fix broken ores by removing the Display Name tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 3:" + EnumChatFormatting.RESET + "  Remove Railcraft stacking tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 4:" + EnumChatFormatting.RESET + "  Remove Anvil repair tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 5:" + EnumChatFormatting.RESET + "  Remove Dye from Leather armor");
        description.add(EnumChatFormatting.BOLD + "Circuit 6:" + EnumChatFormatting.RESET + "  Remove Spray color from GT items");
        description.add(EnumChatFormatting.BOLD + "Circuit 7:" + EnumChatFormatting.RESET + "  Remove Muffler Upgrade from GT machines");
        description.add(EnumChatFormatting.BOLD + "Circuit 24:" + EnumChatFormatting.RESET + "  Remove everything including covers. Be careful you won't recover the covers!");
        description.add(" ");
        description.add(EnumChatFormatting.BOLD + "No Circuit:" + EnumChatFormatting.RESET + " Remove everything except covers");
        return description.toArray(new String[0]);
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 0L;
    }

    @Override
    public long maxAmperesOut() {
        return 0L;
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(new FallbackableUITexture(GTUITextures.PROGRESSBAR_NAME_REMOVER)).build();
    }
}

