/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMonsterRepellent
extends MTETieredMachineBlock {
    private int mRange = -1;

    public MTEMonsterRepellent(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Repels nasty Creatures. Range: " + (4 + 12 * aTier) + " unpowered / " + (16 + 48 * aTier) + " powered. Costs " + (1L << aTier * 2) + " EU/t", new ITexture[0]);
    }

    public MTEMonsterRepellent(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMonsterRepellent(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection != ForgeDirection.UP) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        if (active) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_TELEPORTER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TELEPORTER_GLOW).glow().build()};
    }

    @Override
    public void onPostTick(IGregTechTileEntity mte, long aTimer) {
        if (mte.isServerSide()) {
            if (mte.isAllowedToWork()) {
                int prevRange = this.mRange;
                this.mRange = mte.isUniversalEnergyStored(this.getMinimumStoredEU()) && mte.decreaseStoredEnergyUnits(1L << this.mTier * 2, false) ? MTEMonsterRepellent.getRepellentRange(this.mTier, true) : MTEMonsterRepellent.getRepellentRange(this.mTier, false);
                if (prevRange != this.mRange) {
                    GTMod.proxy.spawnEventHandler.putRepellent(mte, this.mRange);
                }
            } else if (this.mRange != -1) {
                GTMod.proxy.spawnEventHandler.removeRepellent(mte);
                this.mRange = -1;
            }
        }
    }

    @Override
    public void onRemoval() {
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte.isServerSide()) {
            GTMod.proxy.spawnEventHandler.removeRepellent(mte);
        }
    }

    @Override
    public void onUnload() {
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte.isServerSide()) {
            GTMod.proxy.spawnEventHandler.removeRepellent(mte);
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    private static int getRepellentRange(int aTier, boolean powered) {
        return powered ? 16 + 48 * aTier : 4 + 12 * aTier;
    }
}

