/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicGenerator;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTESteamTurbine
extends MTEBasicGenerator {
    public MTESteamTurbine(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Converts Steam into EU", "Base rate: 2L of Steam -> 1 EU"}, new ITexture[0]);
    }

    public MTESteamTurbine(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamTurbine(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 2];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "Fuel Efficiency: " + 600 / this.getEfficiency() + "%";
        desc[this.mDescriptionArray.length + 1] = String.format("Consumes up to %sL of Steam per second", (int)(4000.0 * (8.0 * GTUtility.powInt(4.0, this.mTier) + GTUtility.powInt(2.0, Math.max(this.mTier - 1, 0))) / (double)(600 / this.getEfficiency())));
        return desc;
    }

    @Override
    public int getCapacity() {
        return 24000 * this.mTier;
    }

    @Override
    public int getEfficiency() {
        return 6 + this.mTier;
    }

    @Override
    public long getFuelValue(FluidStack aLiquid, boolean aLong) {
        return this.getFuelValue(aLiquid);
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        return GTModHandler.isAnySteam(aLiquid) ? 3 : 0;
    }

    @Override
    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return this.getEfficiency();
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_FRONT), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_FRONT_GLOW).glow().build()), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_BACK), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_BACK_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_BOTTOM), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_BOTTOM_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_TOP), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_TOP_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_SIDE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_SIDE_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_FRONT_ACTIVE_GLOW).glow().build()), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_BACK_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_BACK_ACTIVE_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_BOTTOM_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_BOTTOM_ACTIVE_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_TOP_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_TOP_ACTIVE_GLOW).glow().build())};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], TextureFactory.of(TextureFactory.of(Textures.BlockIcons.STEAM_TURBINE_SIDE_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.STEAM_TURBINE_SIDE_ACTIVE_GLOW).glow().build())};
    }

    @Override
    public int getPollution() {
        return 0;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        if (GTModHandler.isSuperHeatedSteam(aFluid)) {
            aFluid.amount = 0;
            return false;
        }
        return super.isFluidInputAllowed(aFluid);
    }
}

