/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.RenderOverlay;
import gregtech.api.render.TextureFactory;
import gregtech.common.render.GTRendererBlock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class GTRendererCasing
implements ISimpleBlockRenderingHandler {
    private static final GTRendererCasing INSTANCE = new GTRendererCasing();
    public static int mRenderID;
    private final ITexture[][] textureArray = new ITexture[6][2];

    public static void register() {
        mRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)INSTANCE);
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        this.setupBlockTexturesOnly(aBlock, aMeta, true);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[0], true);
        GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[1], true);
        GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[2], true);
        GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[3], true);
        GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[4], true);
        GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, this.textureArray[5], true);
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    private void setupBlockTexturesOnly(Block aBlock, int aMeta, boolean noCoord) {
        for (ForgeDirection tFace : ForgeDirection.VALID_DIRECTIONS) {
            this.textureArray[i][0] = noCoord ? TextureFactory.builder().setFromBlock(aBlock, aMeta).setFromSide(tFace).noWorldCoord().build() : TextureFactory.of(aBlock, aMeta, tFace);
            this.textureArray[i][1] = null;
        }
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = Minecraft.func_71379_u();
        aRenderer.field_147844_c = false;
        int tMeta = aWorld.func_72805_g(aX, aY, aZ);
        ITexture[] overlayed = RenderOverlay.get(aWorld, aX, aY, aZ);
        if (overlayed == null) {
            this.setupBlockTexturesOnly(aBlock, tMeta, false);
        } else {
            ForgeDirection[] validDirections = ForgeDirection.VALID_DIRECTIONS;
            int validDirectionsLength = validDirections.length;
            for (int i = 0; i < validDirectionsLength; ++i) {
                ForgeDirection tFace = validDirections[i];
                this.textureArray[i][0] = TextureFactory.of(aBlock, tMeta, tFace);
                this.textureArray[i][1] = overlayed[i];
            }
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[0], true);
        GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[1], true);
        GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[2], true);
        GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[3], true);
        GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[4], true);
        GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, this.textureArray[5], true);
        return true;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return mRenderID;
    }
}

