/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOres
extends BlockOresAbstract {
    private static final String UNLOCALIZED_NAME = "gt.blockores";

    public BlockOres() {
        super(UNLOCALIZED_NAME, 7, false, Material.field_151576_e);
    }

    @Override
    public String func_149739_a() {
        return UNLOCALIZED_NAME;
    }

    @Override
    public OrePrefixes[] getProcessingPrefix() {
        return new OrePrefixes[]{OrePrefixes.ore, OrePrefixes.oreNetherrack, OrePrefixes.oreEndstone, OrePrefixes.oreBlackgranite, OrePrefixes.oreRedgranite, OrePrefixes.oreMarble, OrePrefixes.oreBasalt, null};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int meta) {
        IIcon iIcon;
        int index = meta / 1000 % 16;
        switch (index) {
            case 1: {
                iIcon = Blocks.field_150424_aL.func_149691_a(ordinalSide, 0);
                break;
            }
            case 2: {
                iIcon = Blocks.field_150377_bs.func_149691_a(ordinalSide, 0);
                break;
            }
            case 3: {
                iIcon = Textures.BlockIcons.GRANITE_BLACK_STONE.getIcon();
                break;
            }
            case 4: {
                iIcon = Textures.BlockIcons.GRANITE_RED_STONE.getIcon();
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.MARBLE_STONE.getIcon();
                break;
            }
            case 6: {
                iIcon = Textures.BlockIcons.BASALT_STONE.getIcon();
                break;
            }
            default: {
                iIcon = Blocks.field_150348_b.func_149691_a(ordinalSide, 0);
            }
        }
        return iIcon;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP && this.func_149643_k(world, x, y, z) / 1000 % 16 == 1;
    }

    public MapColor func_149728_f(int meta) {
        return meta == 1 ? MapColor.field_151655_K : MapColor.field_151665_m;
    }

    @Override
    public int getBaseBlockHarvestLevel(int aMeta) {
        int n;
        switch (aMeta) {
            case 3: 
            case 4: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public Block getDroppedBlock() {
        return GregTechAPI.sBlockOres1;
    }

    @Override
    public Materials[] getDroppedDusts() {
        return new Materials[]{Materials.Stone, Materials.Netherrack, Materials.Endstone, Materials.GraniteBlack, Materials.GraniteRed, Materials.Marble, Materials.Basalt, Materials.Stone};
    }

    @Override
    public boolean[] getEnabledMetas() {
        return new boolean[]{true, true, true, GTMod.proxy.enableBlackGraniteOres, GTMod.proxy.enableRedGraniteOres, GTMod.proxy.enableMarbleOres, GTMod.proxy.enableBasaltOres, true};
    }

    @Override
    public ITexture[] getTextureSet() {
        Object[] rTextures = new ITexture[16];
        Arrays.fill(rTextures, TextureFactory.of(Blocks.field_150348_b));
        rTextures[1] = TextureFactory.of(Blocks.field_150424_aL);
        rTextures[2] = TextureFactory.of(Blocks.field_150377_bs);
        rTextures[3] = TextureFactory.builder().addIcon(Textures.BlockIcons.GRANITE_BLACK_STONE).stdOrient().build();
        rTextures[4] = TextureFactory.builder().addIcon(Textures.BlockIcons.GRANITE_RED_STONE).stdOrient().build();
        rTextures[5] = TextureFactory.builder().addIcon(Textures.BlockIcons.MARBLE_STONE).stdOrient().build();
        rTextures[6] = TextureFactory.builder().addIcon(Textures.BlockIcons.BASALT_STONE).stdOrient().build();
        return rTextures;
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            TileEntityOres.shouldSilkTouch = true;
            super.func_149636_a(worldIn, player, x, y, z, meta);
            if (TileEntityOres.shouldSilkTouch) {
                TileEntityOres.shouldSilkTouch = false;
            }
            return;
        }
        if (!(player instanceof FakePlayer)) {
            TileEntityOres.shouldFortune = true;
        }
        super.func_149636_a(worldIn, player, x, y, z, meta);
        if (TileEntityOres.shouldFortune) {
            TileEntityOres.shouldFortune = false;
        }
    }
}

