/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchNonConsumableBase;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.chemplant.MTEChemicalPlant;
import net.minecraft.item.ItemStack;

public class MTEHatchBulkCatalystHousing
extends MTEHatchNonConsumableBase {
    private int catalystCapacity = 0;

    public MTEHatchBulkCatalystHousing(int ID, String name, String nameRegional, int tier, int itemCapacity) {
        super(ID, name, nameRegional, tier, "Dedicated Catalyst Storage");
        this.catalystCapacity = itemCapacity;
    }

    public MTEHatchBulkCatalystHousing(String name, String[] description, ITexture[][][] textures, int tier, int itemCapacity) {
        super(name, tier, description, textures);
        this.catalystCapacity = itemCapacity;
    }

    @Override
    public int getItemCapacity() {
        return this.catalystCapacity;
    }

    public int getStoredCatalystMeta() {
        if (this.getItemStack() == null) {
            return -1;
        }
        return this.getItemStack().func_77960_j();
    }

    @Override
    public boolean isValidItem(ItemStack item) {
        return MTEChemicalPlant.isCatalyst(item);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Bus_Catalyst).extFacing().build(), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Bus_Catalyst).extFacing().glow().build()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Bus_Catalyst).extFacing().build(), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Bus_Catalyst).extFacing().glow().build()};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchBulkCatalystHousing(this.mName, this.mDescriptionArray, this.mTextures, (int)this.mTier, this.catalystCapacity);
    }
}

