/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.modularui;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public interface IControllerWithOptionalFeatures
extends IVoidable,
IRecipeLockable {
    public static final int POWER_PANEL_WINDOW_ID = 8;

    public boolean isAllowedToWork();

    public void disableWorking();

    public void enableWorking();

    public Pos2d getPowerSwitchButtonPos();

    default public ButtonWidget createPowerSwitchButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isAllowedToWork()) {
                this.disableWorking();
            } else {
                this.enableWorking();
            }
        }).setPlayClickSoundResource(() -> this.isAllowedToWork() ? SoundResource.GUI_BUTTON_UP.resourceLocation : SoundResource.GUI_BUTTON_DOWN.resourceLocation).setBackground(() -> {
            if (this.isAllowedToWork()) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isAllowedToWork, val -> {
            if (val.booleanValue()) {
                this.enableWorking();
            } else {
                this.disableWorking();
            }
        }), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.power_switch")).setTooltipShowUpDelay(5).setPos(this.getPowerSwitchButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public Pos2d getVoidingModeButtonPos();

    default public ButtonWidget createVoidExcessButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsVoidProtection()) {
                Set<VoidingMode> allowed = this.getAllowedVoidingModes();
                switch (clickData.mouseButton) {
                    case 0: {
                        this.setVoidingMode(this.getVoidingMode().nextInCollection(allowed));
                        break;
                    }
                    case 1: {
                        this.setVoidingMode(this.getVoidingMode().previousInCollection(allowed));
                    }
                }
                widget.notifyTooltipChange();
            }
        }).setPlayClickSound(this.supportsVoidProtection()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(this.getVoidingMode().buttonTextureLegacy);
            ret.add(this.getVoidingMode().buttonOverlayLegacy);
            if (!this.supportsVoidProtection()) {
                ret.add(GTUITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.getVoidingMode().ordinal(), val -> this.setVoidingMode(VoidingMode.fromOrdinal(val))), builder).dynamicTooltip(() -> Arrays.asList(StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode"), StatCollector.func_74838_a((String)this.getVoidingMode().getTransKey()))).setTooltipShowUpDelay(5).setPos(this.getVoidingModeButtonPos()).setSize(16, 16);
        if (!this.supportsVoidProtection()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return (ButtonWidget)button;
    }

    default public boolean supportsMachineModeSwitch() {
        return false;
    }

    default public int getMachineMode() {
        return 0;
    }

    default public String getMachineModeName() {
        return "Unknown Mode";
    }

    default public UITexture getMachineModeIcon(int index) {
        return null;
    }

    default public void setMachineMode(int index) {
    }

    default public int nextMachineMode() {
        return 0;
    }

    default public boolean getDefaultModeSwitch() {
        return this.supportsMachineModeSwitch();
    }

    public Pos2d getMachineModeSwitchButtonPos();

    default public void onMachineModeSwitchClick() {
    }

    default public ButtonWidget createModeSwitchButton(IWidgetBuilder<?> builder) {
        if (!this.supportsMachineModeSwitch()) {
            return null;
        }
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsMachineModeSwitch()) {
                this.onMachineModeSwitchClick();
                this.setMachineMode(this.nextMachineMode());
            }
        }).setPlayClickSound(this.supportsMachineModeSwitch()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (!this.supportsMachineModeSwitch()) {
                return null;
            }
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(this.getMachineModeIcon(this.getMachineMode()));
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getMachineMode, this::setMachineMode), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.mode_switch")).setTooltipShowUpDelay(5).setPos(this.getMachineModeSwitchButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public boolean supportsInputSeparation();

    public boolean isInputSeparationEnabled();

    public void setInputSeparation(boolean var1);

    default public boolean getDefaultInputSeparationMode() {
        return this.supportsInputSeparation();
    }

    public Pos2d getInputSeparationButtonPos();

    default public ButtonWidget createInputSeparationButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsInputSeparation()) {
                this.setInputSeparation(!this.isInputSeparationEnabled());
            }
        }).setPlayClickSound(this.supportsInputSeparation()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isInputSeparationEnabled()) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                if (this.supportsInputSeparation()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON_DISABLED);
                }
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                if (this.supportsInputSeparation()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF_DISABLED);
                }
            }
            if (!this.supportsInputSeparation()) {
                ret.add(GTUITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isInputSeparationEnabled, this::setInputSeparation), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.input_separation")).setTooltipShowUpDelay(5).setPos(this.getInputSeparationButtonPos()).setSize(16, 16);
        if (!this.supportsInputSeparation()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return (ButtonWidget)button;
    }

    public boolean supportsPowerPanel();

    public Pos2d getPowerPanelButtonPos();

    public ModularWindow createPowerPanel(EntityPlayer var1);

    default public ButtonWidget createPowerPanelButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsPowerPanel() && !widget.isClient()) {
                widget.getContext().openSyncedWindow(8);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_POWER_PANEL);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.power_panel")).setTooltipShowUpDelay(5).setPos(this.getPowerPanelButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public boolean supportsBatchMode();

    public boolean isBatchModeEnabled();

    public void setBatchMode(boolean var1);

    default public boolean getDefaultBatchMode() {
        return false;
    }

    public Pos2d getBatchModeButtonPos();

    default public ButtonWidget createBatchModeButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsBatchMode()) {
                this.setBatchMode(!this.isBatchModeEnabled());
            }
        }).setPlayClickSound(this.supportsBatchMode()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isBatchModeEnabled()) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                if (this.supportsBatchMode()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_ON);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_ON_DISABLED);
                }
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                if (this.supportsBatchMode()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_OFF);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_OFF_DISABLED);
                }
            }
            if (!this.supportsBatchMode()) {
                ret.add(GTUITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isBatchModeEnabled, this::setBatchMode), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.batch_mode")).setTooltipShowUpDelay(5).setPos(this.getBatchModeButtonPos()).setSize(16, 16);
        if (!this.supportsBatchMode()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return (ButtonWidget)button;
    }

    public Pos2d getRecipeLockingButtonPos();

    default public ButtonWidget createLockToSingleRecipeButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsSingleRecipeLocking()) {
                this.setRecipeLocking(!this.isRecipeLockingEnabled());
            }
        }).setPlayClickSound(this.supportsSingleRecipeLocking()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isRecipeLockingEnabled()) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                if (this.supportsSingleRecipeLocking()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_RECIPE_LOCKED);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_RECIPE_LOCKED_DISABLED);
                }
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                if (this.supportsSingleRecipeLocking()) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED_DISABLED);
                }
            }
            if (!this.supportsSingleRecipeLocking()) {
                ret.add(GTUITextures.OVERLAY_BUTTON_FORBIDDEN);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isRecipeLockingEnabled, this::setRecipeLocking), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.lock_recipe")).setTooltipShowUpDelay(5).setPos(this.getRecipeLockingButtonPos()).setSize(16, 16);
        if (!this.supportsSingleRecipeLocking()) {
            button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden"));
        }
        return (ButtonWidget)button;
    }

    public Pos2d getStructureUpdateButtonPos();

    public int getStructureUpdateTime();

    public void setStructureUpdateTime(int var1);

    default public ButtonWidget createStructureUpdateButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.getStructureUpdateTime() <= -20) {
                this.setStructureUpdateTime(1);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.getStructureUpdateTime() > -20) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
            }
            ret.add(GTUITextures.OVERLAY_BUTTON_STRUCTURE_UPDATE);
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getStructureUpdateTime, this::setStructureUpdateTime), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.structure_update")).setTooltipShowUpDelay(5).setPos(this.getStructureUpdateButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }
}

